/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.billing.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.billing.model.BillingRequest;
import software.amazon.awssdk.services.billing.model.BillingViewSourceViewsListCopier;
import software.amazon.awssdk.services.billing.model.Expression;
import software.amazon.awssdk.services.billing.model.ResourceTag;
import software.amazon.awssdk.services.billing.model.ResourceTagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateBillingViewRequest
extends BillingRequest
implements ToCopyableBuilder<Builder, CreateBillingViewRequest> {
    private static final SdkField<String> NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("name").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::name)).setter(CreateBillingViewRequest.setter(Builder::name)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::description)).setter(CreateBillingViewRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<String>> SOURCE_VIEWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("sourceViews").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::sourceViews)).setter(CreateBillingViewRequest.setter(Builder::sourceViews)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceViews").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Expression> DATA_FILTER_EXPRESSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("dataFilterExpression").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::dataFilterExpression)).setter(CreateBillingViewRequest.setter(Builder::dataFilterExpression)).constructor(Expression::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dataFilterExpression").build()}).build();
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::clientToken)).setter(CreateBillingViewRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<List<ResourceTag>> RESOURCE_TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("resourceTags").getter(CreateBillingViewRequest.getter(CreateBillingViewRequest::resourceTags)).setter(CreateBillingViewRequest.setter(Builder::resourceTags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceTags").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ResourceTag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, DESCRIPTION_FIELD, SOURCE_VIEWS_FIELD, DATA_FILTER_EXPRESSION_FIELD, CLIENT_TOKEN_FIELD, RESOURCE_TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateBillingViewRequest.memberNameToFieldInitializer();
    private final String name;
    private final String description;
    private final List<String> sourceViews;
    private final Expression dataFilterExpression;
    private final String clientToken;
    private final List<ResourceTag> resourceTags;

    private CreateBillingViewRequest(BuilderImpl builder) {
        super(builder);
        this.name = builder.name;
        this.description = builder.description;
        this.sourceViews = builder.sourceViews;
        this.dataFilterExpression = builder.dataFilterExpression;
        this.clientToken = builder.clientToken;
        this.resourceTags = builder.resourceTags;
    }

    public final String name() {
        return this.name;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasSourceViews() {
        return this.sourceViews != null && !(this.sourceViews instanceof SdkAutoConstructList);
    }

    public final List<String> sourceViews() {
        return this.sourceViews;
    }

    public final Expression dataFilterExpression() {
        return this.dataFilterExpression;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final boolean hasResourceTags() {
        return this.resourceTags != null && !(this.resourceTags instanceof SdkAutoConstructList);
    }

    public final List<ResourceTag> resourceTags() {
        return this.resourceTags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.name());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasSourceViews() ? this.sourceViews() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.dataFilterExpression());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasResourceTags() ? this.resourceTags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateBillingViewRequest)) {
            return false;
        }
        CreateBillingViewRequest other = (CreateBillingViewRequest)((Object)obj);
        return Objects.equals(this.name(), other.name()) && Objects.equals(this.description(), other.description()) && this.hasSourceViews() == other.hasSourceViews() && Objects.equals(this.sourceViews(), other.sourceViews()) && Objects.equals(this.dataFilterExpression(), other.dataFilterExpression()) && Objects.equals(this.clientToken(), other.clientToken()) && this.hasResourceTags() == other.hasResourceTags() && Objects.equals(this.resourceTags(), other.resourceTags());
    }

    public final String toString() {
        return ToString.builder((String)"CreateBillingViewRequest").add("Name", (Object)(this.name() == null ? null : "*** Sensitive Data Redacted ***")).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("SourceViews", this.hasSourceViews() ? this.sourceViews() : null).add("DataFilterExpression", (Object)this.dataFilterExpression()).add("ClientToken", (Object)this.clientToken()).add("ResourceTags", this.hasResourceTags() ? this.resourceTags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "name": {
                return Optional.ofNullable(clazz.cast(this.name()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "sourceViews": {
                return Optional.ofNullable(clazz.cast(this.sourceViews()));
            }
            case "dataFilterExpression": {
                return Optional.ofNullable(clazz.cast(this.dataFilterExpression()));
            }
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "resourceTags": {
                return Optional.ofNullable(clazz.cast(this.resourceTags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("name", NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("sourceViews", SOURCE_VIEWS_FIELD);
        map.put("dataFilterExpression", DATA_FILTER_EXPRESSION_FIELD);
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("resourceTags", RESOURCE_TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateBillingViewRequest, T> g) {
        return obj -> g.apply((CreateBillingViewRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BillingRequest.BuilderImpl
    implements Builder {
        private String name;
        private String description;
        private List<String> sourceViews = DefaultSdkAutoConstructList.getInstance();
        private Expression dataFilterExpression;
        private String clientToken;
        private List<ResourceTag> resourceTags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreateBillingViewRequest model) {
            super(model);
            this.name(model.name);
            this.description(model.description);
            this.sourceViews(model.sourceViews);
            this.dataFilterExpression(model.dataFilterExpression);
            this.clientToken(model.clientToken);
            this.resourceTags(model.resourceTags);
        }

        public final String getName() {
            return this.name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final Collection<String> getSourceViews() {
            if (this.sourceViews instanceof SdkAutoConstructList) {
                return null;
            }
            return this.sourceViews;
        }

        public final void setSourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
        }

        @Override
        public final Builder sourceViews(Collection<String> sourceViews) {
            this.sourceViews = BillingViewSourceViewsListCopier.copy(sourceViews);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sourceViews(String ... sourceViews) {
            this.sourceViews(Arrays.asList(sourceViews));
            return this;
        }

        public final Expression.Builder getDataFilterExpression() {
            return this.dataFilterExpression != null ? this.dataFilterExpression.toBuilder() : null;
        }

        public final void setDataFilterExpression(Expression.BuilderImpl dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression != null ? dataFilterExpression.build() : null;
        }

        @Override
        public final Builder dataFilterExpression(Expression dataFilterExpression) {
            this.dataFilterExpression = dataFilterExpression;
            return this;
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final List<ResourceTag.Builder> getResourceTags() {
            List<ResourceTag.Builder> result = ResourceTagListCopier.copyToBuilder(this.resourceTags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setResourceTags(Collection<ResourceTag.BuilderImpl> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copyFromBuilder(resourceTags);
        }

        @Override
        public final Builder resourceTags(Collection<ResourceTag> resourceTags) {
            this.resourceTags = ResourceTagListCopier.copy(resourceTags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(ResourceTag ... resourceTags) {
            this.resourceTags(Arrays.asList(resourceTags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceTags(Consumer<ResourceTag.Builder> ... resourceTags) {
            this.resourceTags(Stream.of(resourceTags).map(c -> (ResourceTag)((ResourceTag.Builder)ResourceTag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateBillingViewRequest build() {
            return new CreateBillingViewRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BillingRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateBillingViewRequest> {
        public Builder name(String var1);

        public Builder description(String var1);

        public Builder sourceViews(Collection<String> var1);

        public Builder sourceViews(String ... var1);

        public Builder dataFilterExpression(Expression var1);

        default public Builder dataFilterExpression(Consumer<Expression.Builder> dataFilterExpression) {
            return this.dataFilterExpression((Expression)((Expression.Builder)Expression.builder().applyMutation(dataFilterExpression)).build());
        }

        public Builder clientToken(String var1);

        public Builder resourceTags(Collection<ResourceTag> var1);

        public Builder resourceTags(ResourceTag ... var1);

        public Builder resourceTags(Consumer<ResourceTag.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

