/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ToolResultBlockDelta
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ToolResultBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ToolResultBlockDelta.getter(ToolResultBlockDelta::text)).setter(ToolResultBlockDelta.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<Document> JSON_FIELD = SdkField.builder((MarshallingType)MarshallingType.DOCUMENT).memberName("json").getter(ToolResultBlockDelta.getter(ToolResultBlockDelta::json)).setter(ToolResultBlockDelta.setter(Builder::json)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("json").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, JSON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ToolResultBlockDelta.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final Document json;
    private final Type type;

    private ToolResultBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.json = builder.json;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final Document json() {
        return this.json;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.json());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ToolResultBlockDelta)) {
            return false;
        }
        ToolResultBlockDelta other = (ToolResultBlockDelta)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.json(), other.json());
    }

    public final String toString() {
        return ToString.builder((String)"ToolResultBlockDelta").add("Text", (Object)this.text()).add("Json", (Object)this.json()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "json": {
                return Optional.ofNullable(clazz.cast(this.json()));
            }
        }
        return Optional.empty();
    }

    public static ToolResultBlockDelta fromText(String text) {
        return (ToolResultBlockDelta)ToolResultBlockDelta.builder().text(text).build();
    }

    public static ToolResultBlockDelta fromJson(Document json) {
        return (ToolResultBlockDelta)ToolResultBlockDelta.builder().json(json).build();
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("json", JSON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ToolResultBlockDelta, T> g) {
        return obj -> g.apply((ToolResultBlockDelta)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        JSON,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private Document json;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ToolResultBlockDelta model) {
            this.text(model.text);
            this.json(model.json);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final Document getJson() {
            return this.json;
        }

        public final void setJson(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
        }

        @Override
        public final Builder json(Document json) {
            Document oldValue = this.json;
            this.json = json;
            this.handleUnionValueChange(Type.JSON, oldValue, this.json);
            return this;
        }

        public ToolResultBlockDelta build() {
            return new ToolResultBlockDelta(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ToolResultBlockDelta> {
        public Builder text(String var1);

        public Builder json(Document var1);
    }
}

