/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.CitationsDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ImageBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ReasoningContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlocksDeltaCopier;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlockDelta;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBlockDelta
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ContentBlockDelta.getter(ContentBlockDelta::text)).setter(ContentBlockDelta.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ToolUseBlockDelta> TOOL_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUse").getter(ContentBlockDelta.getter(ContentBlockDelta::toolUse)).setter(ContentBlockDelta.setter(Builder::toolUse)).constructor(ToolUseBlockDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()}).build();
    private static final SdkField<List<ToolResultBlockDelta>> TOOL_RESULT_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("toolResult").getter(ContentBlockDelta.getter(ContentBlockDelta::toolResult)).setter(ContentBlockDelta.setter(Builder::toolResult)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ToolResultBlockDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<ReasoningContentBlockDelta> REASONING_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("reasoningContent").getter(ContentBlockDelta.getter(ContentBlockDelta::reasoningContent)).setter(ContentBlockDelta.setter(Builder::reasoningContent)).constructor(ReasoningContentBlockDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningContent").build()}).build();
    private static final SdkField<CitationsDelta> CITATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("citation").getter(ContentBlockDelta.getter(ContentBlockDelta::citation)).setter(ContentBlockDelta.setter(Builder::citation)).constructor(CitationsDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citation").build()}).build();
    private static final SdkField<ImageBlockDelta> IMAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("image").getter(ContentBlockDelta.getter(ContentBlockDelta::image)).setter(ContentBlockDelta.setter(Builder::image)).constructor(ImageBlockDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_FIELD, TOOL_RESULT_FIELD, REASONING_CONTENT_FIELD, CITATION_FIELD, IMAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ContentBlockDelta.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final ToolUseBlockDelta toolUse;
    private final List<ToolResultBlockDelta> toolResult;
    private final ReasoningContentBlockDelta reasoningContent;
    private final CitationsDelta citation;
    private final ImageBlockDelta image;
    private final Type type;

    private ContentBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.reasoningContent = builder.reasoningContent;
        this.citation = builder.citation;
        this.image = builder.image;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final ToolUseBlockDelta toolUse() {
        return this.toolUse;
    }

    public final boolean hasToolResult() {
        return this.toolResult != null && !(this.toolResult instanceof SdkAutoConstructList);
    }

    public final List<ToolResultBlockDelta> toolResult() {
        return this.toolResult;
    }

    public final ReasoningContentBlockDelta reasoningContent() {
        return this.reasoningContent;
    }

    public final CitationsDelta citation() {
        return this.citation;
    }

    public final ImageBlockDelta image() {
        return this.image;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasToolResult() ? this.toolResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.reasoningContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.citation());
        hashCode = 31 * hashCode + Objects.hashCode(this.image());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockDelta)) {
            return false;
        }
        ContentBlockDelta other = (ContentBlockDelta)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.toolUse(), other.toolUse()) && this.hasToolResult() == other.hasToolResult() && Objects.equals(this.toolResult(), other.toolResult()) && Objects.equals(this.reasoningContent(), other.reasoningContent()) && Objects.equals(this.citation(), other.citation()) && Objects.equals(this.image(), other.image());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBlockDelta").add("Text", (Object)this.text()).add("ToolUse", (Object)this.toolUse()).add("ToolResult", this.hasToolResult() ? this.toolResult() : null).add("ReasoningContent", (Object)(this.reasoningContent() == null ? null : "*** Sensitive Data Redacted ***")).add("Citation", (Object)this.citation()).add("Image", (Object)this.image()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "toolUse": {
                return Optional.ofNullable(clazz.cast(this.toolUse()));
            }
            case "toolResult": {
                return Optional.ofNullable(clazz.cast(this.toolResult()));
            }
            case "reasoningContent": {
                return Optional.ofNullable(clazz.cast(this.reasoningContent()));
            }
            case "citation": {
                return Optional.ofNullable(clazz.cast(this.citation()));
            }
            case "image": {
                return Optional.ofNullable(clazz.cast(this.image()));
            }
        }
        return Optional.empty();
    }

    public static ContentBlockDelta fromText(String text) {
        return (ContentBlockDelta)ContentBlockDelta.builder().text(text).build();
    }

    public static ContentBlockDelta fromToolUse(ToolUseBlockDelta toolUse) {
        return (ContentBlockDelta)ContentBlockDelta.builder().toolUse(toolUse).build();
    }

    public static ContentBlockDelta fromToolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
        ToolUseBlockDelta.Builder builder = ToolUseBlockDelta.builder();
        toolUse.accept(builder);
        return ContentBlockDelta.fromToolUse((ToolUseBlockDelta)builder.build());
    }

    public static ContentBlockDelta fromToolResult(List<ToolResultBlockDelta> toolResult) {
        return (ContentBlockDelta)ContentBlockDelta.builder().toolResult(toolResult).build();
    }

    public static ContentBlockDelta fromReasoningContent(ReasoningContentBlockDelta reasoningContent) {
        return (ContentBlockDelta)ContentBlockDelta.builder().reasoningContent(reasoningContent).build();
    }

    public static ContentBlockDelta fromReasoningContent(Consumer<ReasoningContentBlockDelta.Builder> reasoningContent) {
        ReasoningContentBlockDelta.Builder builder = ReasoningContentBlockDelta.builder();
        reasoningContent.accept(builder);
        return ContentBlockDelta.fromReasoningContent((ReasoningContentBlockDelta)builder.build());
    }

    public static ContentBlockDelta fromCitation(CitationsDelta citation) {
        return (ContentBlockDelta)ContentBlockDelta.builder().citation(citation).build();
    }

    public static ContentBlockDelta fromCitation(Consumer<CitationsDelta.Builder> citation) {
        CitationsDelta.Builder builder = CitationsDelta.builder();
        citation.accept(builder);
        return ContentBlockDelta.fromCitation((CitationsDelta)builder.build());
    }

    public static ContentBlockDelta fromImage(ImageBlockDelta image) {
        return (ContentBlockDelta)ContentBlockDelta.builder().image(image).build();
    }

    public static ContentBlockDelta fromImage(Consumer<ImageBlockDelta.Builder> image) {
        ImageBlockDelta.Builder builder = ImageBlockDelta.builder();
        image.accept(builder);
        return ContentBlockDelta.fromImage((ImageBlockDelta)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("reasoningContent", REASONING_CONTENT_FIELD);
        map.put("citation", CITATION_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockDelta, T> g) {
        return obj -> g.apply((ContentBlockDelta)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        TOOL_USE,
        TOOL_RESULT,
        REASONING_CONTENT,
        CITATION,
        IMAGE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private ToolUseBlockDelta toolUse;
        private List<ToolResultBlockDelta> toolResult = DefaultSdkAutoConstructList.getInstance();
        private ReasoningContentBlockDelta reasoningContent;
        private CitationsDelta citation;
        private ImageBlockDelta image;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlockDelta model) {
            this.text(model.text);
            this.toolUse(model.toolUse);
            this.toolResult(model.toolResult);
            this.reasoningContent(model.reasoningContent);
            this.citation(model.citation);
            this.image(model.image);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ToolUseBlockDelta.Builder getToolUse() {
            return this.toolUse != null ? this.toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlockDelta.BuilderImpl toolUse) {
            ToolUseBlockDelta oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlockDelta toolUse) {
            ToolUseBlockDelta oldValue = this.toolUse;
            this.toolUse = toolUse;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final List<ToolResultBlockDelta.Builder> getToolResult() {
            List<ToolResultBlockDelta.Builder> result = ToolResultBlocksDeltaCopier.copyToBuilder(this.toolResult);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolResult(Collection<ToolResultBlockDelta.BuilderImpl> toolResult) {
            List<ToolResultBlockDelta> oldValue = this.toolResult;
            this.toolResult = ToolResultBlocksDeltaCopier.copyFromBuilder(toolResult);
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(Collection<ToolResultBlockDelta> toolResult) {
            List<ToolResultBlockDelta> oldValue = this.toolResult;
            this.toolResult = ToolResultBlocksDeltaCopier.copy(toolResult);
            this.handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolResult(ToolResultBlockDelta ... toolResult) {
            this.toolResult(Arrays.asList(toolResult));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolResult(Consumer<ToolResultBlockDelta.Builder> ... toolResult) {
            this.toolResult(Stream.of(toolResult).map(c -> (ToolResultBlockDelta)((ToolResultBlockDelta.Builder)ToolResultBlockDelta.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final ReasoningContentBlockDelta.Builder getReasoningContent() {
            return this.reasoningContent != null ? this.reasoningContent.toBuilder() : null;
        }

        public final void setReasoningContent(ReasoningContentBlockDelta.BuilderImpl reasoningContent) {
            ReasoningContentBlockDelta oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent != null ? reasoningContent.build() : null;
            this.handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
        }

        @Override
        public final Builder reasoningContent(ReasoningContentBlockDelta reasoningContent) {
            ReasoningContentBlockDelta oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent;
            this.handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
            return this;
        }

        public final CitationsDelta.Builder getCitation() {
            return this.citation != null ? this.citation.toBuilder() : null;
        }

        public final void setCitation(CitationsDelta.BuilderImpl citation) {
            CitationsDelta oldValue = this.citation;
            this.citation = citation != null ? citation.build() : null;
            this.handleUnionValueChange(Type.CITATION, oldValue, this.citation);
        }

        @Override
        public final Builder citation(CitationsDelta citation) {
            CitationsDelta oldValue = this.citation;
            this.citation = citation;
            this.handleUnionValueChange(Type.CITATION, oldValue, this.citation);
            return this;
        }

        public final ImageBlockDelta.Builder getImage() {
            return this.image != null ? this.image.toBuilder() : null;
        }

        public final void setImage(ImageBlockDelta.BuilderImpl image) {
            ImageBlockDelta oldValue = this.image;
            this.image = image != null ? image.build() : null;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlockDelta image) {
            ImageBlockDelta oldValue = this.image;
            this.image = image;
            this.handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        public ContentBlockDelta build() {
            return new ContentBlockDelta(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBlockDelta> {
        public Builder text(String var1);

        public Builder toolUse(ToolUseBlockDelta var1);

        default public Builder toolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
            return this.toolUse((ToolUseBlockDelta)((ToolUseBlockDelta.Builder)ToolUseBlockDelta.builder().applyMutation(toolUse)).build());
        }

        public Builder toolResult(Collection<ToolResultBlockDelta> var1);

        public Builder toolResult(ToolResultBlockDelta ... var1);

        public Builder toolResult(Consumer<ToolResultBlockDelta.Builder> ... var1);

        public Builder reasoningContent(ReasoningContentBlockDelta var1);

        default public Builder reasoningContent(Consumer<ReasoningContentBlockDelta.Builder> reasoningContent) {
            return this.reasoningContent((ReasoningContentBlockDelta)((ReasoningContentBlockDelta.Builder)ReasoningContentBlockDelta.builder().applyMutation(reasoningContent)).build());
        }

        public Builder citation(CitationsDelta var1);

        default public Builder citation(Consumer<CitationsDelta.Builder> citation) {
            return this.citation((CitationsDelta)((CitationsDelta.Builder)CitationsDelta.builder().applyMutation(citation)).build());
        }

        public Builder image(ImageBlockDelta var1);

        default public Builder image(Consumer<ImageBlockDelta.Builder> image) {
            return this.image((ImageBlockDelta)((ImageBlockDelta.Builder)ImageBlockDelta.builder().applyMutation(image)).build());
        }
    }
}

