/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailOrigin;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailOriginListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailOwnership;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AppliedGuardrailDetails
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AppliedGuardrailDetails> {
    private static final SdkField<String> GUARDRAIL_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailId").getter(AppliedGuardrailDetails.getter(AppliedGuardrailDetails::guardrailId)).setter(AppliedGuardrailDetails.setter(Builder::guardrailId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailId").build()}).build();
    private static final SdkField<String> GUARDRAIL_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailVersion").getter(AppliedGuardrailDetails.getter(AppliedGuardrailDetails::guardrailVersion)).setter(AppliedGuardrailDetails.setter(Builder::guardrailVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailVersion").build()}).build();
    private static final SdkField<String> GUARDRAIL_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailArn").getter(AppliedGuardrailDetails.getter(AppliedGuardrailDetails::guardrailArn)).setter(AppliedGuardrailDetails.setter(Builder::guardrailArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailArn").build()}).build();
    private static final SdkField<List<String>> GUARDRAIL_ORIGIN_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("guardrailOrigin").getter(AppliedGuardrailDetails.getter(AppliedGuardrailDetails::guardrailOriginAsStrings)).setter(AppliedGuardrailDetails.setter(Builder::guardrailOriginWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailOrigin").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GUARDRAIL_OWNERSHIP_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailOwnership").getter(AppliedGuardrailDetails.getter(AppliedGuardrailDetails::guardrailOwnershipAsString)).setter(AppliedGuardrailDetails.setter(Builder::guardrailOwnership)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailOwnership").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ID_FIELD, GUARDRAIL_VERSION_FIELD, GUARDRAIL_ARN_FIELD, GUARDRAIL_ORIGIN_FIELD, GUARDRAIL_OWNERSHIP_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AppliedGuardrailDetails.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String guardrailId;
    private final String guardrailVersion;
    private final String guardrailArn;
    private final List<String> guardrailOrigin;
    private final String guardrailOwnership;

    private AppliedGuardrailDetails(BuilderImpl builder) {
        this.guardrailId = builder.guardrailId;
        this.guardrailVersion = builder.guardrailVersion;
        this.guardrailArn = builder.guardrailArn;
        this.guardrailOrigin = builder.guardrailOrigin;
        this.guardrailOwnership = builder.guardrailOwnership;
    }

    public final String guardrailId() {
        return this.guardrailId;
    }

    public final String guardrailVersion() {
        return this.guardrailVersion;
    }

    public final String guardrailArn() {
        return this.guardrailArn;
    }

    public final List<GuardrailOrigin> guardrailOrigin() {
        return GuardrailOriginListCopier.copyStringToEnum(this.guardrailOrigin);
    }

    public final boolean hasGuardrailOrigin() {
        return this.guardrailOrigin != null && !(this.guardrailOrigin instanceof SdkAutoConstructList);
    }

    public final List<String> guardrailOriginAsStrings() {
        return this.guardrailOrigin;
    }

    public final GuardrailOwnership guardrailOwnership() {
        return GuardrailOwnership.fromValue(this.guardrailOwnership);
    }

    public final String guardrailOwnershipAsString() {
        return this.guardrailOwnership;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailId());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasGuardrailOrigin() ? this.guardrailOriginAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailOwnershipAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AppliedGuardrailDetails)) {
            return false;
        }
        AppliedGuardrailDetails other = (AppliedGuardrailDetails)obj;
        return Objects.equals(this.guardrailId(), other.guardrailId()) && Objects.equals(this.guardrailVersion(), other.guardrailVersion()) && Objects.equals(this.guardrailArn(), other.guardrailArn()) && this.hasGuardrailOrigin() == other.hasGuardrailOrigin() && Objects.equals(this.guardrailOriginAsStrings(), other.guardrailOriginAsStrings()) && Objects.equals(this.guardrailOwnershipAsString(), other.guardrailOwnershipAsString());
    }

    public final String toString() {
        return ToString.builder((String)"AppliedGuardrailDetails").add("GuardrailId", (Object)this.guardrailId()).add("GuardrailVersion", (Object)this.guardrailVersion()).add("GuardrailArn", (Object)this.guardrailArn()).add("GuardrailOrigin", this.hasGuardrailOrigin() ? this.guardrailOriginAsStrings() : null).add("GuardrailOwnership", (Object)this.guardrailOwnershipAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailId": {
                return Optional.ofNullable(clazz.cast(this.guardrailId()));
            }
            case "guardrailVersion": {
                return Optional.ofNullable(clazz.cast(this.guardrailVersion()));
            }
            case "guardrailArn": {
                return Optional.ofNullable(clazz.cast(this.guardrailArn()));
            }
            case "guardrailOrigin": {
                return Optional.ofNullable(clazz.cast(this.guardrailOriginAsStrings()));
            }
            case "guardrailOwnership": {
                return Optional.ofNullable(clazz.cast(this.guardrailOwnershipAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailId", GUARDRAIL_ID_FIELD);
        map.put("guardrailVersion", GUARDRAIL_VERSION_FIELD);
        map.put("guardrailArn", GUARDRAIL_ARN_FIELD);
        map.put("guardrailOrigin", GUARDRAIL_ORIGIN_FIELD);
        map.put("guardrailOwnership", GUARDRAIL_OWNERSHIP_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AppliedGuardrailDetails, T> g) {
        return obj -> g.apply((AppliedGuardrailDetails)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String guardrailId;
        private String guardrailVersion;
        private String guardrailArn;
        private List<String> guardrailOrigin = DefaultSdkAutoConstructList.getInstance();
        private String guardrailOwnership;

        private BuilderImpl() {
        }

        private BuilderImpl(AppliedGuardrailDetails model) {
            this.guardrailId(model.guardrailId);
            this.guardrailVersion(model.guardrailVersion);
            this.guardrailArn(model.guardrailArn);
            this.guardrailOriginWithStrings(model.guardrailOrigin);
            this.guardrailOwnership(model.guardrailOwnership);
        }

        public final String getGuardrailId() {
            return this.guardrailId;
        }

        public final void setGuardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
        }

        @Override
        public final Builder guardrailId(String guardrailId) {
            this.guardrailId = guardrailId;
            return this;
        }

        public final String getGuardrailVersion() {
            return this.guardrailVersion;
        }

        public final void setGuardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
        }

        @Override
        public final Builder guardrailVersion(String guardrailVersion) {
            this.guardrailVersion = guardrailVersion;
            return this;
        }

        public final String getGuardrailArn() {
            return this.guardrailArn;
        }

        public final void setGuardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
        }

        @Override
        public final Builder guardrailArn(String guardrailArn) {
            this.guardrailArn = guardrailArn;
            return this;
        }

        public final Collection<String> getGuardrailOrigin() {
            if (this.guardrailOrigin instanceof SdkAutoConstructList) {
                return null;
            }
            return this.guardrailOrigin;
        }

        public final void setGuardrailOrigin(Collection<String> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copy(guardrailOrigin);
        }

        @Override
        public final Builder guardrailOriginWithStrings(Collection<String> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copy(guardrailOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailOriginWithStrings(String ... guardrailOrigin) {
            this.guardrailOriginWithStrings(Arrays.asList(guardrailOrigin));
            return this;
        }

        @Override
        public final Builder guardrailOrigin(Collection<GuardrailOrigin> guardrailOrigin) {
            this.guardrailOrigin = GuardrailOriginListCopier.copyEnumToString(guardrailOrigin);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder guardrailOrigin(GuardrailOrigin ... guardrailOrigin) {
            this.guardrailOrigin(Arrays.asList(guardrailOrigin));
            return this;
        }

        public final String getGuardrailOwnership() {
            return this.guardrailOwnership;
        }

        public final void setGuardrailOwnership(String guardrailOwnership) {
            this.guardrailOwnership = guardrailOwnership;
        }

        @Override
        public final Builder guardrailOwnership(String guardrailOwnership) {
            this.guardrailOwnership = guardrailOwnership;
            return this;
        }

        @Override
        public final Builder guardrailOwnership(GuardrailOwnership guardrailOwnership) {
            this.guardrailOwnership(guardrailOwnership == null ? null : guardrailOwnership.toString());
            return this;
        }

        public AppliedGuardrailDetails build() {
            return new AppliedGuardrailDetails(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AppliedGuardrailDetails> {
        public Builder guardrailId(String var1);

        public Builder guardrailVersion(String var1);

        public Builder guardrailArn(String var1);

        public Builder guardrailOriginWithStrings(Collection<String> var1);

        public Builder guardrailOriginWithStrings(String ... var1);

        public Builder guardrailOrigin(Collection<GuardrailOrigin> var1);

        public Builder guardrailOrigin(GuardrailOrigin ... var1);

        public Builder guardrailOwnership(String var1);

        public Builder guardrailOwnership(GuardrailOwnership var1);
    }
}

