/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Indicates that the claims could be either true or false depending on additional assumptions not provided in the
 * input.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailAutomatedReasoningSatisfiableFinding implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailAutomatedReasoningSatisfiableFinding.Builder, GuardrailAutomatedReasoningSatisfiableFinding> {
    private static final SdkField<GuardrailAutomatedReasoningTranslation> TRANSLATION_FIELD = SdkField
            .<GuardrailAutomatedReasoningTranslation> builder(MarshallingType.SDK_POJO).memberName("translation")
            .getter(getter(GuardrailAutomatedReasoningSatisfiableFinding::translation)).setter(setter(Builder::translation))
            .constructor(GuardrailAutomatedReasoningTranslation::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("translation").build()).build();

    private static final SdkField<GuardrailAutomatedReasoningScenario> CLAIMS_TRUE_SCENARIO_FIELD = SdkField
            .<GuardrailAutomatedReasoningScenario> builder(MarshallingType.SDK_POJO).memberName("claimsTrueScenario")
            .getter(getter(GuardrailAutomatedReasoningSatisfiableFinding::claimsTrueScenario))
            .setter(setter(Builder::claimsTrueScenario)).constructor(GuardrailAutomatedReasoningScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsTrueScenario").build())
            .build();

    private static final SdkField<GuardrailAutomatedReasoningScenario> CLAIMS_FALSE_SCENARIO_FIELD = SdkField
            .<GuardrailAutomatedReasoningScenario> builder(MarshallingType.SDK_POJO).memberName("claimsFalseScenario")
            .getter(getter(GuardrailAutomatedReasoningSatisfiableFinding::claimsFalseScenario))
            .setter(setter(Builder::claimsFalseScenario)).constructor(GuardrailAutomatedReasoningScenario::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("claimsFalseScenario").build())
            .build();

    private static final SdkField<GuardrailAutomatedReasoningLogicWarning> LOGIC_WARNING_FIELD = SdkField
            .<GuardrailAutomatedReasoningLogicWarning> builder(MarshallingType.SDK_POJO).memberName("logicWarning")
            .getter(getter(GuardrailAutomatedReasoningSatisfiableFinding::logicWarning)).setter(setter(Builder::logicWarning))
            .constructor(GuardrailAutomatedReasoningLogicWarning::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("logicWarning").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRANSLATION_FIELD,
            CLAIMS_TRUE_SCENARIO_FIELD, CLAIMS_FALSE_SCENARIO_FIELD, LOGIC_WARNING_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailAutomatedReasoningTranslation translation;

    private final GuardrailAutomatedReasoningScenario claimsTrueScenario;

    private final GuardrailAutomatedReasoningScenario claimsFalseScenario;

    private final GuardrailAutomatedReasoningLogicWarning logicWarning;

    private GuardrailAutomatedReasoningSatisfiableFinding(BuilderImpl builder) {
        this.translation = builder.translation;
        this.claimsTrueScenario = builder.claimsTrueScenario;
        this.claimsFalseScenario = builder.claimsFalseScenario;
        this.logicWarning = builder.logicWarning;
    }

    /**
     * <p>
     * The logical translation of the input that this finding evaluates.
     * </p>
     * 
     * @return The logical translation of the input that this finding evaluates.
     */
    public final GuardrailAutomatedReasoningTranslation translation() {
        return translation;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims could be logically true.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims could be logically true.
     */
    public final GuardrailAutomatedReasoningScenario claimsTrueScenario() {
        return claimsTrueScenario;
    }

    /**
     * <p>
     * An example scenario demonstrating how the claims could be logically false.
     * </p>
     * 
     * @return An example scenario demonstrating how the claims could be logically false.
     */
    public final GuardrailAutomatedReasoningScenario claimsFalseScenario() {
        return claimsFalseScenario;
    }

    /**
     * <p>
     * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
     * rules.
     * </p>
     * 
     * @return Indication of a logic issue with the translation without needing to consider the automated reasoning
     *         policy rules.
     */
    public final GuardrailAutomatedReasoningLogicWarning logicWarning() {
        return logicWarning;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(translation());
        hashCode = 31 * hashCode + Objects.hashCode(claimsTrueScenario());
        hashCode = 31 * hashCode + Objects.hashCode(claimsFalseScenario());
        hashCode = 31 * hashCode + Objects.hashCode(logicWarning());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailAutomatedReasoningSatisfiableFinding)) {
            return false;
        }
        GuardrailAutomatedReasoningSatisfiableFinding other = (GuardrailAutomatedReasoningSatisfiableFinding) obj;
        return Objects.equals(translation(), other.translation())
                && Objects.equals(claimsTrueScenario(), other.claimsTrueScenario())
                && Objects.equals(claimsFalseScenario(), other.claimsFalseScenario())
                && Objects.equals(logicWarning(), other.logicWarning());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailAutomatedReasoningSatisfiableFinding").add("Translation", translation())
                .add("ClaimsTrueScenario", claimsTrueScenario()).add("ClaimsFalseScenario", claimsFalseScenario())
                .add("LogicWarning", logicWarning()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "translation":
            return Optional.ofNullable(clazz.cast(translation()));
        case "claimsTrueScenario":
            return Optional.ofNullable(clazz.cast(claimsTrueScenario()));
        case "claimsFalseScenario":
            return Optional.ofNullable(clazz.cast(claimsFalseScenario()));
        case "logicWarning":
            return Optional.ofNullable(clazz.cast(logicWarning()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("translation", TRANSLATION_FIELD);
        map.put("claimsTrueScenario", CLAIMS_TRUE_SCENARIO_FIELD);
        map.put("claimsFalseScenario", CLAIMS_FALSE_SCENARIO_FIELD);
        map.put("logicWarning", LOGIC_WARNING_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailAutomatedReasoningSatisfiableFinding, T> g) {
        return obj -> g.apply((GuardrailAutomatedReasoningSatisfiableFinding) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailAutomatedReasoningSatisfiableFinding> {
        /**
         * <p>
         * The logical translation of the input that this finding evaluates.
         * </p>
         * 
         * @param translation
         *        The logical translation of the input that this finding evaluates.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder translation(GuardrailAutomatedReasoningTranslation translation);

        /**
         * <p>
         * The logical translation of the input that this finding evaluates.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningTranslation.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningTranslation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningTranslation.Builder#build()} is called
         * immediately and its result is passed to {@link #translation(GuardrailAutomatedReasoningTranslation)}.
         * 
         * @param translation
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningTranslation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #translation(GuardrailAutomatedReasoningTranslation)
         */
        default Builder translation(Consumer<GuardrailAutomatedReasoningTranslation.Builder> translation) {
            return translation(GuardrailAutomatedReasoningTranslation.builder().applyMutation(translation).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically true.
         * </p>
         * 
         * @param claimsTrueScenario
         *        An example scenario demonstrating how the claims could be logically true.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario claimsTrueScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically true.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningScenario.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsTrueScenario(GuardrailAutomatedReasoningScenario)}.
         * 
         * @param claimsTrueScenario
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsTrueScenario(GuardrailAutomatedReasoningScenario)
         */
        default Builder claimsTrueScenario(Consumer<GuardrailAutomatedReasoningScenario.Builder> claimsTrueScenario) {
            return claimsTrueScenario(GuardrailAutomatedReasoningScenario.builder().applyMutation(claimsTrueScenario).build());
        }

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically false.
         * </p>
         * 
         * @param claimsFalseScenario
         *        An example scenario demonstrating how the claims could be logically false.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder claimsFalseScenario(GuardrailAutomatedReasoningScenario claimsFalseScenario);

        /**
         * <p>
         * An example scenario demonstrating how the claims could be logically false.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningScenario.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningScenario#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningScenario.Builder#build()} is called
         * immediately and its result is passed to {@link #claimsFalseScenario(GuardrailAutomatedReasoningScenario)}.
         * 
         * @param claimsFalseScenario
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningScenario.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #claimsFalseScenario(GuardrailAutomatedReasoningScenario)
         */
        default Builder claimsFalseScenario(Consumer<GuardrailAutomatedReasoningScenario.Builder> claimsFalseScenario) {
            return claimsFalseScenario(GuardrailAutomatedReasoningScenario.builder().applyMutation(claimsFalseScenario).build());
        }

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * 
         * @param logicWarning
         *        Indication of a logic issue with the translation without needing to consider the automated reasoning
         *        policy rules.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning);

        /**
         * <p>
         * Indication of a logic issue with the translation without needing to consider the automated reasoning policy
         * rules.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link GuardrailAutomatedReasoningLogicWarning.Builder} avoiding the need to create one manually via
         * {@link GuardrailAutomatedReasoningLogicWarning#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailAutomatedReasoningLogicWarning.Builder#build()} is
         * called immediately and its result is passed to {@link #logicWarning(GuardrailAutomatedReasoningLogicWarning)}.
         * 
         * @param logicWarning
         *        a consumer that will call methods on {@link GuardrailAutomatedReasoningLogicWarning.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #logicWarning(GuardrailAutomatedReasoningLogicWarning)
         */
        default Builder logicWarning(Consumer<GuardrailAutomatedReasoningLogicWarning.Builder> logicWarning) {
            return logicWarning(GuardrailAutomatedReasoningLogicWarning.builder().applyMutation(logicWarning).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailAutomatedReasoningTranslation translation;

        private GuardrailAutomatedReasoningScenario claimsTrueScenario;

        private GuardrailAutomatedReasoningScenario claimsFalseScenario;

        private GuardrailAutomatedReasoningLogicWarning logicWarning;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailAutomatedReasoningSatisfiableFinding model) {
            translation(model.translation);
            claimsTrueScenario(model.claimsTrueScenario);
            claimsFalseScenario(model.claimsFalseScenario);
            logicWarning(model.logicWarning);
        }

        public final GuardrailAutomatedReasoningTranslation.Builder getTranslation() {
            return translation != null ? translation.toBuilder() : null;
        }

        public final void setTranslation(GuardrailAutomatedReasoningTranslation.BuilderImpl translation) {
            this.translation = translation != null ? translation.build() : null;
        }

        @Override
        public final Builder translation(GuardrailAutomatedReasoningTranslation translation) {
            this.translation = translation;
            return this;
        }

        public final GuardrailAutomatedReasoningScenario.Builder getClaimsTrueScenario() {
            return claimsTrueScenario != null ? claimsTrueScenario.toBuilder() : null;
        }

        public final void setClaimsTrueScenario(GuardrailAutomatedReasoningScenario.BuilderImpl claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario != null ? claimsTrueScenario.build() : null;
        }

        @Override
        public final Builder claimsTrueScenario(GuardrailAutomatedReasoningScenario claimsTrueScenario) {
            this.claimsTrueScenario = claimsTrueScenario;
            return this;
        }

        public final GuardrailAutomatedReasoningScenario.Builder getClaimsFalseScenario() {
            return claimsFalseScenario != null ? claimsFalseScenario.toBuilder() : null;
        }

        public final void setClaimsFalseScenario(GuardrailAutomatedReasoningScenario.BuilderImpl claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario != null ? claimsFalseScenario.build() : null;
        }

        @Override
        public final Builder claimsFalseScenario(GuardrailAutomatedReasoningScenario claimsFalseScenario) {
            this.claimsFalseScenario = claimsFalseScenario;
            return this;
        }

        public final GuardrailAutomatedReasoningLogicWarning.Builder getLogicWarning() {
            return logicWarning != null ? logicWarning.toBuilder() : null;
        }

        public final void setLogicWarning(GuardrailAutomatedReasoningLogicWarning.BuilderImpl logicWarning) {
            this.logicWarning = logicWarning != null ? logicWarning.build() : null;
        }

        @Override
        public final Builder logicWarning(GuardrailAutomatedReasoningLogicWarning logicWarning) {
            this.logicWarning = logicWarning;
            return this;
        }

        @Override
        public GuardrailAutomatedReasoningSatisfiableFinding build() {
            return new GuardrailAutomatedReasoningSatisfiableFinding(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
