/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A block of content in a streaming response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ContentBlockDelta implements SdkPojo, Serializable,
        ToCopyableBuilder<ContentBlockDelta.Builder, ContentBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(ContentBlockDelta::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<ToolUseBlockDelta> TOOL_USE_FIELD = SdkField
            .<ToolUseBlockDelta> builder(MarshallingType.SDK_POJO).memberName("toolUse")
            .getter(getter(ContentBlockDelta::toolUse)).setter(setter(Builder::toolUse)).constructor(ToolUseBlockDelta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()).build();

    private static final SdkField<List<ToolResultBlockDelta>> TOOL_RESULT_FIELD = SdkField
            .<List<ToolResultBlockDelta>> builder(MarshallingType.LIST)
            .memberName("toolResult")
            .getter(getter(ContentBlockDelta::toolResult))
            .setter(setter(Builder::toolResult))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolResult").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ToolResultBlockDelta> builder(MarshallingType.SDK_POJO)
                                            .constructor(ToolResultBlockDelta::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<ReasoningContentBlockDelta> REASONING_CONTENT_FIELD = SdkField
            .<ReasoningContentBlockDelta> builder(MarshallingType.SDK_POJO).memberName("reasoningContent")
            .getter(getter(ContentBlockDelta::reasoningContent)).setter(setter(Builder::reasoningContent))
            .constructor(ReasoningContentBlockDelta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reasoningContent").build()).build();

    private static final SdkField<CitationsDelta> CITATION_FIELD = SdkField.<CitationsDelta> builder(MarshallingType.SDK_POJO)
            .memberName("citation").getter(getter(ContentBlockDelta::citation)).setter(setter(Builder::citation))
            .constructor(CitationsDelta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citation").build()).build();

    private static final SdkField<ImageBlockDelta> IMAGE_FIELD = SdkField.<ImageBlockDelta> builder(MarshallingType.SDK_POJO)
            .memberName("image").getter(getter(ContentBlockDelta::image)).setter(setter(Builder::image))
            .constructor(ImageBlockDelta::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_FIELD,
            TOOL_RESULT_FIELD, REASONING_CONTENT_FIELD, CITATION_FIELD, IMAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String text;

    private final ToolUseBlockDelta toolUse;

    private final List<ToolResultBlockDelta> toolResult;

    private final ReasoningContentBlockDelta reasoningContent;

    private final CitationsDelta citation;

    private final ImageBlockDelta image;

    private final Type type;

    private ContentBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUse = builder.toolUse;
        this.toolResult = builder.toolResult;
        this.reasoningContent = builder.reasoningContent;
        this.citation = builder.citation;
        this.image = builder.image;
        this.type = builder.type;
    }

    /**
     * <p>
     * The content text.
     * </p>
     * 
     * @return The content text.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @return Information about a tool that the model is requesting to use.
     */
    public final ToolUseBlockDelta toolUse() {
        return toolUse;
    }

    /**
     * For responses, this returns true if the service returned a value for the ToolResult property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasToolResult() {
        return toolResult != null && !(toolResult instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An incremental update that contains the results from a tool call.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasToolResult} method.
     * </p>
     * 
     * @return An incremental update that contains the results from a tool call.
     */
    public final List<ToolResultBlockDelta> toolResult() {
        return toolResult;
    }

    /**
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @return Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *         Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public final ReasoningContentBlockDelta reasoningContent() {
        return reasoningContent;
    }

    /**
     * <p>
     * Incremental citation information that is streamed as part of the response generation process.
     * </p>
     * 
     * @return Incremental citation information that is streamed as part of the response generation process.
     */
    public final CitationsDelta citation() {
        return citation;
    }

    /**
     * <p>
     * A streaming delta event containing incremental image data.
     * </p>
     * 
     * @return A streaming delta event containing incremental image data.
     */
    public final ImageBlockDelta image() {
        return image;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(toolUse());
        hashCode = 31 * hashCode + Objects.hashCode(hasToolResult() ? toolResult() : null);
        hashCode = 31 * hashCode + Objects.hashCode(reasoningContent());
        hashCode = 31 * hashCode + Objects.hashCode(citation());
        hashCode = 31 * hashCode + Objects.hashCode(image());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockDelta)) {
            return false;
        }
        ContentBlockDelta other = (ContentBlockDelta) obj;
        return Objects.equals(text(), other.text()) && Objects.equals(toolUse(), other.toolUse())
                && hasToolResult() == other.hasToolResult() && Objects.equals(toolResult(), other.toolResult())
                && Objects.equals(reasoningContent(), other.reasoningContent()) && Objects.equals(citation(), other.citation())
                && Objects.equals(image(), other.image());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ContentBlockDelta").add("Text", text()).add("ToolUse", toolUse())
                .add("ToolResult", hasToolResult() ? toolResult() : null)
                .add("ReasoningContent", reasoningContent() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Citation", citation()).add("Image", image()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "toolUse":
            return Optional.ofNullable(clazz.cast(toolUse()));
        case "toolResult":
            return Optional.ofNullable(clazz.cast(toolResult()));
        case "reasoningContent":
            return Optional.ofNullable(clazz.cast(reasoningContent()));
        case "citation":
            return Optional.ofNullable(clazz.cast(citation()));
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #text()} initialized to the given value.
     *
     * <p>
     * The content text.
     * </p>
     * 
     * @param text
     *        The content text.
     */
    public static ContentBlockDelta fromText(String text) {
        return builder().text(text).build();
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool that the model is requesting to use.
     */
    public static ContentBlockDelta fromToolUse(ToolUseBlockDelta toolUse) {
        return builder().toolUse(toolUse).build();
    }

    /**
     * Create an instance of this class with {@link #toolUse()} initialized to the given value.
     *
     * <p>
     * Information about a tool that the model is requesting to use.
     * </p>
     * 
     * @param toolUse
     *        Information about a tool that the model is requesting to use.
     */
    public static ContentBlockDelta fromToolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
        ToolUseBlockDelta.Builder builder = ToolUseBlockDelta.builder();
        toolUse.accept(builder);
        return fromToolUse(builder.build());
    }

    /**
     * Create an instance of this class with {@link #toolResult()} initialized to the given value.
     *
     * <p>
     * An incremental update that contains the results from a tool call.
     * </p>
     * 
     * @param toolResult
     *        An incremental update that contains the results from a tool call.
     */
    public static ContentBlockDelta fromToolResult(List<ToolResultBlockDelta> toolResult) {
        return builder().toolResult(toolResult).build();
    }

    /**
     * Create an instance of this class with {@link #reasoningContent()} initialized to the given value.
     *
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @param reasoningContent
     *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *        Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public static ContentBlockDelta fromReasoningContent(ReasoningContentBlockDelta reasoningContent) {
        return builder().reasoningContent(reasoningContent).build();
    }

    /**
     * Create an instance of this class with {@link #reasoningContent()} initialized to the given value.
     *
     * <p>
     * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of Thought
     * (CoT) that the model generates to enhance the accuracy of its final response.
     * </p>
     * 
     * @param reasoningContent
     *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
     *        Thought (CoT) that the model generates to enhance the accuracy of its final response.
     */
    public static ContentBlockDelta fromReasoningContent(Consumer<ReasoningContentBlockDelta.Builder> reasoningContent) {
        ReasoningContentBlockDelta.Builder builder = ReasoningContentBlockDelta.builder();
        reasoningContent.accept(builder);
        return fromReasoningContent(builder.build());
    }

    /**
     * Create an instance of this class with {@link #citation()} initialized to the given value.
     *
     * <p>
     * Incremental citation information that is streamed as part of the response generation process.
     * </p>
     * 
     * @param citation
     *        Incremental citation information that is streamed as part of the response generation process.
     */
    public static ContentBlockDelta fromCitation(CitationsDelta citation) {
        return builder().citation(citation).build();
    }

    /**
     * Create an instance of this class with {@link #citation()} initialized to the given value.
     *
     * <p>
     * Incremental citation information that is streamed as part of the response generation process.
     * </p>
     * 
     * @param citation
     *        Incremental citation information that is streamed as part of the response generation process.
     */
    public static ContentBlockDelta fromCitation(Consumer<CitationsDelta.Builder> citation) {
        CitationsDelta.Builder builder = CitationsDelta.builder();
        citation.accept(builder);
        return fromCitation(builder.build());
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * A streaming delta event containing incremental image data.
     * </p>
     * 
     * @param image
     *        A streaming delta event containing incremental image data.
     */
    public static ContentBlockDelta fromImage(ImageBlockDelta image) {
        return builder().image(image).build();
    }

    /**
     * Create an instance of this class with {@link #image()} initialized to the given value.
     *
     * <p>
     * A streaming delta event containing incremental image data.
     * </p>
     * 
     * @param image
     *        A streaming delta event containing incremental image data.
     */
    public static ContentBlockDelta fromImage(Consumer<ImageBlockDelta.Builder> image) {
        ImageBlockDelta.Builder builder = ImageBlockDelta.builder();
        image.accept(builder);
        return fromImage(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("text", TEXT_FIELD);
        map.put("toolUse", TOOL_USE_FIELD);
        map.put("toolResult", TOOL_RESULT_FIELD);
        map.put("reasoningContent", REASONING_CONTENT_FIELD);
        map.put("citation", CITATION_FIELD);
        map.put("image", IMAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockDelta, T> g) {
        return obj -> g.apply((ContentBlockDelta) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ContentBlockDelta> {
        /**
         * <p>
         * The content text.
         * </p>
         * 
         * @param text
         *        The content text.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * Information about a tool that the model is requesting to use.
         * </p>
         * 
         * @param toolUse
         *        Information about a tool that the model is requesting to use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolUse(ToolUseBlockDelta toolUse);

        /**
         * <p>
         * Information about a tool that the model is requesting to use.
         * </p>
         * This is a convenience method that creates an instance of the {@link ToolUseBlockDelta.Builder} avoiding the
         * need to create one manually via {@link ToolUseBlockDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ToolUseBlockDelta.Builder#build()} is called immediately and its
         * result is passed to {@link #toolUse(ToolUseBlockDelta)}.
         * 
         * @param toolUse
         *        a consumer that will call methods on {@link ToolUseBlockDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolUse(ToolUseBlockDelta)
         */
        default Builder toolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
            return toolUse(ToolUseBlockDelta.builder().applyMutation(toolUse).build());
        }

        /**
         * <p>
         * An incremental update that contains the results from a tool call.
         * </p>
         * 
         * @param toolResult
         *        An incremental update that contains the results from a tool call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(Collection<ToolResultBlockDelta> toolResult);

        /**
         * <p>
         * An incremental update that contains the results from a tool call.
         * </p>
         * 
         * @param toolResult
         *        An incremental update that contains the results from a tool call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder toolResult(ToolResultBlockDelta... toolResult);

        /**
         * <p>
         * An incremental update that contains the results from a tool call.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlockDelta.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlockDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlockDelta.Builder#build()} is called
         * immediately and its result is passed to {@link #toolResult(List<ToolResultBlockDelta>)}.
         * 
         * @param toolResult
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.ToolResultBlockDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #toolResult(java.util.Collection<ToolResultBlockDelta>)
         */
        Builder toolResult(Consumer<ToolResultBlockDelta.Builder>... toolResult);

        /**
         * <p>
         * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
         * Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * </p>
         * 
         * @param reasoningContent
         *        Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain
         *        of Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder reasoningContent(ReasoningContentBlockDelta reasoningContent);

        /**
         * <p>
         * Contains content regarding the reasoning that is carried out by the model. Reasoning refers to a Chain of
         * Thought (CoT) that the model generates to enhance the accuracy of its final response.
         * </p>
         * This is a convenience method that creates an instance of the {@link ReasoningContentBlockDelta.Builder}
         * avoiding the need to create one manually via {@link ReasoningContentBlockDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ReasoningContentBlockDelta.Builder#build()} is called immediately
         * and its result is passed to {@link #reasoningContent(ReasoningContentBlockDelta)}.
         * 
         * @param reasoningContent
         *        a consumer that will call methods on {@link ReasoningContentBlockDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #reasoningContent(ReasoningContentBlockDelta)
         */
        default Builder reasoningContent(Consumer<ReasoningContentBlockDelta.Builder> reasoningContent) {
            return reasoningContent(ReasoningContentBlockDelta.builder().applyMutation(reasoningContent).build());
        }

        /**
         * <p>
         * Incremental citation information that is streamed as part of the response generation process.
         * </p>
         * 
         * @param citation
         *        Incremental citation information that is streamed as part of the response generation process.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citation(CitationsDelta citation);

        /**
         * <p>
         * Incremental citation information that is streamed as part of the response generation process.
         * </p>
         * This is a convenience method that creates an instance of the {@link CitationsDelta.Builder} avoiding the need
         * to create one manually via {@link CitationsDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CitationsDelta.Builder#build()} is called immediately and its
         * result is passed to {@link #citation(CitationsDelta)}.
         * 
         * @param citation
         *        a consumer that will call methods on {@link CitationsDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citation(CitationsDelta)
         */
        default Builder citation(Consumer<CitationsDelta.Builder> citation) {
            return citation(CitationsDelta.builder().applyMutation(citation).build());
        }

        /**
         * <p>
         * A streaming delta event containing incremental image data.
         * </p>
         * 
         * @param image
         *        A streaming delta event containing incremental image data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(ImageBlockDelta image);

        /**
         * <p>
         * A streaming delta event containing incremental image data.
         * </p>
         * This is a convenience method that creates an instance of the {@link ImageBlockDelta.Builder} avoiding the
         * need to create one manually via {@link ImageBlockDelta#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ImageBlockDelta.Builder#build()} is called immediately and its
         * result is passed to {@link #image(ImageBlockDelta)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link ImageBlockDelta.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(ImageBlockDelta)
         */
        default Builder image(Consumer<ImageBlockDelta.Builder> image) {
            return image(ImageBlockDelta.builder().applyMutation(image).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String text;

        private ToolUseBlockDelta toolUse;

        private List<ToolResultBlockDelta> toolResult = DefaultSdkAutoConstructList.getInstance();

        private ReasoningContentBlockDelta reasoningContent;

        private CitationsDelta citation;

        private ImageBlockDelta image;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlockDelta model) {
            text(model.text);
            toolUse(model.toolUse);
            toolResult(model.toolResult);
            reasoningContent(model.reasoningContent);
            citation(model.citation);
            image(model.image);
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            Object oldValue = this.text;
            this.text = text;
            handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ToolUseBlockDelta.Builder getToolUse() {
            return toolUse != null ? toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlockDelta.BuilderImpl toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlockDelta toolUse) {
            Object oldValue = this.toolUse;
            this.toolUse = toolUse;
            handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public final List<ToolResultBlockDelta.Builder> getToolResult() {
            List<ToolResultBlockDelta.Builder> result = ToolResultBlocksDeltaCopier.copyToBuilder(this.toolResult);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setToolResult(Collection<ToolResultBlockDelta.BuilderImpl> toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = ToolResultBlocksDeltaCopier.copyFromBuilder(toolResult);
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
        }

        @Override
        public final Builder toolResult(Collection<ToolResultBlockDelta> toolResult) {
            Object oldValue = this.toolResult;
            this.toolResult = ToolResultBlocksDeltaCopier.copy(toolResult);
            handleUnionValueChange(Type.TOOL_RESULT, oldValue, this.toolResult);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolResult(ToolResultBlockDelta... toolResult) {
            toolResult(Arrays.asList(toolResult));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder toolResult(Consumer<ToolResultBlockDelta.Builder>... toolResult) {
            toolResult(Stream.of(toolResult).map(c -> ToolResultBlockDelta.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final ReasoningContentBlockDelta.Builder getReasoningContent() {
            return reasoningContent != null ? reasoningContent.toBuilder() : null;
        }

        public final void setReasoningContent(ReasoningContentBlockDelta.BuilderImpl reasoningContent) {
            Object oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent != null ? reasoningContent.build() : null;
            handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
        }

        @Override
        public final Builder reasoningContent(ReasoningContentBlockDelta reasoningContent) {
            Object oldValue = this.reasoningContent;
            this.reasoningContent = reasoningContent;
            handleUnionValueChange(Type.REASONING_CONTENT, oldValue, this.reasoningContent);
            return this;
        }

        public final CitationsDelta.Builder getCitation() {
            return citation != null ? citation.toBuilder() : null;
        }

        public final void setCitation(CitationsDelta.BuilderImpl citation) {
            Object oldValue = this.citation;
            this.citation = citation != null ? citation.build() : null;
            handleUnionValueChange(Type.CITATION, oldValue, this.citation);
        }

        @Override
        public final Builder citation(CitationsDelta citation) {
            Object oldValue = this.citation;
            this.citation = citation;
            handleUnionValueChange(Type.CITATION, oldValue, this.citation);
            return this;
        }

        public final ImageBlockDelta.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(ImageBlockDelta.BuilderImpl image) {
            Object oldValue = this.image;
            this.image = image != null ? image.build() : null;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
        }

        @Override
        public final Builder image(ImageBlockDelta image) {
            Object oldValue = this.image;
            this.image = image;
            handleUnionValueChange(Type.IMAGE, oldValue, this.image);
            return this;
        }

        @Override
        public ContentBlockDelta build() {
            return new ContentBlockDelta(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ContentBlockDelta#type()
     */
    public enum Type {
        TEXT,

        TOOL_USE,

        TOOL_RESULT,

        REASONING_CONTENT,

        CITATION,

        IMAGE,

        UNKNOWN_TO_SDK_VERSION
    }
}
