/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * A content block that contains both generated text and associated citation information. This block type is returned
 * when document citations are enabled, providing traceability between the generated content and the source documents
 * that informed the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CitationsContentBlock implements SdkPojo, Serializable,
        ToCopyableBuilder<CitationsContentBlock.Builder, CitationsContentBlock> {
    private static final SdkField<List<CitationGeneratedContent>> CONTENT_FIELD = SdkField
            .<List<CitationGeneratedContent>> builder(MarshallingType.LIST)
            .memberName("content")
            .getter(getter(CitationsContentBlock::content))
            .setter(setter(Builder::content))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<CitationGeneratedContent> builder(MarshallingType.SDK_POJO)
                                            .constructor(CitationGeneratedContent::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<Citation>> CITATIONS_FIELD = SdkField
            .<List<Citation>> builder(MarshallingType.LIST)
            .memberName("citations")
            .getter(getter(CitationsContentBlock::citations))
            .setter(setter(Builder::citations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("citations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Citation> builder(MarshallingType.SDK_POJO)
                                            .constructor(Citation::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(CONTENT_FIELD, CITATIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<CitationGeneratedContent> content;

    private final List<Citation> citations;

    private CitationsContentBlock(BuilderImpl builder) {
        this.content = builder.content;
        this.citations = builder.citations;
    }

    /**
     * For responses, this returns true if the service returned a value for the Content property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasContent() {
        return content != null && !(content instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The generated content that is supported by the associated citations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContent} method.
     * </p>
     * 
     * @return The generated content that is supported by the associated citations.
     */
    public final List<CitationGeneratedContent> content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Citations property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasCitations() {
        return citations != null && !(citations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of citations that reference the source documents used to generate the associated content.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCitations} method.
     * </p>
     * 
     * @return An array of citations that reference the source documents used to generate the associated content.
     */
    public final List<Citation> citations() {
        return citations;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasContent() ? content() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCitations() ? citations() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CitationsContentBlock)) {
            return false;
        }
        CitationsContentBlock other = (CitationsContentBlock) obj;
        return hasContent() == other.hasContent() && Objects.equals(content(), other.content())
                && hasCitations() == other.hasCitations() && Objects.equals(citations(), other.citations());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CitationsContentBlock").add("Content", hasContent() ? content() : null)
                .add("Citations", hasCitations() ? citations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "citations":
            return Optional.ofNullable(clazz.cast(citations()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("citations", CITATIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CitationsContentBlock, T> g) {
        return obj -> g.apply((CitationsContentBlock) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CitationsContentBlock> {
        /**
         * <p>
         * The generated content that is supported by the associated citations.
         * </p>
         * 
         * @param content
         *        The generated content that is supported by the associated citations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(Collection<CitationGeneratedContent> content);

        /**
         * <p>
         * The generated content that is supported by the associated citations.
         * </p>
         * 
         * @param content
         *        The generated content that is supported by the associated citations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(CitationGeneratedContent... content);

        /**
         * <p>
         * The generated content that is supported by the associated citations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.CitationGeneratedContent.Builder} avoiding the
         * need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockruntime.model.CitationGeneratedContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.CitationGeneratedContent.Builder#build()} is
         * called immediately and its result is passed to {@link #content(List<CitationGeneratedContent>)}.
         * 
         * @param content
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.CitationGeneratedContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(java.util.Collection<CitationGeneratedContent>)
         */
        Builder content(Consumer<CitationGeneratedContent.Builder>... content);

        /**
         * <p>
         * An array of citations that reference the source documents used to generate the associated content.
         * </p>
         * 
         * @param citations
         *        An array of citations that reference the source documents used to generate the associated content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Collection<Citation> citations);

        /**
         * <p>
         * An array of citations that reference the source documents used to generate the associated content.
         * </p>
         * 
         * @param citations
         *        An array of citations that reference the source documents used to generate the associated content.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder citations(Citation... citations);

        /**
         * <p>
         * An array of citations that reference the source documents used to generate the associated content.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Citation.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.bedrockruntime.model.Citation#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockruntime.model.Citation.Builder#build()} is called immediately
         * and its result is passed to {@link #citations(List<Citation>)}.
         * 
         * @param citations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockruntime.model.Citation.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #citations(java.util.Collection<Citation>)
         */
        Builder citations(Consumer<Citation.Builder>... citations);
    }

    static final class BuilderImpl implements Builder {
        private List<CitationGeneratedContent> content = DefaultSdkAutoConstructList.getInstance();

        private List<Citation> citations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CitationsContentBlock model) {
            content(model.content);
            citations(model.citations);
        }

        public final List<CitationGeneratedContent.Builder> getContent() {
            List<CitationGeneratedContent.Builder> result = CitationGeneratedContentListCopier.copyToBuilder(this.content);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setContent(Collection<CitationGeneratedContent.BuilderImpl> content) {
            this.content = CitationGeneratedContentListCopier.copyFromBuilder(content);
        }

        @Override
        public final Builder content(Collection<CitationGeneratedContent> content) {
            this.content = CitationGeneratedContentListCopier.copy(content);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(CitationGeneratedContent... content) {
            content(Arrays.asList(content));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder content(Consumer<CitationGeneratedContent.Builder>... content) {
            content(Stream.of(content).map(c -> CitationGeneratedContent.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<Citation.Builder> getCitations() {
            List<Citation.Builder> result = CitationsCopier.copyToBuilder(this.citations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCitations(Collection<Citation.BuilderImpl> citations) {
            this.citations = CitationsCopier.copyFromBuilder(citations);
        }

        @Override
        public final Builder citations(Collection<Citation> citations) {
            this.citations = CitationsCopier.copy(citations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Citation... citations) {
            citations(Arrays.asList(citations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder citations(Consumer<Citation.Builder>... citations) {
            citations(Stream.of(citations).map(c -> Citation.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public CitationsContentBlock build() {
            return new CitationsContentBlock(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
