/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The action of the guardrail coverage details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class GuardrailCoverage implements SdkPojo, Serializable,
        ToCopyableBuilder<GuardrailCoverage.Builder, GuardrailCoverage> {
    private static final SdkField<GuardrailTextCharactersCoverage> TEXT_CHARACTERS_FIELD = SdkField
            .<GuardrailTextCharactersCoverage> builder(MarshallingType.SDK_POJO).memberName("textCharacters")
            .getter(getter(GuardrailCoverage::textCharacters)).setter(setter(Builder::textCharacters))
            .constructor(GuardrailTextCharactersCoverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textCharacters").build()).build();

    private static final SdkField<GuardrailImageCoverage> IMAGES_FIELD = SdkField
            .<GuardrailImageCoverage> builder(MarshallingType.SDK_POJO).memberName("images")
            .getter(getter(GuardrailCoverage::images)).setter(setter(Builder::images))
            .constructor(GuardrailImageCoverage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("images").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_CHARACTERS_FIELD,
            IMAGES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final GuardrailTextCharactersCoverage textCharacters;

    private final GuardrailImageCoverage images;

    private GuardrailCoverage(BuilderImpl builder) {
        this.textCharacters = builder.textCharacters;
        this.images = builder.images;
    }

    /**
     * <p>
     * The text characters of the guardrail coverage details.
     * </p>
     * 
     * @return The text characters of the guardrail coverage details.
     */
    public final GuardrailTextCharactersCoverage textCharacters() {
        return textCharacters;
    }

    /**
     * <p>
     * The guardrail coverage for images (the number of images that guardrails guarded).
     * </p>
     * 
     * @return The guardrail coverage for images (the number of images that guardrails guarded).
     */
    public final GuardrailImageCoverage images() {
        return images;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textCharacters());
        hashCode = 31 * hashCode + Objects.hashCode(images());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailCoverage)) {
            return false;
        }
        GuardrailCoverage other = (GuardrailCoverage) obj;
        return Objects.equals(textCharacters(), other.textCharacters()) && Objects.equals(images(), other.images());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GuardrailCoverage").add("TextCharacters", textCharacters()).add("Images", images()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textCharacters":
            return Optional.ofNullable(clazz.cast(textCharacters()));
        case "images":
            return Optional.ofNullable(clazz.cast(images()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textCharacters", TEXT_CHARACTERS_FIELD);
        map.put("images", IMAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GuardrailCoverage, T> g) {
        return obj -> g.apply((GuardrailCoverage) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, GuardrailCoverage> {
        /**
         * <p>
         * The text characters of the guardrail coverage details.
         * </p>
         * 
         * @param textCharacters
         *        The text characters of the guardrail coverage details.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textCharacters(GuardrailTextCharactersCoverage textCharacters);

        /**
         * <p>
         * The text characters of the guardrail coverage details.
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailTextCharactersCoverage.Builder}
         * avoiding the need to create one manually via {@link GuardrailTextCharactersCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailTextCharactersCoverage.Builder#build()} is called
         * immediately and its result is passed to {@link #textCharacters(GuardrailTextCharactersCoverage)}.
         * 
         * @param textCharacters
         *        a consumer that will call methods on {@link GuardrailTextCharactersCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #textCharacters(GuardrailTextCharactersCoverage)
         */
        default Builder textCharacters(Consumer<GuardrailTextCharactersCoverage.Builder> textCharacters) {
            return textCharacters(GuardrailTextCharactersCoverage.builder().applyMutation(textCharacters).build());
        }

        /**
         * <p>
         * The guardrail coverage for images (the number of images that guardrails guarded).
         * </p>
         * 
         * @param images
         *        The guardrail coverage for images (the number of images that guardrails guarded).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder images(GuardrailImageCoverage images);

        /**
         * <p>
         * The guardrail coverage for images (the number of images that guardrails guarded).
         * </p>
         * This is a convenience method that creates an instance of the {@link GuardrailImageCoverage.Builder} avoiding
         * the need to create one manually via {@link GuardrailImageCoverage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GuardrailImageCoverage.Builder#build()} is called immediately and
         * its result is passed to {@link #images(GuardrailImageCoverage)}.
         * 
         * @param images
         *        a consumer that will call methods on {@link GuardrailImageCoverage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #images(GuardrailImageCoverage)
         */
        default Builder images(Consumer<GuardrailImageCoverage.Builder> images) {
            return images(GuardrailImageCoverage.builder().applyMutation(images).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private GuardrailTextCharactersCoverage textCharacters;

        private GuardrailImageCoverage images;

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailCoverage model) {
            textCharacters(model.textCharacters);
            images(model.images);
        }

        public final GuardrailTextCharactersCoverage.Builder getTextCharacters() {
            return textCharacters != null ? textCharacters.toBuilder() : null;
        }

        public final void setTextCharacters(GuardrailTextCharactersCoverage.BuilderImpl textCharacters) {
            this.textCharacters = textCharacters != null ? textCharacters.build() : null;
        }

        @Override
        public final Builder textCharacters(GuardrailTextCharactersCoverage textCharacters) {
            this.textCharacters = textCharacters;
            return this;
        }

        public final GuardrailImageCoverage.Builder getImages() {
            return images != null ? images.toBuilder() : null;
        }

        public final void setImages(GuardrailImageCoverage.BuilderImpl images) {
            this.images = images != null ? images.build() : null;
        }

        @Override
        public final Builder images(GuardrailImageCoverage images) {
            this.images = images;
            return this;
        }

        @Override
        public GuardrailCoverage build() {
            return new GuardrailCoverage(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
