/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.CachePointBlock;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailConverseContentBlock;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SystemContentBlock
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SystemContentBlock> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(SystemContentBlock.getter(SystemContentBlock::text)).setter(SystemContentBlock.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<GuardrailConverseContentBlock> GUARD_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("guardContent").getter(SystemContentBlock.getter(SystemContentBlock::guardContent)).setter(SystemContentBlock.setter(Builder::guardContent)).constructor(GuardrailConverseContentBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardContent").build()}).build();
    private static final SdkField<CachePointBlock> CACHE_POINT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cachePoint").getter(SystemContentBlock.getter(SystemContentBlock::cachePoint)).setter(SystemContentBlock.setter(Builder::cachePoint)).constructor(CachePointBlock::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cachePoint").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, GUARD_CONTENT_FIELD, CACHE_POINT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SystemContentBlock.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String text;
    private final GuardrailConverseContentBlock guardContent;
    private final CachePointBlock cachePoint;
    private final Type type;

    private SystemContentBlock(BuilderImpl builder) {
        this.text = builder.text;
        this.guardContent = builder.guardContent;
        this.cachePoint = builder.cachePoint;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final GuardrailConverseContentBlock guardContent() {
        return this.guardContent;
    }

    public final CachePointBlock cachePoint() {
        return this.cachePoint;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.guardContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.cachePoint());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SystemContentBlock)) {
            return false;
        }
        SystemContentBlock other = (SystemContentBlock)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.guardContent(), other.guardContent()) && Objects.equals(this.cachePoint(), other.cachePoint());
    }

    public final String toString() {
        return ToString.builder((String)"SystemContentBlock").add("Text", (Object)this.text()).add("GuardContent", (Object)this.guardContent()).add("CachePoint", (Object)this.cachePoint()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "guardContent": {
                return Optional.ofNullable(clazz.cast(this.guardContent()));
            }
            case "cachePoint": {
                return Optional.ofNullable(clazz.cast(this.cachePoint()));
            }
        }
        return Optional.empty();
    }

    public static SystemContentBlock fromText(String text) {
        return (SystemContentBlock)SystemContentBlock.builder().text(text).build();
    }

    public static SystemContentBlock fromGuardContent(GuardrailConverseContentBlock guardContent) {
        return (SystemContentBlock)SystemContentBlock.builder().guardContent(guardContent).build();
    }

    public static SystemContentBlock fromGuardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
        GuardrailConverseContentBlock.Builder builder = GuardrailConverseContentBlock.builder();
        guardContent.accept(builder);
        return SystemContentBlock.fromGuardContent((GuardrailConverseContentBlock)builder.build());
    }

    public static SystemContentBlock fromCachePoint(CachePointBlock cachePoint) {
        return (SystemContentBlock)SystemContentBlock.builder().cachePoint(cachePoint).build();
    }

    public static SystemContentBlock fromCachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
        CachePointBlock.Builder builder = CachePointBlock.builder();
        cachePoint.accept(builder);
        return SystemContentBlock.fromCachePoint((CachePointBlock)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("text", TEXT_FIELD);
        map.put("guardContent", GUARD_CONTENT_FIELD);
        map.put("cachePoint", CACHE_POINT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SystemContentBlock, T> g) {
        return obj -> g.apply((SystemContentBlock)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        GUARD_CONTENT,
        CACHE_POINT,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private GuardrailConverseContentBlock guardContent;
        private CachePointBlock cachePoint;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SystemContentBlock model) {
            this.text(model.text);
            this.guardContent(model.guardContent);
            this.cachePoint(model.cachePoint);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final GuardrailConverseContentBlock.Builder getGuardContent() {
            return this.guardContent != null ? this.guardContent.toBuilder() : null;
        }

        public final void setGuardContent(GuardrailConverseContentBlock.BuilderImpl guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent != null ? guardContent.build() : null;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
        }

        @Override
        public final Builder guardContent(GuardrailConverseContentBlock guardContent) {
            GuardrailConverseContentBlock oldValue = this.guardContent;
            this.guardContent = guardContent;
            this.handleUnionValueChange(Type.GUARD_CONTENT, oldValue, this.guardContent);
            return this;
        }

        public final CachePointBlock.Builder getCachePoint() {
            return this.cachePoint != null ? this.cachePoint.toBuilder() : null;
        }

        public final void setCachePoint(CachePointBlock.BuilderImpl cachePoint) {
            CachePointBlock oldValue = this.cachePoint;
            this.cachePoint = cachePoint != null ? cachePoint.build() : null;
            this.handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
        }

        @Override
        public final Builder cachePoint(CachePointBlock cachePoint) {
            CachePointBlock oldValue = this.cachePoint;
            this.cachePoint = cachePoint;
            this.handleUnionValueChange(Type.CACHE_POINT, oldValue, this.cachePoint);
            return this;
        }

        public SystemContentBlock build() {
            return new SystemContentBlock(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SystemContentBlock> {
        public Builder text(String var1);

        public Builder guardContent(GuardrailConverseContentBlock var1);

        default public Builder guardContent(Consumer<GuardrailConverseContentBlock.Builder> guardContent) {
            return this.guardContent((GuardrailConverseContentBlock)((GuardrailConverseContentBlock.Builder)GuardrailConverseContentBlock.builder().applyMutation(guardContent)).build());
        }

        public Builder cachePoint(CachePointBlock var1);

        default public Builder cachePoint(Consumer<CachePointBlock.Builder> cachePoint) {
            return this.cachePoint((CachePointBlock)((CachePointBlock.Builder)CachePointBlock.builder().applyMutation(cachePoint)).build());
        }
    }
}

