/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput;

import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;

/**
 * A specialization of {@code software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent} that
 * represents the {@code ConverseStreamOutput$contentBlockDelta} event. Do not use this class directly. Instead, use the
 * static builder methods on {@link software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamOutput}.
 */
@SdkInternalApi
@Generated("software.amazon.awssdk:codegen")
public final class DefaultContentBlockDelta extends ContentBlockDeltaEvent {
    private static final long serialVersionUID = 1L;

    DefaultContentBlockDelta(BuilderImpl builderImpl) {
        super(builderImpl);
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    @Override
    public void accept(ConverseStreamResponseHandler.Visitor visitor) {
        visitor.visitContentBlockDelta(this);
    }

    @Override
    public ConverseStreamOutput.EventType sdkEventType() {
        return ConverseStreamOutput.EventType.CONTENT_BLOCK_DELTA;
    }

    public interface Builder extends ContentBlockDeltaEvent.Builder {
        @Override
        DefaultContentBlockDelta build();
    }

    private static final class BuilderImpl extends ContentBlockDeltaEvent.BuilderImpl implements Builder {
        private BuilderImpl() {
        }

        private BuilderImpl(DefaultContentBlockDelta event) {
            super(event);
        }

        @Override
        public DefaultContentBlockDelta build() {
            return new DefaultContentBlockDelta(this);
        }
    }
}
