/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.SdkPublicApi;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockDeltaEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ContentBlockStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamMetadataEvent;
import software.amazon.awssdk.services.bedrockruntime.model.ConverseStreamResponseHandler;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStartEvent;
import software.amazon.awssdk.services.bedrockruntime.model.MessageStopEvent;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockDelta;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockStart;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultContentBlockStop;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMessageStart;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMessageStop;
import software.amazon.awssdk.services.bedrockruntime.model.conversestreamoutput.DefaultMetadata;
import software.amazon.awssdk.utils.internal.EnumUtils;

@SdkPublicApi
public interface ConverseStreamOutput
extends SdkPojo {
    public static final ConverseStreamOutput UNKNOWN = new ConverseStreamOutput(){

        public List<SdkField<?>> sdkFields() {
            return Collections.emptyList();
        }

        @Override
        public void accept(ConverseStreamResponseHandler.Visitor visitor) {
            visitor.visitDefault(this);
        }
    };

    public static MessageStartEvent.Builder messageStartBuilder() {
        return DefaultMessageStart.builder();
    }

    public static ContentBlockStartEvent.Builder contentBlockStartBuilder() {
        return DefaultContentBlockStart.builder();
    }

    public static ContentBlockDeltaEvent.Builder contentBlockDeltaBuilder() {
        return DefaultContentBlockDelta.builder();
    }

    public static ContentBlockStopEvent.Builder contentBlockStopBuilder() {
        return DefaultContentBlockStop.builder();
    }

    public static MessageStopEvent.Builder messageStopBuilder() {
        return DefaultMessageStop.builder();
    }

    public static ConverseStreamMetadataEvent.Builder metadataBuilder() {
        return DefaultMetadata.builder();
    }

    default public EventType sdkEventType() {
        return EventType.UNKNOWN_TO_SDK_VERSION;
    }

    public void accept(ConverseStreamResponseHandler.Visitor var1);

    public static enum EventType {
        MESSAGE_START("messageStart"),
        CONTENT_BLOCK_START("contentBlockStart"),
        CONTENT_BLOCK_DELTA("contentBlockDelta"),
        CONTENT_BLOCK_STOP("contentBlockStop"),
        MESSAGE_STOP("messageStop"),
        METADATA("metadata"),
        UNKNOWN_TO_SDK_VERSION(null);

        private static final Map<String, EventType> VALUE_MAP;
        private final String value;

        private EventType(String value) {
            this.value = value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static EventType fromValue(String value) {
            if (value == null) {
                return null;
            }
            return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
        }

        public static Set<EventType> knownValues() {
            EnumSet<EventType> knownValues = EnumSet.allOf(EventType.class);
            knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
            return knownValues;
        }

        static {
            VALUE_MAP = EnumUtils.uniqueIndex(EventType.class, EventType::toString);
        }
    }
}

