/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWord;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailCustomWordListCopier;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWord;
import software.amazon.awssdk.services.bedrockruntime.model.GuardrailManagedWordListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GuardrailWordPolicyAssessment
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, GuardrailWordPolicyAssessment> {
    private static final SdkField<List<GuardrailCustomWord>> CUSTOM_WORDS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customWords").getter(GuardrailWordPolicyAssessment.getter(GuardrailWordPolicyAssessment::customWords)).setter(GuardrailWordPolicyAssessment.setter(Builder::customWords)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customWords").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailCustomWord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<GuardrailManagedWord>> MANAGED_WORD_LISTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("managedWordLists").getter(GuardrailWordPolicyAssessment.getter(GuardrailWordPolicyAssessment::managedWordLists)).setter(GuardrailWordPolicyAssessment.setter(Builder::managedWordLists)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("managedWordLists").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(GuardrailManagedWord::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_WORDS_FIELD, MANAGED_WORD_LISTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("customWords", CUSTOM_WORDS_FIELD);
            this.put("managedWordLists", MANAGED_WORD_LISTS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final List<GuardrailCustomWord> customWords;
    private final List<GuardrailManagedWord> managedWordLists;

    private GuardrailWordPolicyAssessment(BuilderImpl builder) {
        this.customWords = builder.customWords;
        this.managedWordLists = builder.managedWordLists;
    }

    public final boolean hasCustomWords() {
        return this.customWords != null && !(this.customWords instanceof SdkAutoConstructList);
    }

    public final List<GuardrailCustomWord> customWords() {
        return this.customWords;
    }

    public final boolean hasManagedWordLists() {
        return this.managedWordLists != null && !(this.managedWordLists instanceof SdkAutoConstructList);
    }

    public final List<GuardrailManagedWord> managedWordLists() {
        return this.managedWordLists;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomWords() ? this.customWords() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasManagedWordLists() ? this.managedWordLists() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GuardrailWordPolicyAssessment)) {
            return false;
        }
        GuardrailWordPolicyAssessment other = (GuardrailWordPolicyAssessment)obj;
        return this.hasCustomWords() == other.hasCustomWords() && Objects.equals(this.customWords(), other.customWords()) && this.hasManagedWordLists() == other.hasManagedWordLists() && Objects.equals(this.managedWordLists(), other.managedWordLists());
    }

    public final String toString() {
        return ToString.builder((String)"GuardrailWordPolicyAssessment").add("CustomWords", this.hasCustomWords() ? this.customWords() : null).add("ManagedWordLists", this.hasManagedWordLists() ? this.managedWordLists() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customWords": {
                return Optional.ofNullable(clazz.cast(this.customWords()));
            }
            case "managedWordLists": {
                return Optional.ofNullable(clazz.cast(this.managedWordLists()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<GuardrailWordPolicyAssessment, T> g) {
        return obj -> g.apply((GuardrailWordPolicyAssessment)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<GuardrailCustomWord> customWords = DefaultSdkAutoConstructList.getInstance();
        private List<GuardrailManagedWord> managedWordLists = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(GuardrailWordPolicyAssessment model) {
            this.customWords(model.customWords);
            this.managedWordLists(model.managedWordLists);
        }

        public final List<GuardrailCustomWord.Builder> getCustomWords() {
            List<GuardrailCustomWord.Builder> result = GuardrailCustomWordListCopier.copyToBuilder(this.customWords);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomWords(Collection<GuardrailCustomWord.BuilderImpl> customWords) {
            this.customWords = GuardrailCustomWordListCopier.copyFromBuilder(customWords);
        }

        @Override
        public final Builder customWords(Collection<GuardrailCustomWord> customWords) {
            this.customWords = GuardrailCustomWordListCopier.copy(customWords);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customWords(GuardrailCustomWord ... customWords) {
            this.customWords(Arrays.asList(customWords));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customWords(Consumer<GuardrailCustomWord.Builder> ... customWords) {
            this.customWords(Stream.of(customWords).map(c -> (GuardrailCustomWord)((GuardrailCustomWord.Builder)GuardrailCustomWord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<GuardrailManagedWord.Builder> getManagedWordLists() {
            List<GuardrailManagedWord.Builder> result = GuardrailManagedWordListCopier.copyToBuilder(this.managedWordLists);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManagedWordLists(Collection<GuardrailManagedWord.BuilderImpl> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListCopier.copyFromBuilder(managedWordLists);
        }

        @Override
        public final Builder managedWordLists(Collection<GuardrailManagedWord> managedWordLists) {
            this.managedWordLists = GuardrailManagedWordListCopier.copy(managedWordLists);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(GuardrailManagedWord ... managedWordLists) {
            this.managedWordLists(Arrays.asList(managedWordLists));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder managedWordLists(Consumer<GuardrailManagedWord.Builder> ... managedWordLists) {
            this.managedWordLists(Stream.of(managedWordLists).map(c -> (GuardrailManagedWord)((GuardrailManagedWord.Builder)GuardrailManagedWord.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public GuardrailWordPolicyAssessment build() {
            return new GuardrailWordPolicyAssessment(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, GuardrailWordPolicyAssessment> {
        public Builder customWords(Collection<GuardrailCustomWord> var1);

        public Builder customWords(GuardrailCustomWord ... var1);

        public Builder customWords(Consumer<GuardrailCustomWord.Builder> ... var1);

        public Builder managedWordLists(Collection<GuardrailManagedWord> var1);

        public Builder managedWordLists(GuardrailManagedWord ... var1);

        public Builder managedWordLists(Consumer<GuardrailManagedWord.Builder> ... var1);
    }
}

