/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.ToolSpecification;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Tool
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Tool> {
    private static final SdkField<ToolSpecification> TOOL_SPEC_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolSpec").getter(Tool.getter(Tool::toolSpec)).setter(Tool.setter(Builder::toolSpec)).constructor(ToolSpecification::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolSpec").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TOOL_SPEC_FIELD));
    private static final long serialVersionUID = 1L;
    private final ToolSpecification toolSpec;
    private final Type type;

    private Tool(BuilderImpl builder) {
        this.toolSpec = builder.toolSpec;
        this.type = builder.type;
    }

    public final ToolSpecification toolSpec() {
        return this.toolSpec;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.toolSpec());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Tool)) {
            return false;
        }
        Tool other = (Tool)obj;
        return Objects.equals(this.toolSpec(), other.toolSpec());
    }

    public final String toString() {
        return ToString.builder((String)"Tool").add("ToolSpec", (Object)this.toolSpec()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "toolSpec": {
                return Optional.ofNullable(clazz.cast(this.toolSpec()));
            }
        }
        return Optional.empty();
    }

    public static Tool fromToolSpec(ToolSpecification toolSpec) {
        return (Tool)Tool.builder().toolSpec(toolSpec).build();
    }

    public static Tool fromToolSpec(Consumer<ToolSpecification.Builder> toolSpec) {
        ToolSpecification.Builder builder = ToolSpecification.builder();
        toolSpec.accept(builder);
        return Tool.fromToolSpec((ToolSpecification)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Tool, T> g) {
        return obj -> g.apply((Tool)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TOOL_SPEC,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private ToolSpecification toolSpec;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(Tool model) {
            this.toolSpec(model.toolSpec);
        }

        public final ToolSpecification.Builder getToolSpec() {
            return this.toolSpec != null ? this.toolSpec.toBuilder() : null;
        }

        public final void setToolSpec(ToolSpecification.BuilderImpl toolSpec) {
            ToolSpecification oldValue = this.toolSpec;
            this.toolSpec = toolSpec != null ? toolSpec.build() : null;
            this.handleUnionValueChange(Type.TOOL_SPEC, oldValue, this.toolSpec);
        }

        @Override
        public final Builder toolSpec(ToolSpecification toolSpec) {
            ToolSpecification oldValue = this.toolSpec;
            this.toolSpec = toolSpec;
            this.handleUnionValueChange(Type.TOOL_SPEC, oldValue, this.toolSpec);
            return this;
        }

        public Tool build() {
            return new Tool(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Tool> {
        public Builder toolSpec(ToolSpecification var1);

        default public Builder toolSpec(Consumer<ToolSpecification.Builder> toolSpec) {
            return this.toolSpec((ToolSpecification)((ToolSpecification.Builder)ToolSpecification.builder().applyMutation(toolSpec)).build());
        }
    }
}

