/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockruntime.model.ToolUseBlockDelta;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ContentBlockDelta
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ContentBlockDelta> {
    private static final SdkField<String> TEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("text").getter(ContentBlockDelta.getter(ContentBlockDelta::text)).setter(ContentBlockDelta.setter(Builder::text)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()}).build();
    private static final SdkField<ToolUseBlockDelta> TOOL_USE_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("toolUse").getter(ContentBlockDelta.getter(ContentBlockDelta::toolUse)).setter(ContentBlockDelta.setter(Builder::toolUse)).constructor(ToolUseBlockDelta::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("toolUse").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_FIELD, TOOL_USE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String text;
    private final ToolUseBlockDelta toolUse;
    private final Type type;

    private ContentBlockDelta(BuilderImpl builder) {
        this.text = builder.text;
        this.toolUse = builder.toolUse;
        this.type = builder.type;
    }

    public final String text() {
        return this.text;
    }

    public final ToolUseBlockDelta toolUse() {
        return this.toolUse;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.text());
        hashCode = 31 * hashCode + Objects.hashCode(this.toolUse());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ContentBlockDelta)) {
            return false;
        }
        ContentBlockDelta other = (ContentBlockDelta)obj;
        return Objects.equals(this.text(), other.text()) && Objects.equals(this.toolUse(), other.toolUse());
    }

    public final String toString() {
        return ToString.builder((String)"ContentBlockDelta").add("Text", (Object)this.text()).add("ToolUse", (Object)this.toolUse()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "text": {
                return Optional.ofNullable(clazz.cast(this.text()));
            }
            case "toolUse": {
                return Optional.ofNullable(clazz.cast(this.toolUse()));
            }
        }
        return Optional.empty();
    }

    public static ContentBlockDelta fromText(String text) {
        return (ContentBlockDelta)ContentBlockDelta.builder().text(text).build();
    }

    public static ContentBlockDelta fromToolUse(ToolUseBlockDelta toolUse) {
        return (ContentBlockDelta)ContentBlockDelta.builder().toolUse(toolUse).build();
    }

    public static ContentBlockDelta fromToolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
        ToolUseBlockDelta.Builder builder = ToolUseBlockDelta.builder();
        toolUse.accept(builder);
        return ContentBlockDelta.fromToolUse((ToolUseBlockDelta)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ContentBlockDelta, T> g) {
        return obj -> g.apply((ContentBlockDelta)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        TEXT,
        TOOL_USE,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private String text;
        private ToolUseBlockDelta toolUse;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ContentBlockDelta model) {
            this.text(model.text);
            this.toolUse(model.toolUse);
        }

        public final String getText() {
            return this.text;
        }

        public final void setText(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
        }

        @Override
        public final Builder text(String text) {
            String oldValue = this.text;
            this.text = text;
            this.handleUnionValueChange(Type.TEXT, oldValue, this.text);
            return this;
        }

        public final ToolUseBlockDelta.Builder getToolUse() {
            return this.toolUse != null ? this.toolUse.toBuilder() : null;
        }

        public final void setToolUse(ToolUseBlockDelta.BuilderImpl toolUse) {
            ToolUseBlockDelta oldValue = this.toolUse;
            this.toolUse = toolUse != null ? toolUse.build() : null;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
        }

        @Override
        public final Builder toolUse(ToolUseBlockDelta toolUse) {
            ToolUseBlockDelta oldValue = this.toolUse;
            this.toolUse = toolUse;
            this.handleUnionValueChange(Type.TOOL_USE, oldValue, this.toolUse);
            return this;
        }

        public ContentBlockDelta build() {
            return new ContentBlockDelta(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ContentBlockDelta> {
        public Builder text(String var1);

        public Builder toolUse(ToolUseBlockDelta var1);

        default public Builder toolUse(Consumer<ToolUseBlockDelta.Builder> toolUse) {
            return this.toolUse((ToolUseBlockDelta)((ToolUseBlockDelta.Builder)ToolUseBlockDelta.builder().applyMutation(toolUse)).build());
        }
    }
}

