/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * An error occurred while streaming the response.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ModelStreamErrorException extends BedrockRuntimeException implements
        ToCopyableBuilder<ModelStreamErrorException.Builder, ModelStreamErrorException> {
    private static final SdkField<Integer> ORIGINAL_STATUS_CODE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("originalStatusCode").getter(getter(ModelStreamErrorException::originalStatusCode))
            .setter(setter(Builder::originalStatusCode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originalStatusCode").build())
            .build();

    private static final SdkField<String> ORIGINAL_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("originalMessage").getter(getter(ModelStreamErrorException::originalMessage))
            .setter(setter(Builder::originalMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("originalMessage").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ORIGINAL_STATUS_CODE_FIELD,
            ORIGINAL_MESSAGE_FIELD));

    private static final long serialVersionUID = 1L;

    private final Integer originalStatusCode;

    private final String originalMessage;

    private ModelStreamErrorException(BuilderImpl builder) {
        super(builder);
        this.originalStatusCode = builder.originalStatusCode;
        this.originalMessage = builder.originalMessage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * The original status code.
     * </p>
     * 
     * @return The original status code.
     */
    public Integer originalStatusCode() {
        return originalStatusCode;
    }

    /**
     * <p>
     * The original message.
     * </p>
     * 
     * @return The original message.
     */
    public String originalMessage() {
        return originalMessage;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ModelStreamErrorException, T> g) {
        return obj -> g.apply((ModelStreamErrorException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ModelStreamErrorException>,
            BedrockRuntimeException.Builder {
        /**
         * <p>
         * The original status code.
         * </p>
         * 
         * @param originalStatusCode
         *        The original status code.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalStatusCode(Integer originalStatusCode);

        /**
         * <p>
         * The original message.
         * </p>
         * 
         * @param originalMessage
         *        The original message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder originalMessage(String originalMessage);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);
    }

    static final class BuilderImpl extends BedrockRuntimeException.BuilderImpl implements Builder {
        private Integer originalStatusCode;

        private String originalMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ModelStreamErrorException model) {
            super(model);
            originalStatusCode(model.originalStatusCode);
            originalMessage(model.originalMessage);
        }

        public final Integer getOriginalStatusCode() {
            return originalStatusCode;
        }

        public final void setOriginalStatusCode(Integer originalStatusCode) {
            this.originalStatusCode = originalStatusCode;
        }

        @Override
        public final Builder originalStatusCode(Integer originalStatusCode) {
            this.originalStatusCode = originalStatusCode;
            return this;
        }

        public final String getOriginalMessage() {
            return originalMessage;
        }

        public final void setOriginalMessage(String originalMessage) {
            this.originalMessage = originalMessage;
        }

        @Override
        public final Builder originalMessage(String originalMessage) {
            this.originalMessage = originalMessage;
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public ModelStreamErrorException build() {
            return new ModelStreamErrorException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
