/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioGenerativeOutputLanguage;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioInputLanguagesCopier;
import software.amazon.awssdk.services.bedrockdataautomation.model.Language;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioLanguageConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioLanguageConfiguration> {
    private static final SdkField<List<String>> INPUT_LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("inputLanguages").getter(AudioLanguageConfiguration.getter(AudioLanguageConfiguration::inputLanguagesAsStrings)).setter(AudioLanguageConfiguration.setter(Builder::inputLanguagesWithStrings)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputLanguages").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> GENERATIVE_OUTPUT_LANGUAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("generativeOutputLanguage").getter(AudioLanguageConfiguration.getter(AudioLanguageConfiguration::generativeOutputLanguageAsString)).setter(AudioLanguageConfiguration.setter(Builder::generativeOutputLanguage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeOutputLanguage").build()}).build();
    private static final SdkField<Boolean> IDENTIFY_MULTIPLE_LANGUAGES_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("identifyMultipleLanguages").getter(AudioLanguageConfiguration.getter(AudioLanguageConfiguration::identifyMultipleLanguages)).setter(AudioLanguageConfiguration.setter(Builder::identifyMultipleLanguages)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identifyMultipleLanguages").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_LANGUAGES_FIELD, GENERATIVE_OUTPUT_LANGUAGE_FIELD, IDENTIFY_MULTIPLE_LANGUAGES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = AudioLanguageConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<String> inputLanguages;
    private final String generativeOutputLanguage;
    private final Boolean identifyMultipleLanguages;

    private AudioLanguageConfiguration(BuilderImpl builder) {
        this.inputLanguages = builder.inputLanguages;
        this.generativeOutputLanguage = builder.generativeOutputLanguage;
        this.identifyMultipleLanguages = builder.identifyMultipleLanguages;
    }

    public final List<Language> inputLanguages() {
        return AudioInputLanguagesCopier.copyStringToEnum(this.inputLanguages);
    }

    public final boolean hasInputLanguages() {
        return this.inputLanguages != null && !(this.inputLanguages instanceof SdkAutoConstructList);
    }

    public final List<String> inputLanguagesAsStrings() {
        return this.inputLanguages;
    }

    public final AudioGenerativeOutputLanguage generativeOutputLanguage() {
        return AudioGenerativeOutputLanguage.fromValue(this.generativeOutputLanguage);
    }

    public final String generativeOutputLanguageAsString() {
        return this.generativeOutputLanguage;
    }

    public final Boolean identifyMultipleLanguages() {
        return this.identifyMultipleLanguages;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInputLanguages() ? this.inputLanguagesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeOutputLanguageAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.identifyMultipleLanguages());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioLanguageConfiguration)) {
            return false;
        }
        AudioLanguageConfiguration other = (AudioLanguageConfiguration)obj;
        return this.hasInputLanguages() == other.hasInputLanguages() && Objects.equals(this.inputLanguagesAsStrings(), other.inputLanguagesAsStrings()) && Objects.equals(this.generativeOutputLanguageAsString(), other.generativeOutputLanguageAsString()) && Objects.equals(this.identifyMultipleLanguages(), other.identifyMultipleLanguages());
    }

    public final String toString() {
        return ToString.builder((String)"AudioLanguageConfiguration").add("InputLanguages", this.hasInputLanguages() ? this.inputLanguagesAsStrings() : null).add("GenerativeOutputLanguage", (Object)this.generativeOutputLanguageAsString()).add("IdentifyMultipleLanguages", (Object)this.identifyMultipleLanguages()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "inputLanguages": {
                return Optional.ofNullable(clazz.cast(this.inputLanguagesAsStrings()));
            }
            case "generativeOutputLanguage": {
                return Optional.ofNullable(clazz.cast(this.generativeOutputLanguageAsString()));
            }
            case "identifyMultipleLanguages": {
                return Optional.ofNullable(clazz.cast(this.identifyMultipleLanguages()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("inputLanguages", INPUT_LANGUAGES_FIELD);
        map.put("generativeOutputLanguage", GENERATIVE_OUTPUT_LANGUAGE_FIELD);
        map.put("identifyMultipleLanguages", IDENTIFY_MULTIPLE_LANGUAGES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AudioLanguageConfiguration, T> g) {
        return obj -> g.apply((AudioLanguageConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<String> inputLanguages = DefaultSdkAutoConstructList.getInstance();
        private String generativeOutputLanguage;
        private Boolean identifyMultipleLanguages;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioLanguageConfiguration model) {
            this.inputLanguagesWithStrings(model.inputLanguages);
            this.generativeOutputLanguage(model.generativeOutputLanguage);
            this.identifyMultipleLanguages(model.identifyMultipleLanguages);
        }

        public final Collection<String> getInputLanguages() {
            if (this.inputLanguages instanceof SdkAutoConstructList) {
                return null;
            }
            return this.inputLanguages;
        }

        public final void setInputLanguages(Collection<String> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copy(inputLanguages);
        }

        @Override
        public final Builder inputLanguagesWithStrings(Collection<String> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copy(inputLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputLanguagesWithStrings(String ... inputLanguages) {
            this.inputLanguagesWithStrings(Arrays.asList(inputLanguages));
            return this;
        }

        @Override
        public final Builder inputLanguages(Collection<Language> inputLanguages) {
            this.inputLanguages = AudioInputLanguagesCopier.copyEnumToString(inputLanguages);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder inputLanguages(Language ... inputLanguages) {
            this.inputLanguages(Arrays.asList(inputLanguages));
            return this;
        }

        public final String getGenerativeOutputLanguage() {
            return this.generativeOutputLanguage;
        }

        public final void setGenerativeOutputLanguage(String generativeOutputLanguage) {
            this.generativeOutputLanguage = generativeOutputLanguage;
        }

        @Override
        public final Builder generativeOutputLanguage(String generativeOutputLanguage) {
            this.generativeOutputLanguage = generativeOutputLanguage;
            return this;
        }

        @Override
        public final Builder generativeOutputLanguage(AudioGenerativeOutputLanguage generativeOutputLanguage) {
            this.generativeOutputLanguage(generativeOutputLanguage == null ? null : generativeOutputLanguage.toString());
            return this;
        }

        public final Boolean getIdentifyMultipleLanguages() {
            return this.identifyMultipleLanguages;
        }

        public final void setIdentifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
        }

        @Override
        public final Builder identifyMultipleLanguages(Boolean identifyMultipleLanguages) {
            this.identifyMultipleLanguages = identifyMultipleLanguages;
            return this;
        }

        public AudioLanguageConfiguration build() {
            return new AudioLanguageConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioLanguageConfiguration> {
        public Builder inputLanguagesWithStrings(Collection<String> var1);

        public Builder inputLanguagesWithStrings(String ... var1);

        public Builder inputLanguages(Collection<Language> var1);

        public Builder inputLanguages(Language ... var1);

        public Builder generativeOutputLanguage(String var1);

        public Builder generativeOutputLanguage(AudioGenerativeOutputLanguage var1);

        public Builder identifyMultipleLanguages(Boolean var1);
    }
}

