/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.BedrockDataAutomationRequest;
import software.amazon.awssdk.services.bedrockdataautomation.model.BlueprintFilter;
import software.amazon.awssdk.services.bedrockdataautomation.model.DataAutomationProjectStageFilter;
import software.amazon.awssdk.services.bedrockdataautomation.model.ResourceOwner;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListDataAutomationProjectsRequest
extends BedrockDataAutomationRequest
implements ToCopyableBuilder<Builder, ListDataAutomationProjectsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListDataAutomationProjectsRequest.getter(ListDataAutomationProjectsRequest::maxResults)).setter(ListDataAutomationProjectsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListDataAutomationProjectsRequest.getter(ListDataAutomationProjectsRequest::nextToken)).setter(ListDataAutomationProjectsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> PROJECT_STAGE_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("projectStageFilter").getter(ListDataAutomationProjectsRequest.getter(ListDataAutomationProjectsRequest::projectStageFilterAsString)).setter(ListDataAutomationProjectsRequest.setter(Builder::projectStageFilter)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("projectStageFilter").build()}).build();
    private static final SdkField<BlueprintFilter> BLUEPRINT_FILTER_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("blueprintFilter").getter(ListDataAutomationProjectsRequest.getter(ListDataAutomationProjectsRequest::blueprintFilter)).setter(ListDataAutomationProjectsRequest.setter(Builder::blueprintFilter)).constructor(BlueprintFilter::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blueprintFilter").build()}).build();
    private static final SdkField<String> RESOURCE_OWNER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceOwner").getter(ListDataAutomationProjectsRequest.getter(ListDataAutomationProjectsRequest::resourceOwnerAsString)).setter(ListDataAutomationProjectsRequest.setter(Builder::resourceOwner)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceOwner").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, PROJECT_STAGE_FILTER_FIELD, BLUEPRINT_FILTER_FIELD, RESOURCE_OWNER_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListDataAutomationProjectsRequest.memberNameToFieldInitializer();
    private final Integer maxResults;
    private final String nextToken;
    private final String projectStageFilter;
    private final BlueprintFilter blueprintFilter;
    private final String resourceOwner;

    private ListDataAutomationProjectsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.projectStageFilter = builder.projectStageFilter;
        this.blueprintFilter = builder.blueprintFilter;
        this.resourceOwner = builder.resourceOwner;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final DataAutomationProjectStageFilter projectStageFilter() {
        return DataAutomationProjectStageFilter.fromValue(this.projectStageFilter);
    }

    public final String projectStageFilterAsString() {
        return this.projectStageFilter;
    }

    public final BlueprintFilter blueprintFilter() {
        return this.blueprintFilter;
    }

    public final ResourceOwner resourceOwner() {
        return ResourceOwner.fromValue(this.resourceOwner);
    }

    public final String resourceOwnerAsString() {
        return this.resourceOwner;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.projectStageFilterAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.blueprintFilter());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceOwnerAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListDataAutomationProjectsRequest)) {
            return false;
        }
        ListDataAutomationProjectsRequest other = (ListDataAutomationProjectsRequest)((Object)obj);
        return Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.projectStageFilterAsString(), other.projectStageFilterAsString()) && Objects.equals(this.blueprintFilter(), other.blueprintFilter()) && Objects.equals(this.resourceOwnerAsString(), other.resourceOwnerAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListDataAutomationProjectsRequest").add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("ProjectStageFilter", (Object)this.projectStageFilterAsString()).add("BlueprintFilter", (Object)this.blueprintFilter()).add("ResourceOwner", (Object)this.resourceOwnerAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "projectStageFilter": {
                return Optional.ofNullable(clazz.cast(this.projectStageFilterAsString()));
            }
            case "blueprintFilter": {
                return Optional.ofNullable(clazz.cast(this.blueprintFilter()));
            }
            case "resourceOwner": {
                return Optional.ofNullable(clazz.cast(this.resourceOwnerAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("projectStageFilter", PROJECT_STAGE_FILTER_FIELD);
        map.put("blueprintFilter", BLUEPRINT_FILTER_FIELD);
        map.put("resourceOwner", RESOURCE_OWNER_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListDataAutomationProjectsRequest, T> g) {
        return obj -> g.apply((ListDataAutomationProjectsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockDataAutomationRequest.BuilderImpl
    implements Builder {
        private Integer maxResults;
        private String nextToken;
        private String projectStageFilter;
        private BlueprintFilter blueprintFilter;
        private String resourceOwner;

        private BuilderImpl() {
        }

        private BuilderImpl(ListDataAutomationProjectsRequest model) {
            super(model);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.projectStageFilter(model.projectStageFilter);
            this.blueprintFilter(model.blueprintFilter);
            this.resourceOwner(model.resourceOwner);
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getProjectStageFilter() {
            return this.projectStageFilter;
        }

        public final void setProjectStageFilter(String projectStageFilter) {
            this.projectStageFilter = projectStageFilter;
        }

        @Override
        public final Builder projectStageFilter(String projectStageFilter) {
            this.projectStageFilter = projectStageFilter;
            return this;
        }

        @Override
        public final Builder projectStageFilter(DataAutomationProjectStageFilter projectStageFilter) {
            this.projectStageFilter(projectStageFilter == null ? null : projectStageFilter.toString());
            return this;
        }

        public final BlueprintFilter.Builder getBlueprintFilter() {
            return this.blueprintFilter != null ? this.blueprintFilter.toBuilder() : null;
        }

        public final void setBlueprintFilter(BlueprintFilter.BuilderImpl blueprintFilter) {
            this.blueprintFilter = blueprintFilter != null ? blueprintFilter.build() : null;
        }

        @Override
        public final Builder blueprintFilter(BlueprintFilter blueprintFilter) {
            this.blueprintFilter = blueprintFilter;
            return this;
        }

        public final String getResourceOwner() {
            return this.resourceOwner;
        }

        public final void setResourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
        }

        @Override
        public final Builder resourceOwner(String resourceOwner) {
            this.resourceOwner = resourceOwner;
            return this;
        }

        @Override
        public final Builder resourceOwner(ResourceOwner resourceOwner) {
            this.resourceOwner(resourceOwner == null ? null : resourceOwner.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListDataAutomationProjectsRequest build() {
            return new ListDataAutomationProjectsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockDataAutomationRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListDataAutomationProjectsRequest> {
        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder projectStageFilter(String var1);

        public Builder projectStageFilter(DataAutomationProjectStageFilter var1);

        public Builder blueprintFilter(BlueprintFilter var1);

        default public Builder blueprintFilter(Consumer<BlueprintFilter.Builder> blueprintFilter) {
            return this.blueprintFilter((BlueprintFilter)((BlueprintFilter.Builder)BlueprintFilter.builder().applyMutation(blueprintFilter)).build());
        }

        public Builder resourceOwner(String var1);

        public Builder resourceOwner(ResourceOwner var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

