/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockdataautomation.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioStandardExtraction;
import software.amazon.awssdk.services.bedrockdataautomation.model.AudioStandardGenerativeField;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class AudioStandardOutputConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, AudioStandardOutputConfiguration> {
    private static final SdkField<AudioStandardExtraction> EXTRACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("extraction").getter(AudioStandardOutputConfiguration.getter(AudioStandardOutputConfiguration::extraction)).setter(AudioStandardOutputConfiguration.setter(Builder::extraction)).constructor(AudioStandardExtraction::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("extraction").build()}).build();
    private static final SdkField<AudioStandardGenerativeField> GENERATIVE_FIELD_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("generativeField").getter(AudioStandardOutputConfiguration.getter(AudioStandardOutputConfiguration::generativeField)).setter(AudioStandardOutputConfiguration.setter(Builder::generativeField)).constructor(AudioStandardGenerativeField::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("generativeField").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXTRACTION_FIELD, GENERATIVE_FIELD_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("extraction", EXTRACTION_FIELD);
            this.put("generativeField", GENERATIVE_FIELD_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final AudioStandardExtraction extraction;
    private final AudioStandardGenerativeField generativeField;

    private AudioStandardOutputConfiguration(BuilderImpl builder) {
        this.extraction = builder.extraction;
        this.generativeField = builder.generativeField;
    }

    public final AudioStandardExtraction extraction() {
        return this.extraction;
    }

    public final AudioStandardGenerativeField generativeField() {
        return this.generativeField;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.extraction());
        hashCode = 31 * hashCode + Objects.hashCode(this.generativeField());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AudioStandardOutputConfiguration)) {
            return false;
        }
        AudioStandardOutputConfiguration other = (AudioStandardOutputConfiguration)obj;
        return Objects.equals(this.extraction(), other.extraction()) && Objects.equals(this.generativeField(), other.generativeField());
    }

    public final String toString() {
        return ToString.builder((String)"AudioStandardOutputConfiguration").add("Extraction", (Object)this.extraction()).add("GenerativeField", (Object)this.generativeField()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "extraction": {
                return Optional.ofNullable(clazz.cast(this.extraction()));
            }
            case "generativeField": {
                return Optional.ofNullable(clazz.cast(this.generativeField()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<AudioStandardOutputConfiguration, T> g) {
        return obj -> g.apply((AudioStandardOutputConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private AudioStandardExtraction extraction;
        private AudioStandardGenerativeField generativeField;

        private BuilderImpl() {
        }

        private BuilderImpl(AudioStandardOutputConfiguration model) {
            this.extraction(model.extraction);
            this.generativeField(model.generativeField);
        }

        public final AudioStandardExtraction.Builder getExtraction() {
            return this.extraction != null ? this.extraction.toBuilder() : null;
        }

        public final void setExtraction(AudioStandardExtraction.BuilderImpl extraction) {
            this.extraction = extraction != null ? extraction.build() : null;
        }

        @Override
        public final Builder extraction(AudioStandardExtraction extraction) {
            this.extraction = extraction;
            return this;
        }

        public final AudioStandardGenerativeField.Builder getGenerativeField() {
            return this.generativeField != null ? this.generativeField.toBuilder() : null;
        }

        public final void setGenerativeField(AudioStandardGenerativeField.BuilderImpl generativeField) {
            this.generativeField = generativeField != null ? generativeField.build() : null;
        }

        @Override
        public final Builder generativeField(AudioStandardGenerativeField generativeField) {
            this.generativeField = generativeField;
            return this;
        }

        public AudioStandardOutputConfiguration build() {
            return new AudioStandardOutputConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, AudioStandardOutputConfiguration> {
        public Builder extraction(AudioStandardExtraction var1);

        default public Builder extraction(Consumer<AudioStandardExtraction.Builder> extraction) {
            return this.extraction((AudioStandardExtraction)((AudioStandardExtraction.Builder)AudioStandardExtraction.builder().applyMutation(extraction)).build());
        }

        public Builder generativeField(AudioStandardGenerativeField var1);

        default public Builder generativeField(Consumer<AudioStandardGenerativeField.Builder> generativeField) {
            return this.generativeField((AudioStandardGenerativeField)((AudioStandardGenerativeField.Builder)AudioStandardGenerativeField.builder().applyMutation(generativeField)).build());
        }
    }
}

