/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the template for the prompt that's sent to the model for response generation. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt">Knowledge
 * base prompt templates</a>.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_RetrieveAndGenerate.html#API_agent-runtime_RetrieveAndGenerate_RequestSyntax"
 * >RetrieveAndGenerate request</a> – in the <code>filter</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PromptTemplate implements SdkPojo, Serializable, ToCopyableBuilder<PromptTemplate.Builder, PromptTemplate> {
    private static final SdkField<String> TEXT_PROMPT_TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("textPromptTemplate").getter(getter(PromptTemplate::textPromptTemplate))
            .setter(setter(Builder::textPromptTemplate))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("textPromptTemplate").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEXT_PROMPT_TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String textPromptTemplate;

    private PromptTemplate(BuilderImpl builder) {
        this.textPromptTemplate = builder.textPromptTemplate;
    }

    /**
     * <p>
     * The template for the prompt that's sent to the model for response generation. You can include prompt
     * placeholders, which become replaced before the prompt is sent to the model to provide instructions and context to
     * the model. In addition, you can include XML tags to delineate meaningful sections of the prompt template.
     * </p>
     * <p>
     * For more information, see the following resources:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt">
     * Knowledge base prompt templates</a>
     * </p>
     * </li>
     * <li>
     * <p>
     * <a href="https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags">Use XML tags with
     * Anthropic Claude models</a>
     * </p>
     * </li>
     * </ul>
     * 
     * @return The template for the prompt that's sent to the model for response generation. You can include prompt
     *         placeholders, which become replaced before the prompt is sent to the model to provide instructions and
     *         context to the model. In addition, you can include XML tags to delineate meaningful sections of the
     *         prompt template.</p>
     *         <p>
     *         For more information, see the following resources:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <a href=
     *         "https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt"
     *         >Knowledge base prompt templates</a>
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <a href="https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags">Use XML tags
     *         with Anthropic Claude models</a>
     *         </p>
     *         </li>
     */
    public final String textPromptTemplate() {
        return textPromptTemplate;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(textPromptTemplate());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptTemplate)) {
            return false;
        }
        PromptTemplate other = (PromptTemplate) obj;
        return Objects.equals(textPromptTemplate(), other.textPromptTemplate());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PromptTemplate")
                .add("TextPromptTemplate", textPromptTemplate() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "textPromptTemplate":
            return Optional.ofNullable(clazz.cast(textPromptTemplate()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("textPromptTemplate", TEXT_PROMPT_TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PromptTemplate, T> g) {
        return obj -> g.apply((PromptTemplate) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PromptTemplate> {
        /**
         * <p>
         * The template for the prompt that's sent to the model for response generation. You can include prompt
         * placeholders, which become replaced before the prompt is sent to the model to provide instructions and
         * context to the model. In addition, you can include XML tags to delineate meaningful sections of the prompt
         * template.
         * </p>
         * <p>
         * For more information, see the following resources:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt">
         * Knowledge base prompt templates</a>
         * </p>
         * </li>
         * <li>
         * <p>
         * <a href="https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags">Use XML tags with
         * Anthropic Claude models</a>
         * </p>
         * </li>
         * </ul>
         * 
         * @param textPromptTemplate
         *        The template for the prompt that's sent to the model for response generation. You can include prompt
         *        placeholders, which become replaced before the prompt is sent to the model to provide instructions and
         *        context to the model. In addition, you can include XML tags to delineate meaningful sections of the
         *        prompt template.</p>
         *        <p>
         *        For more information, see the following resources:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <a href=
         *        "https://docs.aws.amazon.com/bedrock/latest/userguide/kb-test-config.html#kb-test-config-sysprompt"
         *        >Knowledge base prompt templates</a>
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <a href="https://docs.claude.com/en/docs/build-with-claude/prompt-engineering/use-xml-tags">Use XML
         *        tags with Anthropic Claude models</a>
         *        </p>
         *        </li>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder textPromptTemplate(String textPromptTemplate);
    }

    static final class BuilderImpl implements Builder {
        private String textPromptTemplate;

        private BuilderImpl() {
        }

        private BuilderImpl(PromptTemplate model) {
            textPromptTemplate(model.textPromptTemplate);
        }

        public final String getTextPromptTemplate() {
            return textPromptTemplate;
        }

        public final void setTextPromptTemplate(String textPromptTemplate) {
            this.textPromptTemplate = textPromptTemplate;
        }

        @Override
        public final Builder textPromptTemplate(String textPromptTemplate) {
            this.textPromptTemplate = textPromptTemplate;
            return this;
        }

        @Override
        public PromptTemplate build() {
            return new PromptTemplate(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
