/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains the query made to the knowledge base.
 * </p>
 * <p>
 * This data type is used in the following API operations:
 * </p>
 * <ul>
 * <li>
 * <p>
 * <a href=
 * "https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent-runtime_Retrieve.html#API_agent-runtime_Retrieve_RequestSyntax"
 * >Retrieve request</a> – in the <code>retrievalQuery</code> field
 * </p>
 * </li>
 * </ul>
 */
@Generated("software.amazon.awssdk:codegen")
public final class KnowledgeBaseQuery implements SdkPojo, Serializable,
        ToCopyableBuilder<KnowledgeBaseQuery.Builder, KnowledgeBaseQuery> {
    private static final SdkField<InputImage> IMAGE_FIELD = SdkField.<InputImage> builder(MarshallingType.SDK_POJO)
            .memberName("image").getter(getter(KnowledgeBaseQuery::image)).setter(setter(Builder::image))
            .constructor(InputImage::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("image").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(KnowledgeBaseQuery::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(KnowledgeBaseQuery::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(IMAGE_FIELD, TEXT_FIELD,
            TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final InputImage image;

    private final String text;

    private final String type;

    private KnowledgeBaseQuery(BuilderImpl builder) {
        this.image = builder.image;
        this.text = builder.text;
        this.type = builder.type;
    }

    /**
     * <p>
     * An image to include in the knowledge base query for multimodal retrieval.
     * </p>
     * 
     * @return An image to include in the knowledge base query for multimodal retrieval.
     */
    public final InputImage image() {
        return image;
    }

    /**
     * <p>
     * The text of the query made to the knowledge base.
     * </p>
     * 
     * @return The text of the query made to the knowledge base.
     */
    public final String text() {
        return text;
    }

    /**
     * <p>
     * The type of query being performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of query being performed.
     * @see KnowledgeBaseQueryType
     */
    public final KnowledgeBaseQueryType type() {
        return KnowledgeBaseQueryType.fromValue(type);
    }

    /**
     * <p>
     * The type of query being performed.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link KnowledgeBaseQueryType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The type of query being performed.
     * @see KnowledgeBaseQueryType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(image());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseQuery)) {
            return false;
        }
        KnowledgeBaseQuery other = (KnowledgeBaseQuery) obj;
        return Objects.equals(image(), other.image()) && Objects.equals(text(), other.text())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("KnowledgeBaseQuery").add("Image", image()).add("Text", text()).add("Type", typeAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "image":
            return Optional.ofNullable(clazz.cast(image()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("image", IMAGE_FIELD);
        map.put("text", TEXT_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseQuery, T> g) {
        return obj -> g.apply((KnowledgeBaseQuery) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, KnowledgeBaseQuery> {
        /**
         * <p>
         * An image to include in the knowledge base query for multimodal retrieval.
         * </p>
         * 
         * @param image
         *        An image to include in the knowledge base query for multimodal retrieval.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder image(InputImage image);

        /**
         * <p>
         * An image to include in the knowledge base query for multimodal retrieval.
         * </p>
         * This is a convenience method that creates an instance of the {@link InputImage.Builder} avoiding the need to
         * create one manually via {@link InputImage#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link InputImage.Builder#build()} is called immediately and its result
         * is passed to {@link #image(InputImage)}.
         * 
         * @param image
         *        a consumer that will call methods on {@link InputImage.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #image(InputImage)
         */
        default Builder image(Consumer<InputImage.Builder> image) {
            return image(InputImage.builder().applyMutation(image).build());
        }

        /**
         * <p>
         * The text of the query made to the knowledge base.
         * </p>
         * 
         * @param text
         *        The text of the query made to the knowledge base.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);

        /**
         * <p>
         * The type of query being performed.
         * </p>
         * 
         * @param type
         *        The type of query being performed.
         * @see KnowledgeBaseQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseQueryType
         */
        Builder type(String type);

        /**
         * <p>
         * The type of query being performed.
         * </p>
         * 
         * @param type
         *        The type of query being performed.
         * @see KnowledgeBaseQueryType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see KnowledgeBaseQueryType
         */
        Builder type(KnowledgeBaseQueryType type);
    }

    static final class BuilderImpl implements Builder {
        private InputImage image;

        private String text;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseQuery model) {
            image(model.image);
            text(model.text);
            type(model.type);
        }

        public final InputImage.Builder getImage() {
            return image != null ? image.toBuilder() : null;
        }

        public final void setImage(InputImage.BuilderImpl image) {
            this.image = image != null ? image.build() : null;
        }

        @Override
        public final Builder image(InputImage image) {
            this.image = image;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(KnowledgeBaseQueryType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public KnowledgeBaseQuery build() {
            return new KnowledgeBaseQuery(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
