/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the next node that receives output data from a flow trace.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeOutputNext implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeOutputNext.Builder, FlowTraceNodeOutputNext> {
    private static final SdkField<String> INPUT_FIELD_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputFieldName").getter(getter(FlowTraceNodeOutputNext::inputFieldName))
            .setter(setter(Builder::inputFieldName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputFieldName").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowTraceNodeOutputNext::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INPUT_FIELD_NAME_FIELD,
            NODE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String inputFieldName;

    private final String nodeName;

    private FlowTraceNodeOutputNext(BuilderImpl builder) {
        this.inputFieldName = builder.inputFieldName;
        this.nodeName = builder.nodeName;
    }

    /**
     * <p>
     * The name of the input field in the next node that receives the data.
     * </p>
     * 
     * @return The name of the input field in the next node that receives the data.
     */
    public final String inputFieldName() {
        return inputFieldName;
    }

    /**
     * <p>
     * The name of the next node that receives the output data.
     * </p>
     * 
     * @return The name of the next node that receives the output data.
     */
    public final String nodeName() {
        return nodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(inputFieldName());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputNext)) {
            return false;
        }
        FlowTraceNodeOutputNext other = (FlowTraceNodeOutputNext) obj;
        return Objects.equals(inputFieldName(), other.inputFieldName()) && Objects.equals(nodeName(), other.nodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeOutputNext").add("InputFieldName", inputFieldName()).add("NodeName", nodeName())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "inputFieldName":
            return Optional.ofNullable(clazz.cast(inputFieldName()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("inputFieldName", INPUT_FIELD_NAME_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputNext, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputNext) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeOutputNext> {
        /**
         * <p>
         * The name of the input field in the next node that receives the data.
         * </p>
         * 
         * @param inputFieldName
         *        The name of the input field in the next node that receives the data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputFieldName(String inputFieldName);

        /**
         * <p>
         * The name of the next node that receives the output data.
         * </p>
         * 
         * @param nodeName
         *        The name of the next node that receives the output data.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);
    }

    static final class BuilderImpl implements Builder {
        private String inputFieldName;

        private String nodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputNext model) {
            inputFieldName(model.inputFieldName);
            nodeName(model.nodeName);
        }

        public final String getInputFieldName() {
            return inputFieldName;
        }

        public final void setInputFieldName(String inputFieldName) {
            this.inputFieldName = inputFieldName;
        }

        @Override
        public final Builder inputFieldName(String inputFieldName) {
            this.inputFieldName = inputFieldName;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @Override
        public FlowTraceNodeOutputNext build() {
            return new FlowTraceNodeOutputNext(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
