/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about a field in the output from a node. For more information, see <a
 * href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-trace.html">Track each step in your prompt flow by
 * viewing its trace in Amazon Bedrock</a>.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowTraceNodeOutputField implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowTraceNodeOutputField.Builder, FlowTraceNodeOutputField> {
    private static final SdkField<FlowTraceNodeOutputContent> CONTENT_FIELD = SdkField
            .<FlowTraceNodeOutputContent> builder(MarshallingType.SDK_POJO).memberName("content")
            .getter(getter(FlowTraceNodeOutputField::content)).setter(setter(Builder::content))
            .constructor(FlowTraceNodeOutputContent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("content").build()).build();

    private static final SdkField<List<FlowTraceNodeOutputNext>> NEXT_FIELD = SdkField
            .<List<FlowTraceNodeOutputNext>> builder(MarshallingType.LIST)
            .memberName("next")
            .getter(getter(FlowTraceNodeOutputField::next))
            .setter(setter(Builder::next))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("next").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FlowTraceNodeOutputNext> builder(MarshallingType.SDK_POJO)
                                            .constructor(FlowTraceNodeOutputNext::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NODE_OUTPUT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeOutputName").getter(getter(FlowTraceNodeOutputField::nodeOutputName))
            .setter(setter(Builder::nodeOutputName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeOutputName").build()).build();

    private static final SdkField<String> TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("type")
            .getter(getter(FlowTraceNodeOutputField::typeAsString)).setter(setter(Builder::type))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CONTENT_FIELD, NEXT_FIELD,
            NODE_OUTPUT_NAME_FIELD, TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final FlowTraceNodeOutputContent content;

    private final List<FlowTraceNodeOutputNext> next;

    private final String nodeOutputName;

    private final String type;

    private FlowTraceNodeOutputField(BuilderImpl builder) {
        this.content = builder.content;
        this.next = builder.next;
        this.nodeOutputName = builder.nodeOutputName;
        this.type = builder.type;
    }

    /**
     * <p>
     * The content of the node output.
     * </p>
     * 
     * @return The content of the node output.
     */
    public final FlowTraceNodeOutputContent content() {
        return content;
    }

    /**
     * For responses, this returns true if the service returned a value for the Next property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasNext() {
        return next != null && !(next instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The next node that receives output data from this field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasNext} method.
     * </p>
     * 
     * @return The next node that receives output data from this field.
     */
    public final List<FlowTraceNodeOutputNext> next() {
        return next;
    }

    /**
     * <p>
     * The name of the node output.
     * </p>
     * 
     * @return The name of the node output.
     */
    public final String nodeOutputName() {
        return nodeOutputName;
    }

    /**
     * <p>
     * The data type of the output field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the output field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final FlowNodeIODataType type() {
        return FlowNodeIODataType.fromValue(type);
    }

    /**
     * <p>
     * The data type of the output field for compatibility validation.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #type} will return
     * {@link FlowNodeIODataType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #typeAsString}.
     * </p>
     * 
     * @return The data type of the output field for compatibility validation.
     * @see FlowNodeIODataType
     */
    public final String typeAsString() {
        return type;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(content());
        hashCode = 31 * hashCode + Objects.hashCode(hasNext() ? next() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nodeOutputName());
        hashCode = 31 * hashCode + Objects.hashCode(typeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowTraceNodeOutputField)) {
            return false;
        }
        FlowTraceNodeOutputField other = (FlowTraceNodeOutputField) obj;
        return Objects.equals(content(), other.content()) && hasNext() == other.hasNext() && Objects.equals(next(), other.next())
                && Objects.equals(nodeOutputName(), other.nodeOutputName())
                && Objects.equals(typeAsString(), other.typeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowTraceNodeOutputField").add("Content", content())
                .add("Next", next() == null ? null : "*** Sensitive Data Redacted ***").add("NodeOutputName", nodeOutputName())
                .add("Type", typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "content":
            return Optional.ofNullable(clazz.cast(content()));
        case "next":
            return Optional.ofNullable(clazz.cast(next()));
        case "nodeOutputName":
            return Optional.ofNullable(clazz.cast(nodeOutputName()));
        case "type":
            return Optional.ofNullable(clazz.cast(typeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("content", CONTENT_FIELD);
        map.put("next", NEXT_FIELD);
        map.put("nodeOutputName", NODE_OUTPUT_NAME_FIELD);
        map.put("type", TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowTraceNodeOutputField, T> g) {
        return obj -> g.apply((FlowTraceNodeOutputField) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowTraceNodeOutputField> {
        /**
         * <p>
         * The content of the node output.
         * </p>
         * 
         * @param content
         *        The content of the node output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder content(FlowTraceNodeOutputContent content);

        /**
         * <p>
         * The content of the node output.
         * </p>
         * This is a convenience method that creates an instance of the {@link FlowTraceNodeOutputContent.Builder}
         * avoiding the need to create one manually via {@link FlowTraceNodeOutputContent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link FlowTraceNodeOutputContent.Builder#build()} is called immediately
         * and its result is passed to {@link #content(FlowTraceNodeOutputContent)}.
         * 
         * @param content
         *        a consumer that will call methods on {@link FlowTraceNodeOutputContent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #content(FlowTraceNodeOutputContent)
         */
        default Builder content(Consumer<FlowTraceNodeOutputContent.Builder> content) {
            return content(FlowTraceNodeOutputContent.builder().applyMutation(content).build());
        }

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * 
         * @param next
         *        The next node that receives output data from this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(Collection<FlowTraceNodeOutputNext> next);

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * 
         * @param next
         *        The next node that receives output data from this field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder next(FlowTraceNodeOutputNext... next);

        /**
         * <p>
         * The next node that receives output data from this field.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNext.Builder} avoiding
         * the need to create one manually via
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNext#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNext.Builder#build()} is
         * called immediately and its result is passed to {@link #next(List<FlowTraceNodeOutputNext>)}.
         * 
         * @param next
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.bedrockagentruntime.model.FlowTraceNodeOutputNext.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #next(java.util.Collection<FlowTraceNodeOutputNext>)
         */
        Builder next(Consumer<FlowTraceNodeOutputNext.Builder>... next);

        /**
         * <p>
         * The name of the node output.
         * </p>
         * 
         * @param nodeOutputName
         *        The name of the node output.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeOutputName(String nodeOutputName);

        /**
         * <p>
         * The data type of the output field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the output field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(String type);

        /**
         * <p>
         * The data type of the output field for compatibility validation.
         * </p>
         * 
         * @param type
         *        The data type of the output field for compatibility validation.
         * @see FlowNodeIODataType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowNodeIODataType
         */
        Builder type(FlowNodeIODataType type);
    }

    static final class BuilderImpl implements Builder {
        private FlowTraceNodeOutputContent content;

        private List<FlowTraceNodeOutputNext> next = DefaultSdkAutoConstructList.getInstance();

        private String nodeOutputName;

        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowTraceNodeOutputField model) {
            content(model.content);
            next(model.next);
            nodeOutputName(model.nodeOutputName);
            type(model.type);
        }

        public final FlowTraceNodeOutputContent.Builder getContent() {
            return content != null ? content.toBuilder() : null;
        }

        public final void setContent(FlowTraceNodeOutputContent.BuilderImpl content) {
            this.content = content != null ? content.build() : null;
        }

        @Override
        public final Builder content(FlowTraceNodeOutputContent content) {
            this.content = content;
            return this;
        }

        public final List<FlowTraceNodeOutputNext.Builder> getNext() {
            List<FlowTraceNodeOutputNext.Builder> result = FlowTraceNodeOutputNextListCopier.copyToBuilder(this.next);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setNext(Collection<FlowTraceNodeOutputNext.BuilderImpl> next) {
            this.next = FlowTraceNodeOutputNextListCopier.copyFromBuilder(next);
        }

        @Override
        public final Builder next(Collection<FlowTraceNodeOutputNext> next) {
            this.next = FlowTraceNodeOutputNextListCopier.copy(next);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(FlowTraceNodeOutputNext... next) {
            next(Arrays.asList(next));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder next(Consumer<FlowTraceNodeOutputNext.Builder>... next) {
            next(Stream.of(next).map(c -> FlowTraceNodeOutputNext.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNodeOutputName() {
            return nodeOutputName;
        }

        public final void setNodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
        }

        @Override
        public final Builder nodeOutputName(String nodeOutputName) {
            this.nodeOutputName = nodeOutputName;
            return this;
        }

        public final String getType() {
            return type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(FlowNodeIODataType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        @Override
        public FlowTraceNodeOutputField build() {
            return new FlowTraceNodeOutputField(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
