/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Contains information about an error that occurred during an flow execution.
 * </p>
 * <note>
 * <p>
 * Flow executions is in preview release for Amazon Bedrock and is subject to change.
 * </p>
 * </note>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FlowExecutionError implements SdkPojo, Serializable,
        ToCopyableBuilder<FlowExecutionError.Builder, FlowExecutionError> {
    private static final SdkField<String> ERROR_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("error")
            .getter(getter(FlowExecutionError::errorAsString)).setter(setter(Builder::error))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("error").build()).build();

    private static final SdkField<String> MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("message")
            .getter(getter(FlowExecutionError::message)).setter(setter(Builder::message))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()).build();

    private static final SdkField<String> NODE_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nodeName").getter(getter(FlowExecutionError::nodeName)).setter(setter(Builder::nodeName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nodeName").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ERROR_FIELD, MESSAGE_FIELD,
            NODE_NAME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String error;

    private final String message;

    private final String nodeName;

    private FlowExecutionError(BuilderImpl builder) {
        this.error = builder.error;
        this.message = builder.message;
        this.nodeName = builder.nodeName;
    }

    /**
     * <p>
     * The error code for the type of error that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link FlowExecutionErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error code for the type of error that occurred.
     * @see FlowExecutionErrorType
     */
    public final FlowExecutionErrorType error() {
        return FlowExecutionErrorType.fromValue(error);
    }

    /**
     * <p>
     * The error code for the type of error that occurred.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #error} will return
     * {@link FlowExecutionErrorType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #errorAsString}.
     * </p>
     * 
     * @return The error code for the type of error that occurred.
     * @see FlowExecutionErrorType
     */
    public final String errorAsString() {
        return error;
    }

    /**
     * <p>
     * A descriptive message that provides details about the error.
     * </p>
     * 
     * @return A descriptive message that provides details about the error.
     */
    public final String message() {
        return message;
    }

    /**
     * <p>
     * The name of the node in the flow where the error occurred (if applicable).
     * </p>
     * 
     * @return The name of the node in the flow where the error occurred (if applicable).
     */
    public final String nodeName() {
        return nodeName;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(errorAsString());
        hashCode = 31 * hashCode + Objects.hashCode(message());
        hashCode = 31 * hashCode + Objects.hashCode(nodeName());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FlowExecutionError)) {
            return false;
        }
        FlowExecutionError other = (FlowExecutionError) obj;
        return Objects.equals(errorAsString(), other.errorAsString()) && Objects.equals(message(), other.message())
                && Objects.equals(nodeName(), other.nodeName());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FlowExecutionError").add("Error", errorAsString()).add("Message", message())
                .add("NodeName", nodeName()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "error":
            return Optional.ofNullable(clazz.cast(errorAsString()));
        case "message":
            return Optional.ofNullable(clazz.cast(message()));
        case "nodeName":
            return Optional.ofNullable(clazz.cast(nodeName()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("error", ERROR_FIELD);
        map.put("message", MESSAGE_FIELD);
        map.put("nodeName", NODE_NAME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FlowExecutionError, T> g) {
        return obj -> g.apply((FlowExecutionError) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FlowExecutionError> {
        /**
         * <p>
         * The error code for the type of error that occurred.
         * </p>
         * 
         * @param error
         *        The error code for the type of error that occurred.
         * @see FlowExecutionErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionErrorType
         */
        Builder error(String error);

        /**
         * <p>
         * The error code for the type of error that occurred.
         * </p>
         * 
         * @param error
         *        The error code for the type of error that occurred.
         * @see FlowExecutionErrorType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see FlowExecutionErrorType
         */
        Builder error(FlowExecutionErrorType error);

        /**
         * <p>
         * A descriptive message that provides details about the error.
         * </p>
         * 
         * @param message
         *        A descriptive message that provides details about the error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder message(String message);

        /**
         * <p>
         * The name of the node in the flow where the error occurred (if applicable).
         * </p>
         * 
         * @param nodeName
         *        The name of the node in the flow where the error occurred (if applicable).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nodeName(String nodeName);
    }

    static final class BuilderImpl implements Builder {
        private String error;

        private String message;

        private String nodeName;

        private BuilderImpl() {
        }

        private BuilderImpl(FlowExecutionError model) {
            error(model.error);
            message(model.message);
            nodeName(model.nodeName);
        }

        public final String getError() {
            return error;
        }

        public final void setError(String error) {
            this.error = error;
        }

        @Override
        public final Builder error(String error) {
            this.error = error;
            return this;
        }

        @Override
        public final Builder error(FlowExecutionErrorType error) {
            this.error(error == null ? null : error.toString());
            return this;
        }

        public final String getMessage() {
            return message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final String getNodeName() {
            return nodeName;
        }

        public final void setNodeName(String nodeName) {
            this.nodeName = nodeName;
        }

        @Override
        public final Builder nodeName(String nodeName) {
            this.nodeName = nodeName;
            return this;
        }

        @Override
        public FlowExecutionError build() {
            return new FlowExecutionError(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
