/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The trace behavior for the custom orchestration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomOrchestrationTrace implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomOrchestrationTrace.Builder, CustomOrchestrationTrace> {
    private static final SdkField<CustomOrchestrationTraceEvent> EVENT_FIELD = SdkField
            .<CustomOrchestrationTraceEvent> builder(MarshallingType.SDK_POJO).memberName("event")
            .getter(getter(CustomOrchestrationTrace::event)).setter(setter(Builder::event))
            .constructor(CustomOrchestrationTraceEvent::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("event").build()).build();

    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(CustomOrchestrationTrace::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVENT_FIELD, TRACE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomOrchestrationTraceEvent event;

    private final String traceId;

    private CustomOrchestrationTrace(BuilderImpl builder) {
        this.event = builder.event;
        this.traceId = builder.traceId;
    }

    /**
     * <p>
     * The event details used with the custom orchestration.
     * </p>
     * 
     * @return The event details used with the custom orchestration.
     */
    public final CustomOrchestrationTraceEvent event() {
        return event;
    }

    /**
     * <p>
     * The unique identifier of the trace.
     * </p>
     * 
     * @return The unique identifier of the trace.
     */
    public final String traceId() {
        return traceId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(event());
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomOrchestrationTrace)) {
            return false;
        }
        CustomOrchestrationTrace other = (CustomOrchestrationTrace) obj;
        return Objects.equals(event(), other.event()) && Objects.equals(traceId(), other.traceId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomOrchestrationTrace")
                .add("Event", event() == null ? null : "*** Sensitive Data Redacted ***").add("TraceId", traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "event":
            return Optional.ofNullable(clazz.cast(event()));
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("event", EVENT_FIELD);
        map.put("traceId", TRACE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomOrchestrationTrace, T> g) {
        return obj -> g.apply((CustomOrchestrationTrace) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomOrchestrationTrace> {
        /**
         * <p>
         * The event details used with the custom orchestration.
         * </p>
         * 
         * @param event
         *        The event details used with the custom orchestration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder event(CustomOrchestrationTraceEvent event);

        /**
         * <p>
         * The event details used with the custom orchestration.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomOrchestrationTraceEvent.Builder}
         * avoiding the need to create one manually via {@link CustomOrchestrationTraceEvent#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomOrchestrationTraceEvent.Builder#build()} is called
         * immediately and its result is passed to {@link #event(CustomOrchestrationTraceEvent)}.
         * 
         * @param event
         *        a consumer that will call methods on {@link CustomOrchestrationTraceEvent.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #event(CustomOrchestrationTraceEvent)
         */
        default Builder event(Consumer<CustomOrchestrationTraceEvent.Builder> event) {
            return event(CustomOrchestrationTraceEvent.builder().applyMutation(event).build());
        }

        /**
         * <p>
         * The unique identifier of the trace.
         * </p>
         * 
         * @param traceId
         *        The unique identifier of the trace.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);
    }

    static final class BuilderImpl implements Builder {
        private CustomOrchestrationTraceEvent event;

        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomOrchestrationTrace model) {
            event(model.event);
            traceId(model.traceId);
        }

        public final CustomOrchestrationTraceEvent.Builder getEvent() {
            return event != null ? event.toBuilder() : null;
        }

        public final void setEvent(CustomOrchestrationTraceEvent.BuilderImpl event) {
            this.event = event != null ? event.build() : null;
        }

        @Override
        public final Builder event(CustomOrchestrationTraceEvent event) {
            this.event = event;
            return this;
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        @Override
        public CustomOrchestrationTrace build() {
            return new CustomOrchestrationTrace(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
