/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentruntime.BedrockAgentRuntimeClient;
import software.amazon.awssdk.services.bedrockagentruntime.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentruntime.model.FlowExecutionEvent;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsRequest;
import software.amazon.awssdk.services.bedrockagentruntime.model.ListFlowExecutionEventsResponse;

public class ListFlowExecutionEventsIterable
implements SdkIterable<ListFlowExecutionEventsResponse> {
    private final BedrockAgentRuntimeClient client;
    private final ListFlowExecutionEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListFlowExecutionEventsIterable(BedrockAgentRuntimeClient client, ListFlowExecutionEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListFlowExecutionEventsResponseFetcher();
    }

    public Iterator<ListFlowExecutionEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<FlowExecutionEvent> flowExecutionEvents() {
        Function<ListFlowExecutionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.flowExecutionEvents() != null) {
                return response.flowExecutionEvents().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListFlowExecutionEventsResponseFetcher
    implements SyncPageFetcher<ListFlowExecutionEventsResponse> {
        private ListFlowExecutionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListFlowExecutionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListFlowExecutionEventsResponse nextPage(ListFlowExecutionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListFlowExecutionEventsIterable.this.client.listFlowExecutionEvents(ListFlowExecutionEventsIterable.this.firstRequest);
            }
            return ListFlowExecutionEventsIterable.this.client.listFlowExecutionEvents((ListFlowExecutionEventsRequest)((Object)ListFlowExecutionEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

