/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.ByteContentDoc;
import software.amazon.awssdk.services.bedrockagentruntime.model.ExternalSourceType;
import software.amazon.awssdk.services.bedrockagentruntime.model.S3ObjectDoc;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExternalSource
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExternalSource> {
    private static final SdkField<ByteContentDoc> BYTE_CONTENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("byteContent").getter(ExternalSource.getter(ExternalSource::byteContent)).setter(ExternalSource.setter(Builder::byteContent)).constructor(ByteContentDoc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("byteContent").build()}).build();
    private static final SdkField<S3ObjectDoc> S3_LOCATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("s3Location").getter(ExternalSource.getter(ExternalSource::s3Location)).setter(ExternalSource.setter(Builder::s3Location)).constructor(S3ObjectDoc::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("s3Location").build()}).build();
    private static final SdkField<String> SOURCE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sourceType").getter(ExternalSource.getter(ExternalSource::sourceTypeAsString)).setter(ExternalSource.setter(Builder::sourceType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourceType").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(BYTE_CONTENT_FIELD, S3_LOCATION_FIELD, SOURCE_TYPE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExternalSource.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ByteContentDoc byteContent;
    private final S3ObjectDoc s3Location;
    private final String sourceType;

    private ExternalSource(BuilderImpl builder) {
        this.byteContent = builder.byteContent;
        this.s3Location = builder.s3Location;
        this.sourceType = builder.sourceType;
    }

    public final ByteContentDoc byteContent() {
        return this.byteContent;
    }

    public final S3ObjectDoc s3Location() {
        return this.s3Location;
    }

    public final ExternalSourceType sourceType() {
        return ExternalSourceType.fromValue(this.sourceType);
    }

    public final String sourceTypeAsString() {
        return this.sourceType;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.byteContent());
        hashCode = 31 * hashCode + Objects.hashCode(this.s3Location());
        hashCode = 31 * hashCode + Objects.hashCode(this.sourceTypeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExternalSource)) {
            return false;
        }
        ExternalSource other = (ExternalSource)obj;
        return Objects.equals(this.byteContent(), other.byteContent()) && Objects.equals(this.s3Location(), other.s3Location()) && Objects.equals(this.sourceTypeAsString(), other.sourceTypeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ExternalSource").add("ByteContent", (Object)this.byteContent()).add("S3Location", (Object)this.s3Location()).add("SourceType", (Object)this.sourceTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "byteContent": {
                return Optional.ofNullable(clazz.cast(this.byteContent()));
            }
            case "s3Location": {
                return Optional.ofNullable(clazz.cast(this.s3Location()));
            }
            case "sourceType": {
                return Optional.ofNullable(clazz.cast(this.sourceTypeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("byteContent", BYTE_CONTENT_FIELD);
        map.put("s3Location", S3_LOCATION_FIELD);
        map.put("sourceType", SOURCE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExternalSource, T> g) {
        return obj -> g.apply((ExternalSource)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ByteContentDoc byteContent;
        private S3ObjectDoc s3Location;
        private String sourceType;

        private BuilderImpl() {
        }

        private BuilderImpl(ExternalSource model) {
            this.byteContent(model.byteContent);
            this.s3Location(model.s3Location);
            this.sourceType(model.sourceType);
        }

        public final ByteContentDoc.Builder getByteContent() {
            return this.byteContent != null ? this.byteContent.toBuilder() : null;
        }

        public final void setByteContent(ByteContentDoc.BuilderImpl byteContent) {
            this.byteContent = byteContent != null ? byteContent.build() : null;
        }

        @Override
        public final Builder byteContent(ByteContentDoc byteContent) {
            this.byteContent = byteContent;
            return this;
        }

        public final S3ObjectDoc.Builder getS3Location() {
            return this.s3Location != null ? this.s3Location.toBuilder() : null;
        }

        public final void setS3Location(S3ObjectDoc.BuilderImpl s3Location) {
            this.s3Location = s3Location != null ? s3Location.build() : null;
        }

        @Override
        public final Builder s3Location(S3ObjectDoc s3Location) {
            this.s3Location = s3Location;
            return this;
        }

        public final String getSourceType() {
            return this.sourceType;
        }

        public final void setSourceType(String sourceType) {
            this.sourceType = sourceType;
        }

        @Override
        public final Builder sourceType(String sourceType) {
            this.sourceType = sourceType;
            return this;
        }

        @Override
        public final Builder sourceType(ExternalSourceType sourceType) {
            this.sourceType(sourceType == null ? null : sourceType.toString());
            return this;
        }

        public ExternalSource build() {
            return new ExternalSource(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExternalSource> {
        public Builder byteContent(ByteContentDoc var1);

        default public Builder byteContent(Consumer<ByteContentDoc.Builder> byteContent) {
            return this.byteContent((ByteContentDoc)((ByteContentDoc.Builder)ByteContentDoc.builder().applyMutation(byteContent)).build());
        }

        public Builder s3Location(S3ObjectDoc var1);

        default public Builder s3Location(Consumer<S3ObjectDoc.Builder> s3Location) {
            return this.s3Location((S3ObjectDoc)((S3ObjectDoc.Builder)S3ObjectDoc.builder().applyMutation(s3Location)).build());
        }

        public Builder sourceType(String var1);

        public Builder sourceType(ExternalSourceType var1);
    }
}

