/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReference;
import software.amazon.awssdk.services.bedrockagentruntime.model.RetrievedReferencesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class KnowledgeBaseLookupOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, KnowledgeBaseLookupOutput> {
    private static final SdkField<List<RetrievedReference>> RETRIEVED_REFERENCES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retrievedReferences").getter(KnowledgeBaseLookupOutput.getter(KnowledgeBaseLookupOutput::retrievedReferences)).setter(KnowledgeBaseLookupOutput.setter(Builder::retrievedReferences)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievedReferences").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(RetrievedReference::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RETRIEVED_REFERENCES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = KnowledgeBaseLookupOutput.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final List<RetrievedReference> retrievedReferences;

    private KnowledgeBaseLookupOutput(BuilderImpl builder) {
        this.retrievedReferences = builder.retrievedReferences;
    }

    public final boolean hasRetrievedReferences() {
        return this.retrievedReferences != null && !(this.retrievedReferences instanceof SdkAutoConstructList);
    }

    public final List<RetrievedReference> retrievedReferences() {
        return this.retrievedReferences;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrievedReferences() ? this.retrievedReferences() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof KnowledgeBaseLookupOutput)) {
            return false;
        }
        KnowledgeBaseLookupOutput other = (KnowledgeBaseLookupOutput)obj;
        return this.hasRetrievedReferences() == other.hasRetrievedReferences() && Objects.equals(this.retrievedReferences(), other.retrievedReferences());
    }

    public final String toString() {
        return ToString.builder((String)"KnowledgeBaseLookupOutput").add("RetrievedReferences", this.hasRetrievedReferences() ? this.retrievedReferences() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "retrievedReferences": {
                return Optional.ofNullable(clazz.cast(this.retrievedReferences()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<List<RetrievedReference>>> map = new HashMap<String, SdkField<List<RetrievedReference>>>();
        map.put("retrievedReferences", RETRIEVED_REFERENCES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<KnowledgeBaseLookupOutput, T> g) {
        return obj -> g.apply((KnowledgeBaseLookupOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private List<RetrievedReference> retrievedReferences = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(KnowledgeBaseLookupOutput model) {
            this.retrievedReferences(model.retrievedReferences);
        }

        public final List<RetrievedReference.Builder> getRetrievedReferences() {
            List<RetrievedReference.Builder> result = RetrievedReferencesCopier.copyToBuilder(this.retrievedReferences);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievedReferences(Collection<RetrievedReference.BuilderImpl> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copyFromBuilder(retrievedReferences);
        }

        @Override
        public final Builder retrievedReferences(Collection<RetrievedReference> retrievedReferences) {
            this.retrievedReferences = RetrievedReferencesCopier.copy(retrievedReferences);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(RetrievedReference ... retrievedReferences) {
            this.retrievedReferences(Arrays.asList(retrievedReferences));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievedReferences(Consumer<RetrievedReference.Builder> ... retrievedReferences) {
            this.retrievedReferences(Stream.of(retrievedReferences).map(c -> (RetrievedReference)((RetrievedReference.Builder)RetrievedReference.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public KnowledgeBaseLookupOutput build() {
            return new KnowledgeBaseLookupOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, KnowledgeBaseLookupOutput> {
        public Builder retrievedReferences(Collection<RetrievedReference> var1);

        public Builder retrievedReferences(RetrievedReference ... var1);

        public Builder retrievedReferences(Consumer<RetrievedReference.Builder> ... var1);
    }
}

