/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.GuadrailAction;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResult;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseRetrievalResultsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RetrieveResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, RetrieveResponse> {
    private static final SdkField<String> GUARDRAIL_ACTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("guardrailAction").getter(RetrieveResponse.getter(RetrieveResponse::guardrailActionAsString)).setter(RetrieveResponse.setter(Builder::guardrailAction)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("guardrailAction").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(RetrieveResponse.getter(RetrieveResponse::nextToken)).setter(RetrieveResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<List<KnowledgeBaseRetrievalResult>> RETRIEVAL_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("retrievalResults").getter(RetrieveResponse.getter(RetrieveResponse::retrievalResults)).setter(RetrieveResponse.setter(Builder::retrievalResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("retrievalResults").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(KnowledgeBaseRetrievalResult::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(GUARDRAIL_ACTION_FIELD, NEXT_TOKEN_FIELD, RETRIEVAL_RESULTS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = RetrieveResponse.memberNameToFieldInitializer();
    private final String guardrailAction;
    private final String nextToken;
    private final List<KnowledgeBaseRetrievalResult> retrievalResults;

    private RetrieveResponse(BuilderImpl builder) {
        super(builder);
        this.guardrailAction = builder.guardrailAction;
        this.nextToken = builder.nextToken;
        this.retrievalResults = builder.retrievalResults;
    }

    public final GuadrailAction guardrailAction() {
        return GuadrailAction.fromValue(this.guardrailAction);
    }

    public final String guardrailActionAsString() {
        return this.guardrailAction;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final boolean hasRetrievalResults() {
        return this.retrievalResults != null && !(this.retrievalResults instanceof SdkAutoConstructList);
    }

    public final List<KnowledgeBaseRetrievalResult> retrievalResults() {
        return this.retrievalResults;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.guardrailActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRetrievalResults() ? this.retrievalResults() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RetrieveResponse)) {
            return false;
        }
        RetrieveResponse other = (RetrieveResponse)((Object)obj);
        return Objects.equals(this.guardrailActionAsString(), other.guardrailActionAsString()) && Objects.equals(this.nextToken(), other.nextToken()) && this.hasRetrievalResults() == other.hasRetrievalResults() && Objects.equals(this.retrievalResults(), other.retrievalResults());
    }

    public final String toString() {
        return ToString.builder((String)"RetrieveResponse").add("GuardrailAction", (Object)this.guardrailActionAsString()).add("NextToken", (Object)this.nextToken()).add("RetrievalResults", (Object)(this.retrievalResults() == null ? null : "*** Sensitive Data Redacted ***")).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "guardrailAction": {
                return Optional.ofNullable(clazz.cast(this.guardrailActionAsString()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "retrievalResults": {
                return Optional.ofNullable(clazz.cast(this.retrievalResults()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("guardrailAction", GUARDRAIL_ACTION_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("retrievalResults", RETRIEVAL_RESULTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<RetrieveResponse, T> g) {
        return obj -> g.apply((RetrieveResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private String guardrailAction;
        private String nextToken;
        private List<KnowledgeBaseRetrievalResult> retrievalResults = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(RetrieveResponse model) {
            super(model);
            this.guardrailAction(model.guardrailAction);
            this.nextToken(model.nextToken);
            this.retrievalResults(model.retrievalResults);
        }

        public final String getGuardrailAction() {
            return this.guardrailAction;
        }

        public final void setGuardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
        }

        @Override
        public final Builder guardrailAction(String guardrailAction) {
            this.guardrailAction = guardrailAction;
            return this;
        }

        @Override
        public final Builder guardrailAction(GuadrailAction guardrailAction) {
            this.guardrailAction(guardrailAction == null ? null : guardrailAction.toString());
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final List<KnowledgeBaseRetrievalResult.Builder> getRetrievalResults() {
            List<KnowledgeBaseRetrievalResult.Builder> result = KnowledgeBaseRetrievalResultsCopier.copyToBuilder(this.retrievalResults);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setRetrievalResults(Collection<KnowledgeBaseRetrievalResult.BuilderImpl> retrievalResults) {
            this.retrievalResults = KnowledgeBaseRetrievalResultsCopier.copyFromBuilder(retrievalResults);
        }

        @Override
        public final Builder retrievalResults(Collection<KnowledgeBaseRetrievalResult> retrievalResults) {
            this.retrievalResults = KnowledgeBaseRetrievalResultsCopier.copy(retrievalResults);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievalResults(KnowledgeBaseRetrievalResult ... retrievalResults) {
            this.retrievalResults(Arrays.asList(retrievalResults));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder retrievalResults(Consumer<KnowledgeBaseRetrievalResult.Builder> ... retrievalResults) {
            this.retrievalResults(Stream.of(retrievalResults).map(c -> (KnowledgeBaseRetrievalResult)((KnowledgeBaseRetrievalResult.Builder)KnowledgeBaseRetrievalResult.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public RetrieveResponse build() {
            return new RetrieveResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, RetrieveResponse> {
        public Builder guardrailAction(String var1);

        public Builder guardrailAction(GuadrailAction var1);

        public Builder nextToken(String var1);

        public Builder retrievalResults(Collection<KnowledgeBaseRetrievalResult> var1);

        public Builder retrievalResults(KnowledgeBaseRetrievalResult ... var1);

        public Builder retrievalResults(Consumer<KnowledgeBaseRetrievalResult.Builder> ... var1);
    }
}

