/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.BedrockAgentRuntimeResponse;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummariesCopier;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationSummary;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListInvocationsResponse
extends BedrockAgentRuntimeResponse
implements ToCopyableBuilder<Builder, ListInvocationsResponse> {
    private static final SdkField<List<InvocationSummary>> INVOCATION_SUMMARIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("invocationSummaries").getter(ListInvocationsResponse.getter(ListInvocationsResponse::invocationSummaries)).setter(ListInvocationsResponse.setter(Builder::invocationSummaries)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationSummaries").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(InvocationSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListInvocationsResponse.getter(ListInvocationsResponse::nextToken)).setter(ListInvocationsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INVOCATION_SUMMARIES_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListInvocationsResponse.memberNameToFieldInitializer();
    private final List<InvocationSummary> invocationSummaries;
    private final String nextToken;

    private ListInvocationsResponse(BuilderImpl builder) {
        super(builder);
        this.invocationSummaries = builder.invocationSummaries;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasInvocationSummaries() {
        return this.invocationSummaries != null && !(this.invocationSummaries instanceof SdkAutoConstructList);
    }

    public final List<InvocationSummary> invocationSummaries() {
        return this.invocationSummaries;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasInvocationSummaries() ? this.invocationSummaries() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListInvocationsResponse)) {
            return false;
        }
        ListInvocationsResponse other = (ListInvocationsResponse)((Object)obj);
        return this.hasInvocationSummaries() == other.hasInvocationSummaries() && Objects.equals(this.invocationSummaries(), other.invocationSummaries()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListInvocationsResponse").add("InvocationSummaries", this.hasInvocationSummaries() ? this.invocationSummaries() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "invocationSummaries": {
                return Optional.ofNullable(clazz.cast(this.invocationSummaries()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("invocationSummaries", INVOCATION_SUMMARIES_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListInvocationsResponse, T> g) {
        return obj -> g.apply((ListInvocationsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentRuntimeResponse.BuilderImpl
    implements Builder {
        private List<InvocationSummary> invocationSummaries = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListInvocationsResponse model) {
            super(model);
            this.invocationSummaries(model.invocationSummaries);
            this.nextToken(model.nextToken);
        }

        public final List<InvocationSummary.Builder> getInvocationSummaries() {
            List<InvocationSummary.Builder> result = InvocationSummariesCopier.copyToBuilder(this.invocationSummaries);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setInvocationSummaries(Collection<InvocationSummary.BuilderImpl> invocationSummaries) {
            this.invocationSummaries = InvocationSummariesCopier.copyFromBuilder(invocationSummaries);
        }

        @Override
        public final Builder invocationSummaries(Collection<InvocationSummary> invocationSummaries) {
            this.invocationSummaries = InvocationSummariesCopier.copy(invocationSummaries);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationSummaries(InvocationSummary ... invocationSummaries) {
            this.invocationSummaries(Arrays.asList(invocationSummaries));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder invocationSummaries(Consumer<InvocationSummary.Builder> ... invocationSummaries) {
            this.invocationSummaries(Stream.of(invocationSummaries).map(c -> (InvocationSummary)((InvocationSummary.Builder)InvocationSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListInvocationsResponse build() {
            return new ListInvocationsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends BedrockAgentRuntimeResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListInvocationsResponse> {
        public Builder invocationSummaries(Collection<InvocationSummary> var1);

        public Builder invocationSummaries(InvocationSummary ... var1);

        public Builder invocationSummaries(Consumer<InvocationSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

