/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentruntime.model.ActionGroupInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.CodeInterpreterInvocationInput;
import software.amazon.awssdk.services.bedrockagentruntime.model.InvocationType;
import software.amazon.awssdk.services.bedrockagentruntime.model.KnowledgeBaseLookupInput;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class InvocationInput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, InvocationInput> {
    private static final SdkField<ActionGroupInvocationInput> ACTION_GROUP_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("actionGroupInvocationInput").getter(InvocationInput.getter(InvocationInput::actionGroupInvocationInput)).setter(InvocationInput.setter(Builder::actionGroupInvocationInput)).constructor(ActionGroupInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("actionGroupInvocationInput").build()}).build();
    private static final SdkField<CodeInterpreterInvocationInput> CODE_INTERPRETER_INVOCATION_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("codeInterpreterInvocationInput").getter(InvocationInput.getter(InvocationInput::codeInterpreterInvocationInput)).setter(InvocationInput.setter(Builder::codeInterpreterInvocationInput)).constructor(CodeInterpreterInvocationInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeInterpreterInvocationInput").build()}).build();
    private static final SdkField<String> INVOCATION_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("invocationType").getter(InvocationInput.getter(InvocationInput::invocationTypeAsString)).setter(InvocationInput.setter(Builder::invocationType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("invocationType").build()}).build();
    private static final SdkField<KnowledgeBaseLookupInput> KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("knowledgeBaseLookupInput").getter(InvocationInput.getter(InvocationInput::knowledgeBaseLookupInput)).setter(InvocationInput.setter(Builder::knowledgeBaseLookupInput)).constructor(KnowledgeBaseLookupInput::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("knowledgeBaseLookupInput").build()}).build();
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("traceId").getter(InvocationInput.getter(InvocationInput::traceId)).setter(InvocationInput.setter(Builder::traceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ACTION_GROUP_INVOCATION_INPUT_FIELD, CODE_INTERPRETER_INVOCATION_INPUT_FIELD, INVOCATION_TYPE_FIELD, KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD, TRACE_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("actionGroupInvocationInput", ACTION_GROUP_INVOCATION_INPUT_FIELD);
            this.put("codeInterpreterInvocationInput", CODE_INTERPRETER_INVOCATION_INPUT_FIELD);
            this.put("invocationType", INVOCATION_TYPE_FIELD);
            this.put("knowledgeBaseLookupInput", KNOWLEDGE_BASE_LOOKUP_INPUT_FIELD);
            this.put("traceId", TRACE_ID_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final ActionGroupInvocationInput actionGroupInvocationInput;
    private final CodeInterpreterInvocationInput codeInterpreterInvocationInput;
    private final String invocationType;
    private final KnowledgeBaseLookupInput knowledgeBaseLookupInput;
    private final String traceId;

    private InvocationInput(BuilderImpl builder) {
        this.actionGroupInvocationInput = builder.actionGroupInvocationInput;
        this.codeInterpreterInvocationInput = builder.codeInterpreterInvocationInput;
        this.invocationType = builder.invocationType;
        this.knowledgeBaseLookupInput = builder.knowledgeBaseLookupInput;
        this.traceId = builder.traceId;
    }

    public final ActionGroupInvocationInput actionGroupInvocationInput() {
        return this.actionGroupInvocationInput;
    }

    public final CodeInterpreterInvocationInput codeInterpreterInvocationInput() {
        return this.codeInterpreterInvocationInput;
    }

    public final InvocationType invocationType() {
        return InvocationType.fromValue(this.invocationType);
    }

    public final String invocationTypeAsString() {
        return this.invocationType;
    }

    public final KnowledgeBaseLookupInput knowledgeBaseLookupInput() {
        return this.knowledgeBaseLookupInput;
    }

    public final String traceId() {
        return this.traceId;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.actionGroupInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.codeInterpreterInvocationInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.invocationTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.knowledgeBaseLookupInput());
        hashCode = 31 * hashCode + Objects.hashCode(this.traceId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvocationInput)) {
            return false;
        }
        InvocationInput other = (InvocationInput)obj;
        return Objects.equals(this.actionGroupInvocationInput(), other.actionGroupInvocationInput()) && Objects.equals(this.codeInterpreterInvocationInput(), other.codeInterpreterInvocationInput()) && Objects.equals(this.invocationTypeAsString(), other.invocationTypeAsString()) && Objects.equals(this.knowledgeBaseLookupInput(), other.knowledgeBaseLookupInput()) && Objects.equals(this.traceId(), other.traceId());
    }

    public final String toString() {
        return ToString.builder((String)"InvocationInput").add("ActionGroupInvocationInput", (Object)this.actionGroupInvocationInput()).add("CodeInterpreterInvocationInput", (Object)this.codeInterpreterInvocationInput()).add("InvocationType", (Object)this.invocationTypeAsString()).add("KnowledgeBaseLookupInput", (Object)this.knowledgeBaseLookupInput()).add("TraceId", (Object)this.traceId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "actionGroupInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.actionGroupInvocationInput()));
            }
            case "codeInterpreterInvocationInput": {
                return Optional.ofNullable(clazz.cast(this.codeInterpreterInvocationInput()));
            }
            case "invocationType": {
                return Optional.ofNullable(clazz.cast(this.invocationTypeAsString()));
            }
            case "knowledgeBaseLookupInput": {
                return Optional.ofNullable(clazz.cast(this.knowledgeBaseLookupInput()));
            }
            case "traceId": {
                return Optional.ofNullable(clazz.cast(this.traceId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<InvocationInput, T> g) {
        return obj -> g.apply((InvocationInput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ActionGroupInvocationInput actionGroupInvocationInput;
        private CodeInterpreterInvocationInput codeInterpreterInvocationInput;
        private String invocationType;
        private KnowledgeBaseLookupInput knowledgeBaseLookupInput;
        private String traceId;

        private BuilderImpl() {
        }

        private BuilderImpl(InvocationInput model) {
            this.actionGroupInvocationInput(model.actionGroupInvocationInput);
            this.codeInterpreterInvocationInput(model.codeInterpreterInvocationInput);
            this.invocationType(model.invocationType);
            this.knowledgeBaseLookupInput(model.knowledgeBaseLookupInput);
            this.traceId(model.traceId);
        }

        public final ActionGroupInvocationInput.Builder getActionGroupInvocationInput() {
            return this.actionGroupInvocationInput != null ? this.actionGroupInvocationInput.toBuilder() : null;
        }

        public final void setActionGroupInvocationInput(ActionGroupInvocationInput.BuilderImpl actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput != null ? actionGroupInvocationInput.build() : null;
        }

        @Override
        public final Builder actionGroupInvocationInput(ActionGroupInvocationInput actionGroupInvocationInput) {
            this.actionGroupInvocationInput = actionGroupInvocationInput;
            return this;
        }

        public final CodeInterpreterInvocationInput.Builder getCodeInterpreterInvocationInput() {
            return this.codeInterpreterInvocationInput != null ? this.codeInterpreterInvocationInput.toBuilder() : null;
        }

        public final void setCodeInterpreterInvocationInput(CodeInterpreterInvocationInput.BuilderImpl codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput != null ? codeInterpreterInvocationInput.build() : null;
        }

        @Override
        public final Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput codeInterpreterInvocationInput) {
            this.codeInterpreterInvocationInput = codeInterpreterInvocationInput;
            return this;
        }

        public final String getInvocationType() {
            return this.invocationType;
        }

        public final void setInvocationType(String invocationType) {
            this.invocationType = invocationType;
        }

        @Override
        public final Builder invocationType(String invocationType) {
            this.invocationType = invocationType;
            return this;
        }

        @Override
        public final Builder invocationType(InvocationType invocationType) {
            this.invocationType(invocationType == null ? null : invocationType.toString());
            return this;
        }

        public final KnowledgeBaseLookupInput.Builder getKnowledgeBaseLookupInput() {
            return this.knowledgeBaseLookupInput != null ? this.knowledgeBaseLookupInput.toBuilder() : null;
        }

        public final void setKnowledgeBaseLookupInput(KnowledgeBaseLookupInput.BuilderImpl knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput != null ? knowledgeBaseLookupInput.build() : null;
        }

        @Override
        public final Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput knowledgeBaseLookupInput) {
            this.knowledgeBaseLookupInput = knowledgeBaseLookupInput;
            return this;
        }

        public final String getTraceId() {
            return this.traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public InvocationInput build() {
            return new InvocationInput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, InvocationInput> {
        public Builder actionGroupInvocationInput(ActionGroupInvocationInput var1);

        default public Builder actionGroupInvocationInput(Consumer<ActionGroupInvocationInput.Builder> actionGroupInvocationInput) {
            return this.actionGroupInvocationInput((ActionGroupInvocationInput)((ActionGroupInvocationInput.Builder)ActionGroupInvocationInput.builder().applyMutation(actionGroupInvocationInput)).build());
        }

        public Builder codeInterpreterInvocationInput(CodeInterpreterInvocationInput var1);

        default public Builder codeInterpreterInvocationInput(Consumer<CodeInterpreterInvocationInput.Builder> codeInterpreterInvocationInput) {
            return this.codeInterpreterInvocationInput((CodeInterpreterInvocationInput)((CodeInterpreterInvocationInput.Builder)CodeInterpreterInvocationInput.builder().applyMutation(codeInterpreterInvocationInput)).build());
        }

        public Builder invocationType(String var1);

        public Builder invocationType(InvocationType var1);

        public Builder knowledgeBaseLookupInput(KnowledgeBaseLookupInput var1);

        default public Builder knowledgeBaseLookupInput(Consumer<KnowledgeBaseLookupInput.Builder> knowledgeBaseLookupInput) {
            return this.knowledgeBaseLookupInput((KnowledgeBaseLookupInput)((KnowledgeBaseLookupInput.Builder)KnowledgeBaseLookupInput.builder().applyMutation(knowledgeBaseLookupInput)).build());
        }

        public Builder traceId(String var1);
    }
}

