/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptConfiguration;
import software.amazon.awssdk.services.bedrockagentruntime.model.PromptConfigurationsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class PromptOverrideConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, PromptOverrideConfiguration> {
    private static final SdkField<String> OVERRIDE_LAMBDA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("overrideLambda").getter(PromptOverrideConfiguration.getter(PromptOverrideConfiguration::overrideLambda)).setter(PromptOverrideConfiguration.setter(Builder::overrideLambda)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("overrideLambda").build()}).build();
    private static final SdkField<List<PromptConfiguration>> PROMPT_CONFIGURATIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("promptConfigurations").getter(PromptOverrideConfiguration.getter(PromptOverrideConfiguration::promptConfigurations)).setter(PromptOverrideConfiguration.setter(Builder::promptConfigurations)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("promptConfigurations").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(PromptConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OVERRIDE_LAMBDA_FIELD, PROMPT_CONFIGURATIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("overrideLambda", OVERRIDE_LAMBDA_FIELD);
            this.put("promptConfigurations", PROMPT_CONFIGURATIONS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String overrideLambda;
    private final List<PromptConfiguration> promptConfigurations;

    private PromptOverrideConfiguration(BuilderImpl builder) {
        this.overrideLambda = builder.overrideLambda;
        this.promptConfigurations = builder.promptConfigurations;
    }

    public final String overrideLambda() {
        return this.overrideLambda;
    }

    public final boolean hasPromptConfigurations() {
        return this.promptConfigurations != null && !(this.promptConfigurations instanceof SdkAutoConstructList);
    }

    public final List<PromptConfiguration> promptConfigurations() {
        return this.promptConfigurations;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.overrideLambda());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasPromptConfigurations() ? this.promptConfigurations() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PromptOverrideConfiguration)) {
            return false;
        }
        PromptOverrideConfiguration other = (PromptOverrideConfiguration)obj;
        return Objects.equals(this.overrideLambda(), other.overrideLambda()) && this.hasPromptConfigurations() == other.hasPromptConfigurations() && Objects.equals(this.promptConfigurations(), other.promptConfigurations());
    }

    public final String toString() {
        return ToString.builder((String)"PromptOverrideConfiguration").add("OverrideLambda", (Object)this.overrideLambda()).add("PromptConfigurations", this.hasPromptConfigurations() ? this.promptConfigurations() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "overrideLambda": {
                return Optional.ofNullable(clazz.cast(this.overrideLambda()));
            }
            case "promptConfigurations": {
                return Optional.ofNullable(clazz.cast(this.promptConfigurations()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<PromptOverrideConfiguration, T> g) {
        return obj -> g.apply((PromptOverrideConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String overrideLambda;
        private List<PromptConfiguration> promptConfigurations = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(PromptOverrideConfiguration model) {
            this.overrideLambda(model.overrideLambda);
            this.promptConfigurations(model.promptConfigurations);
        }

        public final String getOverrideLambda() {
            return this.overrideLambda;
        }

        public final void setOverrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
        }

        @Override
        public final Builder overrideLambda(String overrideLambda) {
            this.overrideLambda = overrideLambda;
            return this;
        }

        public final List<PromptConfiguration.Builder> getPromptConfigurations() {
            List<PromptConfiguration.Builder> result = PromptConfigurationsCopier.copyToBuilder(this.promptConfigurations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setPromptConfigurations(Collection<PromptConfiguration.BuilderImpl> promptConfigurations) {
            this.promptConfigurations = PromptConfigurationsCopier.copyFromBuilder(promptConfigurations);
        }

        @Override
        public final Builder promptConfigurations(Collection<PromptConfiguration> promptConfigurations) {
            this.promptConfigurations = PromptConfigurationsCopier.copy(promptConfigurations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptConfigurations(PromptConfiguration ... promptConfigurations) {
            this.promptConfigurations(Arrays.asList(promptConfigurations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder promptConfigurations(Consumer<PromptConfiguration.Builder> ... promptConfigurations) {
            this.promptConfigurations(Stream.of(promptConfigurations).map(c -> (PromptConfiguration)((PromptConfiguration.Builder)PromptConfiguration.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public PromptOverrideConfiguration build() {
            return new PromptOverrideConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, PromptOverrideConfiguration> {
        public Builder overrideLambda(String var1);

        public Builder promptConfigurations(Collection<PromptConfiguration> var1);

        public Builder promptConfigurations(PromptConfiguration ... var1);

        public Builder promptConfigurations(Consumer<PromptConfiguration.Builder> ... var1);
    }
}

