/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum FileSourceType {
    S3("S3"),
    BYTE_CONTENT("BYTE_CONTENT"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, FileSourceType> VALUE_MAP;
    private final String value;

    private FileSourceType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static FileSourceType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<FileSourceType> knownValues() {
        EnumSet<FileSourceType> knownValues = EnumSet.allOf(FileSourceType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(FileSourceType.class, FileSourceType::toString);
    }
}

