/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentruntime.model.FilesCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CodeInterpreterInvocationOutput
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, CodeInterpreterInvocationOutput> {
    private static final SdkField<String> EXECUTION_ERROR_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionError").getter(CodeInterpreterInvocationOutput.getter(CodeInterpreterInvocationOutput::executionError)).setter(CodeInterpreterInvocationOutput.setter(Builder::executionError)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionError").build()}).build();
    private static final SdkField<String> EXECUTION_OUTPUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionOutput").getter(CodeInterpreterInvocationOutput.getter(CodeInterpreterInvocationOutput::executionOutput)).setter(CodeInterpreterInvocationOutput.setter(Builder::executionOutput)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionOutput").build()}).build();
    private static final SdkField<Boolean> EXECUTION_TIMEOUT_FIELD = SdkField.builder((MarshallingType)MarshallingType.BOOLEAN).memberName("executionTimeout").getter(CodeInterpreterInvocationOutput.getter(CodeInterpreterInvocationOutput::executionTimeout)).setter(CodeInterpreterInvocationOutput.setter(Builder::executionTimeout)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionTimeout").build()}).build();
    private static final SdkField<List<String>> FILES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("files").getter(CodeInterpreterInvocationOutput.getter(CodeInterpreterInvocationOutput::files)).setter(CodeInterpreterInvocationOutput.setter(Builder::files)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("files").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EXECUTION_ERROR_FIELD, EXECUTION_OUTPUT_FIELD, EXECUTION_TIMEOUT_FIELD, FILES_FIELD));
    private static final long serialVersionUID = 1L;
    private final String executionError;
    private final String executionOutput;
    private final Boolean executionTimeout;
    private final List<String> files;

    private CodeInterpreterInvocationOutput(BuilderImpl builder) {
        this.executionError = builder.executionError;
        this.executionOutput = builder.executionOutput;
        this.executionTimeout = builder.executionTimeout;
        this.files = builder.files;
    }

    public final String executionError() {
        return this.executionError;
    }

    public final String executionOutput() {
        return this.executionOutput;
    }

    public final Boolean executionTimeout() {
        return this.executionTimeout;
    }

    public final boolean hasFiles() {
        return this.files != null && !(this.files instanceof SdkAutoConstructList);
    }

    public final List<String> files() {
        return this.files;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.executionError());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionOutput());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionTimeout());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasFiles() ? this.files() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CodeInterpreterInvocationOutput)) {
            return false;
        }
        CodeInterpreterInvocationOutput other = (CodeInterpreterInvocationOutput)obj;
        return Objects.equals(this.executionError(), other.executionError()) && Objects.equals(this.executionOutput(), other.executionOutput()) && Objects.equals(this.executionTimeout(), other.executionTimeout()) && this.hasFiles() == other.hasFiles() && Objects.equals(this.files(), other.files());
    }

    public final String toString() {
        return ToString.builder((String)"CodeInterpreterInvocationOutput").add("ExecutionError", (Object)this.executionError()).add("ExecutionOutput", (Object)this.executionOutput()).add("ExecutionTimeout", (Object)this.executionTimeout()).add("Files", this.hasFiles() ? this.files() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "executionError": {
                return Optional.ofNullable(clazz.cast(this.executionError()));
            }
            case "executionOutput": {
                return Optional.ofNullable(clazz.cast(this.executionOutput()));
            }
            case "executionTimeout": {
                return Optional.ofNullable(clazz.cast(this.executionTimeout()));
            }
            case "files": {
                return Optional.ofNullable(clazz.cast(this.files()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<CodeInterpreterInvocationOutput, T> g) {
        return obj -> g.apply((CodeInterpreterInvocationOutput)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String executionError;
        private String executionOutput;
        private Boolean executionTimeout;
        private List<String> files = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CodeInterpreterInvocationOutput model) {
            this.executionError(model.executionError);
            this.executionOutput(model.executionOutput);
            this.executionTimeout(model.executionTimeout);
            this.files(model.files);
        }

        public final String getExecutionError() {
            return this.executionError;
        }

        public final void setExecutionError(String executionError) {
            this.executionError = executionError;
        }

        @Override
        public final Builder executionError(String executionError) {
            this.executionError = executionError;
            return this;
        }

        public final String getExecutionOutput() {
            return this.executionOutput;
        }

        public final void setExecutionOutput(String executionOutput) {
            this.executionOutput = executionOutput;
        }

        @Override
        public final Builder executionOutput(String executionOutput) {
            this.executionOutput = executionOutput;
            return this;
        }

        public final Boolean getExecutionTimeout() {
            return this.executionTimeout;
        }

        public final void setExecutionTimeout(Boolean executionTimeout) {
            this.executionTimeout = executionTimeout;
        }

        @Override
        public final Builder executionTimeout(Boolean executionTimeout) {
            this.executionTimeout = executionTimeout;
            return this;
        }

        public final Collection<String> getFiles() {
            if (this.files instanceof SdkAutoConstructList) {
                return null;
            }
            return this.files;
        }

        public final void setFiles(Collection<String> files) {
            this.files = FilesCopier.copy(files);
        }

        @Override
        public final Builder files(Collection<String> files) {
            this.files = FilesCopier.copy(files);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder files(String ... files) {
            this.files(Arrays.asList(files));
            return this;
        }

        public CodeInterpreterInvocationOutput build() {
            return new CodeInterpreterInvocationOutput(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, CodeInterpreterInvocationOutput> {
        public Builder executionError(String var1);

        public Builder executionOutput(String var1);

        public Builder executionTimeout(Boolean var1);

        public Builder files(Collection<String> var1);

        public Builder files(String ... var1);
    }
}

