/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum PromptType {
    PRE_PROCESSING("PRE_PROCESSING"),
    ORCHESTRATION("ORCHESTRATION"),
    KNOWLEDGE_BASE_RESPONSE_GENERATION("KNOWLEDGE_BASE_RESPONSE_GENERATION"),
    POST_PROCESSING("POST_PROCESSING"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, PromptType> VALUE_MAP;
    private final String value;

    private PromptType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PromptType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<PromptType> knownValues() {
        EnumSet<PromptType> knownValues = EnumSet.allOf(PromptType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(PromptType.class, PromptType::toString);
    }
}

