/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Trace Part which contains information related to reasoning
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Rationale implements SdkPojo, Serializable, ToCopyableBuilder<Rationale.Builder, Rationale> {
    private static final SdkField<String> TRACE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("traceId").getter(getter(Rationale::traceId)).setter(setter(Builder::traceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("traceId").build()).build();

    private static final SdkField<String> TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("text")
            .getter(getter(Rationale::text)).setter(setter(Builder::text))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("text").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRACE_ID_FIELD, TEXT_FIELD));

    private static final long serialVersionUID = 1L;

    private final String traceId;

    private final String text;

    private Rationale(BuilderImpl builder) {
        this.traceId = builder.traceId;
        this.text = builder.text;
    }

    /**
     * Returns the value of the TraceId property for this object.
     * 
     * @return The value of the TraceId property for this object.
     */
    public final String traceId() {
        return traceId;
    }

    /**
     * Returns the value of the Text property for this object.
     * 
     * @return The value of the Text property for this object.
     */
    public final String text() {
        return text;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(traceId());
        hashCode = 31 * hashCode + Objects.hashCode(text());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Rationale)) {
            return false;
        }
        Rationale other = (Rationale) obj;
        return Objects.equals(traceId(), other.traceId()) && Objects.equals(text(), other.text());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Rationale").add("TraceId", traceId())
                .add("Text", text() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "traceId":
            return Optional.ofNullable(clazz.cast(traceId()));
        case "text":
            return Optional.ofNullable(clazz.cast(text()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<Rationale, T> g) {
        return obj -> g.apply((Rationale) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Rationale> {
        /**
         * Sets the value of the TraceId property for this object.
         *
         * @param traceId
         *        The new value for the TraceId property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder traceId(String traceId);

        /**
         * Sets the value of the Text property for this object.
         *
         * @param text
         *        The new value for the Text property for this object.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder text(String text);
    }

    static final class BuilderImpl implements Builder {
        private String traceId;

        private String text;

        private BuilderImpl() {
        }

        private BuilderImpl(Rationale model) {
            traceId(model.traceId);
            text(model.text);
        }

        public final String getTraceId() {
            return traceId;
        }

        public final void setTraceId(String traceId) {
            this.traceId = traceId;
        }

        @Override
        public final Builder traceId(String traceId) {
            this.traceId = traceId;
            return this;
        }

        public final String getText() {
            return text;
        }

        public final void setText(String text) {
            this.text = text;
        }

        @Override
        public final Builder text(String text) {
            this.text = text;
            return this;
        }

        @Override
        public Rationale build() {
            return new Rationale(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
