/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.bedrockagentruntime.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * InvokeAgent Request
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class InvokeAgentRequest extends BedrockAgentRuntimeRequest implements
        ToCopyableBuilder<InvokeAgentRequest.Builder, InvokeAgentRequest> {
    private static final SdkField<SessionState> SESSION_STATE_FIELD = SdkField.<SessionState> builder(MarshallingType.SDK_POJO)
            .memberName("sessionState").getter(getter(InvokeAgentRequest::sessionState)).setter(setter(Builder::sessionState))
            .constructor(SessionState::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionState").build()).build();

    private static final SdkField<String> AGENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentId").getter(getter(InvokeAgentRequest::agentId)).setter(setter(Builder::agentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentId").build()).build();

    private static final SdkField<String> AGENT_ALIAS_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("agentAliasId").getter(getter(InvokeAgentRequest::agentAliasId)).setter(setter(Builder::agentAliasId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("agentAliasId").build()).build();

    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(InvokeAgentRequest::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()).build();

    private static final SdkField<Boolean> END_SESSION_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("endSession").getter(getter(InvokeAgentRequest::endSession)).setter(setter(Builder::endSession))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endSession").build()).build();

    private static final SdkField<Boolean> ENABLE_TRACE_FIELD = SdkField.<Boolean> builder(MarshallingType.BOOLEAN)
            .memberName("enableTrace").getter(getter(InvokeAgentRequest::enableTrace)).setter(setter(Builder::enableTrace))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("enableTrace").build()).build();

    private static final SdkField<String> INPUT_TEXT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("inputText").getter(getter(InvokeAgentRequest::inputText)).setter(setter(Builder::inputText))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("inputText").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_STATE_FIELD,
            AGENT_ID_FIELD, AGENT_ALIAS_ID_FIELD, SESSION_ID_FIELD, END_SESSION_FIELD, ENABLE_TRACE_FIELD, INPUT_TEXT_FIELD));

    private final SessionState sessionState;

    private final String agentId;

    private final String agentAliasId;

    private final String sessionId;

    private final Boolean endSession;

    private final Boolean enableTrace;

    private final String inputText;

    private InvokeAgentRequest(BuilderImpl builder) {
        super(builder);
        this.sessionState = builder.sessionState;
        this.agentId = builder.agentId;
        this.agentAliasId = builder.agentAliasId;
        this.sessionId = builder.sessionId;
        this.endSession = builder.endSession;
        this.enableTrace = builder.enableTrace;
        this.inputText = builder.inputText;
    }

    /**
     * <p>
     * Session state passed by customer. Base64 encoded json string representation of SessionState.
     * </p>
     * 
     * @return Session state passed by customer. Base64 encoded json string representation of SessionState.
     */
    public final SessionState sessionState() {
        return sessionState;
    }

    /**
     * <p>
     * Identifier for Agent
     * </p>
     * 
     * @return Identifier for Agent
     */
    public final String agentId() {
        return agentId;
    }

    /**
     * <p>
     * Identifier for Agent Alias
     * </p>
     * 
     * @return Identifier for Agent Alias
     */
    public final String agentAliasId() {
        return agentAliasId;
    }

    /**
     * <p>
     * Identifier used for the current session
     * </p>
     * 
     * @return Identifier used for the current session
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * End current session
     * </p>
     * 
     * @return End current session
     */
    public final Boolean endSession() {
        return endSession;
    }

    /**
     * <p>
     * Enable agent trace events for improved debugging
     * </p>
     * 
     * @return Enable agent trace events for improved debugging
     */
    public final Boolean enableTrace() {
        return enableTrace;
    }

    /**
     * <p>
     * Input data in the format specified in the Content-Type request header.
     * </p>
     * 
     * @return Input data in the format specified in the Content-Type request header.
     */
    public final String inputText() {
        return inputText;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionState());
        hashCode = 31 * hashCode + Objects.hashCode(agentId());
        hashCode = 31 * hashCode + Objects.hashCode(agentAliasId());
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(endSession());
        hashCode = 31 * hashCode + Objects.hashCode(enableTrace());
        hashCode = 31 * hashCode + Objects.hashCode(inputText());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof InvokeAgentRequest)) {
            return false;
        }
        InvokeAgentRequest other = (InvokeAgentRequest) obj;
        return Objects.equals(sessionState(), other.sessionState()) && Objects.equals(agentId(), other.agentId())
                && Objects.equals(agentAliasId(), other.agentAliasId()) && Objects.equals(sessionId(), other.sessionId())
                && Objects.equals(endSession(), other.endSession()) && Objects.equals(enableTrace(), other.enableTrace())
                && Objects.equals(inputText(), other.inputText());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("InvokeAgentRequest").add("SessionState", sessionState()).add("AgentId", agentId())
                .add("AgentAliasId", agentAliasId()).add("SessionId", sessionId()).add("EndSession", endSession())
                .add("EnableTrace", enableTrace())
                .add("InputText", inputText() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionState":
            return Optional.ofNullable(clazz.cast(sessionState()));
        case "agentId":
            return Optional.ofNullable(clazz.cast(agentId()));
        case "agentAliasId":
            return Optional.ofNullable(clazz.cast(agentAliasId()));
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "endSession":
            return Optional.ofNullable(clazz.cast(endSession()));
        case "enableTrace":
            return Optional.ofNullable(clazz.cast(enableTrace()));
        case "inputText":
            return Optional.ofNullable(clazz.cast(inputText()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<InvokeAgentRequest, T> g) {
        return obj -> g.apply((InvokeAgentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends BedrockAgentRuntimeRequest.Builder, SdkPojo, CopyableBuilder<Builder, InvokeAgentRequest> {
        /**
         * <p>
         * Session state passed by customer. Base64 encoded json string representation of SessionState.
         * </p>
         * 
         * @param sessionState
         *        Session state passed by customer. Base64 encoded json string representation of SessionState.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionState(SessionState sessionState);

        /**
         * <p>
         * Session state passed by customer. Base64 encoded json string representation of SessionState.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionState.Builder} avoiding the need
         * to create one manually via {@link SessionState#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionState.Builder#build()} is called immediately and its
         * result is passed to {@link #sessionState(SessionState)}.
         * 
         * @param sessionState
         *        a consumer that will call methods on {@link SessionState.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessionState(SessionState)
         */
        default Builder sessionState(Consumer<SessionState.Builder> sessionState) {
            return sessionState(SessionState.builder().applyMutation(sessionState).build());
        }

        /**
         * <p>
         * Identifier for Agent
         * </p>
         * 
         * @param agentId
         *        Identifier for Agent
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentId(String agentId);

        /**
         * <p>
         * Identifier for Agent Alias
         * </p>
         * 
         * @param agentAliasId
         *        Identifier for Agent Alias
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder agentAliasId(String agentAliasId);

        /**
         * <p>
         * Identifier used for the current session
         * </p>
         * 
         * @param sessionId
         *        Identifier used for the current session
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * End current session
         * </p>
         * 
         * @param endSession
         *        End current session
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endSession(Boolean endSession);

        /**
         * <p>
         * Enable agent trace events for improved debugging
         * </p>
         * 
         * @param enableTrace
         *        Enable agent trace events for improved debugging
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder enableTrace(Boolean enableTrace);

        /**
         * <p>
         * Input data in the format specified in the Content-Type request header.
         * </p>
         * 
         * @param inputText
         *        Input data in the format specified in the Content-Type request header.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder inputText(String inputText);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends BedrockAgentRuntimeRequest.BuilderImpl implements Builder {
        private SessionState sessionState;

        private String agentId;

        private String agentAliasId;

        private String sessionId;

        private Boolean endSession;

        private Boolean enableTrace;

        private String inputText;

        private BuilderImpl() {
        }

        private BuilderImpl(InvokeAgentRequest model) {
            super(model);
            sessionState(model.sessionState);
            agentId(model.agentId);
            agentAliasId(model.agentAliasId);
            sessionId(model.sessionId);
            endSession(model.endSession);
            enableTrace(model.enableTrace);
            inputText(model.inputText);
        }

        public final SessionState.Builder getSessionState() {
            return sessionState != null ? sessionState.toBuilder() : null;
        }

        public final void setSessionState(SessionState.BuilderImpl sessionState) {
            this.sessionState = sessionState != null ? sessionState.build() : null;
        }

        @Override
        public final Builder sessionState(SessionState sessionState) {
            this.sessionState = sessionState;
            return this;
        }

        public final String getAgentId() {
            return agentId;
        }

        public final void setAgentId(String agentId) {
            this.agentId = agentId;
        }

        @Override
        public final Builder agentId(String agentId) {
            this.agentId = agentId;
            return this;
        }

        public final String getAgentAliasId() {
            return agentAliasId;
        }

        public final void setAgentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
        }

        @Override
        public final Builder agentAliasId(String agentAliasId) {
            this.agentAliasId = agentAliasId;
            return this;
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final Boolean getEndSession() {
            return endSession;
        }

        public final void setEndSession(Boolean endSession) {
            this.endSession = endSession;
        }

        @Override
        public final Builder endSession(Boolean endSession) {
            this.endSession = endSession;
            return this;
        }

        public final Boolean getEnableTrace() {
            return enableTrace;
        }

        public final void setEnableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
        }

        @Override
        public final Builder enableTrace(Boolean enableTrace) {
            this.enableTrace = enableTrace;
            return this;
        }

        public final String getInputText() {
            return inputText;
        }

        public final void setInputText(String inputText) {
            this.inputText = inputText;
        }

        @Override
        public final Builder inputText(String inputText) {
            this.inputText = inputText;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public InvokeAgentRequest build() {
            return new InvokeAgentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
