/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum MemoryView {
    FULL("full"),
    WITHOUT_DECRYPTION("without_decryption"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, MemoryView> VALUE_MAP;
    private final String value;

    private MemoryView(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static MemoryView fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<MemoryView> knownValues() {
        EnumSet<MemoryView> knownValues = EnumSet.allOf(MemoryView.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(MemoryView.class, MemoryView::toString);
    }
}

