/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListEvaluatorsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListEvaluatorsResponse;

public class ListEvaluatorsPublisher
implements SdkPublisher<ListEvaluatorsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListEvaluatorsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListEvaluatorsPublisher(BedrockAgentCoreControlAsyncClient client, ListEvaluatorsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListEvaluatorsPublisher(BedrockAgentCoreControlAsyncClient client, ListEvaluatorsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListEvaluatorsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListEvaluatorsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<EvaluatorSummary> evaluators() {
        Function<ListEvaluatorsResponse, Iterator> getIterator = response -> {
            if (response != null && response.evaluators() != null) {
                return response.evaluators().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListEvaluatorsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListEvaluatorsResponseFetcher
    implements AsyncPageFetcher<ListEvaluatorsResponse> {
        private ListEvaluatorsResponseFetcher() {
        }

        public boolean hasNextPage(ListEvaluatorsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListEvaluatorsResponse> nextPage(ListEvaluatorsResponse previousPage) {
            if (previousPage == null) {
                return ListEvaluatorsPublisher.this.client.listEvaluators(ListEvaluatorsPublisher.this.firstRequest);
            }
            return ListEvaluatorsPublisher.this.client.listEvaluators((ListEvaluatorsRequest)((Object)ListEvaluatorsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

