/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialProviderItem;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;

public class ListApiKeyCredentialProvidersIterable
implements SdkIterable<ListApiKeyCredentialProvidersResponse> {
    private final BedrockAgentCoreControlClient client;
    private final ListApiKeyCredentialProvidersRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListApiKeyCredentialProvidersIterable(BedrockAgentCoreControlClient client, ListApiKeyCredentialProvidersRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListApiKeyCredentialProvidersResponseFetcher();
    }

    public Iterator<ListApiKeyCredentialProvidersResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ApiKeyCredentialProviderItem> credentialProviders() {
        Function<ListApiKeyCredentialProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.credentialProviders() != null) {
                return response.credentialProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListApiKeyCredentialProvidersResponseFetcher
    implements SyncPageFetcher<ListApiKeyCredentialProvidersResponse> {
        private ListApiKeyCredentialProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListApiKeyCredentialProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListApiKeyCredentialProvidersResponse nextPage(ListApiKeyCredentialProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListApiKeyCredentialProvidersIterable.this.client.listApiKeyCredentialProviders(ListApiKeyCredentialProvidersIterable.this.firstRequest);
            }
            return ListApiKeyCredentialProvidersIterable.this.client.listApiKeyCredentialProviders((ListApiKeyCredentialProvidersRequest)((Object)ListApiKeyCredentialProvidersIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

