/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DeleteOnlineEvaluationConfigResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, DeleteOnlineEvaluationConfigResponse> {
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigArn").getter(DeleteOnlineEvaluationConfigResponse.getter(DeleteOnlineEvaluationConfigResponse::onlineEvaluationConfigArn)).setter(DeleteOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigArn").build()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigId").getter(DeleteOnlineEvaluationConfigResponse.getter(DeleteOnlineEvaluationConfigResponse::onlineEvaluationConfigId)).setter(DeleteOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(DeleteOnlineEvaluationConfigResponse.getter(DeleteOnlineEvaluationConfigResponse::statusAsString)).setter(DeleteOnlineEvaluationConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONLINE_EVALUATION_CONFIG_ARN_FIELD, ONLINE_EVALUATION_CONFIG_ID_FIELD, STATUS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DeleteOnlineEvaluationConfigResponse.memberNameToFieldInitializer();
    private final String onlineEvaluationConfigArn;
    private final String onlineEvaluationConfigId;
    private final String status;

    private DeleteOnlineEvaluationConfigResponse(BuilderImpl builder) {
        super(builder);
        this.onlineEvaluationConfigArn = builder.onlineEvaluationConfigArn;
        this.onlineEvaluationConfigId = builder.onlineEvaluationConfigId;
        this.status = builder.status;
    }

    public final String onlineEvaluationConfigArn() {
        return this.onlineEvaluationConfigArn;
    }

    public final String onlineEvaluationConfigId() {
        return this.onlineEvaluationConfigId;
    }

    public final OnlineEvaluationConfigStatus status() {
        return OnlineEvaluationConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteOnlineEvaluationConfigResponse)) {
            return false;
        }
        DeleteOnlineEvaluationConfigResponse other = (DeleteOnlineEvaluationConfigResponse)((Object)obj);
        return Objects.equals(this.onlineEvaluationConfigArn(), other.onlineEvaluationConfigArn()) && Objects.equals(this.onlineEvaluationConfigId(), other.onlineEvaluationConfigId()) && Objects.equals(this.statusAsString(), other.statusAsString());
    }

    public final String toString() {
        return ToString.builder((String)"DeleteOnlineEvaluationConfigResponse").add("OnlineEvaluationConfigArn", (Object)this.onlineEvaluationConfigArn()).add("OnlineEvaluationConfigId", (Object)this.onlineEvaluationConfigId()).add("Status", (Object)this.statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "onlineEvaluationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigArn()));
            }
            case "onlineEvaluationConfigId": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("onlineEvaluationConfigArn", ONLINE_EVALUATION_CONFIG_ARN_FIELD);
        map.put("onlineEvaluationConfigId", ONLINE_EVALUATION_CONFIG_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteOnlineEvaluationConfigResponse, T> g) {
        return obj -> g.apply((DeleteOnlineEvaluationConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String onlineEvaluationConfigArn;
        private String onlineEvaluationConfigId;
        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteOnlineEvaluationConfigResponse model) {
            super(model);
            this.onlineEvaluationConfigArn(model.onlineEvaluationConfigArn);
            this.onlineEvaluationConfigId(model.onlineEvaluationConfigId);
            this.status(model.status);
        }

        public final String getOnlineEvaluationConfigArn() {
            return this.onlineEvaluationConfigArn;
        }

        public final void setOnlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
        }

        @Override
        public final Builder onlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
            return this;
        }

        public final String getOnlineEvaluationConfigId() {
            return this.onlineEvaluationConfigId;
        }

        public final void setOnlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
        }

        @Override
        public final Builder onlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OnlineEvaluationConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public DeleteOnlineEvaluationConfigResponse build() {
            return new DeleteOnlineEvaluationConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DeleteOnlineEvaluationConfigResponse> {
        public Builder onlineEvaluationConfigArn(String var1);

        public Builder onlineEvaluationConfigId(String var1);

        public Builder status(String var1);

        public Builder status(OnlineEvaluationConfigStatus var1);
    }
}

