/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.CloudWatchLogsInputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DataSourceConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, DataSourceConfig> {
    private static final SdkField<CloudWatchLogsInputConfig> CLOUD_WATCH_LOGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("cloudWatchLogs").getter(DataSourceConfig.getter(DataSourceConfig::cloudWatchLogs)).setter(DataSourceConfig.setter(Builder::cloudWatchLogs)).constructor(CloudWatchLogsInputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cloudWatchLogs").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLOUD_WATCH_LOGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DataSourceConfig.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CloudWatchLogsInputConfig cloudWatchLogs;
    private final Type type;

    private DataSourceConfig(BuilderImpl builder) {
        this.cloudWatchLogs = builder.cloudWatchLogs;
        this.type = builder.type;
    }

    public final CloudWatchLogsInputConfig cloudWatchLogs() {
        return this.cloudWatchLogs;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.cloudWatchLogs());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DataSourceConfig)) {
            return false;
        }
        DataSourceConfig other = (DataSourceConfig)obj;
        return Objects.equals(this.cloudWatchLogs(), other.cloudWatchLogs());
    }

    public final String toString() {
        return ToString.builder((String)"DataSourceConfig").add("CloudWatchLogs", (Object)this.cloudWatchLogs()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "cloudWatchLogs": {
                return Optional.ofNullable(clazz.cast(this.cloudWatchLogs()));
            }
        }
        return Optional.empty();
    }

    public static DataSourceConfig fromCloudWatchLogs(CloudWatchLogsInputConfig cloudWatchLogs) {
        return (DataSourceConfig)DataSourceConfig.builder().cloudWatchLogs(cloudWatchLogs).build();
    }

    public static DataSourceConfig fromCloudWatchLogs(Consumer<CloudWatchLogsInputConfig.Builder> cloudWatchLogs) {
        CloudWatchLogsInputConfig.Builder builder = CloudWatchLogsInputConfig.builder();
        cloudWatchLogs.accept(builder);
        return DataSourceConfig.fromCloudWatchLogs((CloudWatchLogsInputConfig)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<CloudWatchLogsInputConfig>> map = new HashMap<String, SdkField<CloudWatchLogsInputConfig>>();
        map.put("cloudWatchLogs", CLOUD_WATCH_LOGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DataSourceConfig, T> g) {
        return obj -> g.apply((DataSourceConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CLOUD_WATCH_LOGS,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CloudWatchLogsInputConfig cloudWatchLogs;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(DataSourceConfig model) {
            this.cloudWatchLogs(model.cloudWatchLogs);
        }

        public final CloudWatchLogsInputConfig.Builder getCloudWatchLogs() {
            return this.cloudWatchLogs != null ? this.cloudWatchLogs.toBuilder() : null;
        }

        public final void setCloudWatchLogs(CloudWatchLogsInputConfig.BuilderImpl cloudWatchLogs) {
            CloudWatchLogsInputConfig oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs != null ? cloudWatchLogs.build() : null;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
        }

        @Override
        public final Builder cloudWatchLogs(CloudWatchLogsInputConfig cloudWatchLogs) {
            CloudWatchLogsInputConfig oldValue = this.cloudWatchLogs;
            this.cloudWatchLogs = cloudWatchLogs;
            this.handleUnionValueChange(Type.CLOUD_WATCH_LOGS, oldValue, this.cloudWatchLogs);
            return this;
        }

        public DataSourceConfig build() {
            return new DataSourceConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, DataSourceConfig> {
        public Builder cloudWatchLogs(CloudWatchLogsInputConfig var1);

        default public Builder cloudWatchLogs(Consumer<CloudWatchLogsInputConfig.Builder> cloudWatchLogs) {
            return this.cloudWatchLogs((CloudWatchLogsInputConfig)((CloudWatchLogsInputConfig.Builder)CloudWatchLogsInputConfig.builder().applyMutation(cloudWatchLogs)).build());
        }
    }
}

