/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RequiredPropertiesCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SchemaPropertiesCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.SchemaType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class SchemaDefinition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, SchemaDefinition> {
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(SchemaDefinition.getter(SchemaDefinition::typeAsString)).setter(SchemaDefinition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final SdkField<Map<String, SchemaDefinition>> PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("properties").getter(SchemaDefinition.getter(SchemaDefinition::properties)).setter(SchemaDefinition.setter(Builder::properties)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("properties").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(SchemaDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<List<String>> REQUIRED_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("required").getter(SchemaDefinition.getter(SchemaDefinition::required)).setter(SchemaDefinition.setter(Builder::required)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("required").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<SchemaDefinition> ITEMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("items").getter(SchemaDefinition.getter(SchemaDefinition::items)).setter(SchemaDefinition.setter(Builder::items)).constructor(SchemaDefinition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("items").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(SchemaDefinition.getter(SchemaDefinition::description)).setter(SchemaDefinition.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TYPE_FIELD, PROPERTIES_FIELD, REQUIRED_FIELD, ITEMS_FIELD, DESCRIPTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = SchemaDefinition.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String type;
    private final Map<String, SchemaDefinition> properties;
    private final List<String> required;
    private final SchemaDefinition items;
    private final String description;

    private SchemaDefinition(BuilderImpl builder) {
        this.type = builder.type;
        this.properties = builder.properties;
        this.required = builder.required;
        this.items = builder.items;
        this.description = builder.description;
    }

    public final SchemaType type() {
        return SchemaType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public final boolean hasProperties() {
        return this.properties != null && !(this.properties instanceof SdkAutoConstructMap);
    }

    public final Map<String, SchemaDefinition> properties() {
        return this.properties;
    }

    public final boolean hasRequired() {
        return this.required != null && !(this.required instanceof SdkAutoConstructList);
    }

    public final List<String> required() {
        return this.required;
    }

    public final SchemaDefinition items() {
        return this.items;
    }

    public final String description() {
        return this.description;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasProperties() ? this.properties() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasRequired() ? this.required() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.items());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SchemaDefinition)) {
            return false;
        }
        SchemaDefinition other = (SchemaDefinition)obj;
        return Objects.equals(this.typeAsString(), other.typeAsString()) && this.hasProperties() == other.hasProperties() && Objects.equals(this.properties(), other.properties()) && this.hasRequired() == other.hasRequired() && Objects.equals(this.required(), other.required()) && Objects.equals(this.items(), other.items()) && Objects.equals(this.description(), other.description());
    }

    public final String toString() {
        return ToString.builder((String)"SchemaDefinition").add("Type", (Object)this.typeAsString()).add("Properties", this.hasProperties() ? this.properties() : null).add("Required", this.hasRequired() ? this.required() : null).add("Items", (Object)this.items()).add("Description", (Object)this.description()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
            case "properties": {
                return Optional.ofNullable(clazz.cast(this.properties()));
            }
            case "required": {
                return Optional.ofNullable(clazz.cast(this.required()));
            }
            case "items": {
                return Optional.ofNullable(clazz.cast(this.items()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", TYPE_FIELD);
        map.put("properties", PROPERTIES_FIELD);
        map.put("required", REQUIRED_FIELD);
        map.put("items", ITEMS_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SchemaDefinition, T> g) {
        return obj -> g.apply((SchemaDefinition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String type;
        private Map<String, SchemaDefinition> properties = DefaultSdkAutoConstructMap.getInstance();
        private List<String> required = DefaultSdkAutoConstructList.getInstance();
        private SchemaDefinition items;
        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(SchemaDefinition model) {
            this.type(model.type);
            this.properties(model.properties);
            this.required(model.required);
            this.items(model.items);
            this.description(model.description);
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(SchemaType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public final Map<String, Builder> getProperties() {
            Map<String, Builder> result = SchemaPropertiesCopier.copyToBuilder(this.properties);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setProperties(Map<String, BuilderImpl> properties) {
            this.properties = SchemaPropertiesCopier.copyFromBuilder(properties);
        }

        @Override
        public final Builder properties(Map<String, SchemaDefinition> properties) {
            this.properties = SchemaPropertiesCopier.copy(properties);
            return this;
        }

        public final Collection<String> getRequired() {
            if (this.required instanceof SdkAutoConstructList) {
                return null;
            }
            return this.required;
        }

        public final void setRequired(Collection<String> required) {
            this.required = RequiredPropertiesCopier.copy(required);
        }

        @Override
        public final Builder required(Collection<String> required) {
            this.required = RequiredPropertiesCopier.copy(required);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder required(String ... required) {
            this.required(Arrays.asList(required));
            return this;
        }

        public final Builder getItems() {
            return this.items != null ? this.items.toBuilder() : null;
        }

        public final void setItems(BuilderImpl items) {
            this.items = items != null ? items.build() : null;
        }

        @Override
        public final Builder items(SchemaDefinition items) {
            this.items = items;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public SchemaDefinition build() {
            return new SchemaDefinition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, SchemaDefinition> {
        public Builder type(String var1);

        public Builder type(SchemaType var1);

        public Builder properties(Map<String, SchemaDefinition> var1);

        public Builder required(Collection<String> var1);

        public Builder required(String ... var1);

        public Builder items(SchemaDefinition var1);

        default public Builder items(Consumer<Builder> items) {
            return this.items((SchemaDefinition)((Builder)SchemaDefinition.builder().applyMutation(items)).build());
        }

        public Builder description(String var1);
    }
}

