/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialProviderItem;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialProvidersCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListApiKeyCredentialProvidersResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListApiKeyCredentialProvidersResponse> {
    private static final SdkField<List<ApiKeyCredentialProviderItem>> CREDENTIAL_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("credentialProviders").getter(ListApiKeyCredentialProvidersResponse.getter(ListApiKeyCredentialProvidersResponse::credentialProviders)).setter(ListApiKeyCredentialProvidersResponse.setter(Builder::credentialProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentialProviders").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ApiKeyCredentialProviderItem::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListApiKeyCredentialProvidersResponse.getter(ListApiKeyCredentialProvidersResponse::nextToken)).setter(ListApiKeyCredentialProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIAL_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListApiKeyCredentialProvidersResponse.memberNameToFieldInitializer();
    private final List<ApiKeyCredentialProviderItem> credentialProviders;
    private final String nextToken;

    private ListApiKeyCredentialProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.credentialProviders = builder.credentialProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasCredentialProviders() {
        return this.credentialProviders != null && !(this.credentialProviders instanceof SdkAutoConstructList);
    }

    public final List<ApiKeyCredentialProviderItem> credentialProviders() {
        return this.credentialProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCredentialProviders() ? this.credentialProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListApiKeyCredentialProvidersResponse)) {
            return false;
        }
        ListApiKeyCredentialProvidersResponse other = (ListApiKeyCredentialProvidersResponse)((Object)obj);
        return this.hasCredentialProviders() == other.hasCredentialProviders() && Objects.equals(this.credentialProviders(), other.credentialProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListApiKeyCredentialProvidersResponse").add("CredentialProviders", this.hasCredentialProviders() ? this.credentialProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "credentialProviders": {
                return Optional.ofNullable(clazz.cast(this.credentialProviders()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("credentialProviders", CREDENTIAL_PROVIDERS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListApiKeyCredentialProvidersResponse, T> g) {
        return obj -> g.apply((ListApiKeyCredentialProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<ApiKeyCredentialProviderItem> credentialProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListApiKeyCredentialProvidersResponse model) {
            super(model);
            this.credentialProviders(model.credentialProviders);
            this.nextToken(model.nextToken);
        }

        public final List<ApiKeyCredentialProviderItem.Builder> getCredentialProviders() {
            List<ApiKeyCredentialProviderItem.Builder> result = ApiKeyCredentialProvidersCopier.copyToBuilder(this.credentialProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCredentialProviders(Collection<ApiKeyCredentialProviderItem.BuilderImpl> credentialProviders) {
            this.credentialProviders = ApiKeyCredentialProvidersCopier.copyFromBuilder(credentialProviders);
        }

        @Override
        public final Builder credentialProviders(Collection<ApiKeyCredentialProviderItem> credentialProviders) {
            this.credentialProviders = ApiKeyCredentialProvidersCopier.copy(credentialProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviders(ApiKeyCredentialProviderItem ... credentialProviders) {
            this.credentialProviders(Arrays.asList(credentialProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder credentialProviders(Consumer<ApiKeyCredentialProviderItem.Builder> ... credentialProviders) {
            this.credentialProviders(Stream.of(credentialProviders).map(c -> (ApiKeyCredentialProviderItem)((ApiKeyCredentialProviderItem.Builder)ApiKeyCredentialProviderItem.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListApiKeyCredentialProvidersResponse build() {
            return new ListApiKeyCredentialProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListApiKeyCredentialProvidersResponse> {
        public Builder credentialProviders(Collection<ApiKeyCredentialProviderItem> var1);

        public Builder credentialProviders(ApiKeyCredentialProviderItem ... var1);

        public Builder credentialProviders(Consumer<ApiKeyCredentialProviderItem.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

