/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeArtifact;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AgentRuntimeStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.AuthorizerConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EnvironmentVariablesMapCopier;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.LifecycleConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.NetworkConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ProtocolConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.RequestHeaderConfiguration;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.WorkloadIdentityDetails;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetAgentRuntimeResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, GetAgentRuntimeResponse> {
    private static final SdkField<String> AGENT_RUNTIME_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeArn").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::agentRuntimeArn)).setter(GetAgentRuntimeResponse.setter(Builder::agentRuntimeArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArn").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeName").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::agentRuntimeName)).setter(GetAgentRuntimeResponse.setter(Builder::agentRuntimeName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeName").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeId").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::agentRuntimeId)).setter(GetAgentRuntimeResponse.setter(Builder::agentRuntimeId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeId").build()}).build();
    private static final SdkField<String> AGENT_RUNTIME_VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("agentRuntimeVersion").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::agentRuntimeVersion)).setter(GetAgentRuntimeResponse.setter(Builder::agentRuntimeVersion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeVersion").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::createdAt)).setter(GetAgentRuntimeResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<Instant> LAST_UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("lastUpdatedAt").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::lastUpdatedAt)).setter(GetAgentRuntimeResponse.setter(Builder::lastUpdatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lastUpdatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> ROLE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("roleArn").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::roleArn)).setter(GetAgentRuntimeResponse.setter(Builder::roleArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("roleArn").build()}).build();
    private static final SdkField<NetworkConfiguration> NETWORK_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("networkConfiguration").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::networkConfiguration)).setter(GetAgentRuntimeResponse.setter(Builder::networkConfiguration)).constructor(NetworkConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("networkConfiguration").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::statusAsString)).setter(GetAgentRuntimeResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<LifecycleConfiguration> LIFECYCLE_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("lifecycleConfiguration").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::lifecycleConfiguration)).setter(GetAgentRuntimeResponse.setter(Builder::lifecycleConfiguration)).constructor(LifecycleConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleConfiguration").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::failureReason)).setter(GetAgentRuntimeResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::description)).setter(GetAgentRuntimeResponse.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<WorkloadIdentityDetails> WORKLOAD_IDENTITY_DETAILS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workloadIdentityDetails").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::workloadIdentityDetails)).setter(GetAgentRuntimeResponse.setter(Builder::workloadIdentityDetails)).constructor(WorkloadIdentityDetails::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workloadIdentityDetails").build()}).build();
    private static final SdkField<AgentRuntimeArtifact> AGENT_RUNTIME_ARTIFACT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("agentRuntimeArtifact").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::agentRuntimeArtifact)).setter(GetAgentRuntimeResponse.setter(Builder::agentRuntimeArtifact)).constructor(AgentRuntimeArtifact::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("agentRuntimeArtifact").build()}).build();
    private static final SdkField<ProtocolConfiguration> PROTOCOL_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("protocolConfiguration").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::protocolConfiguration)).setter(GetAgentRuntimeResponse.setter(Builder::protocolConfiguration)).constructor(ProtocolConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("protocolConfiguration").build()}).build();
    private static final SdkField<Map<String, String>> ENVIRONMENT_VARIABLES_FIELD = SdkField.builder((MarshallingType)MarshallingType.MAP).memberName("environmentVariables").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::environmentVariables)).setter(GetAgentRuntimeResponse.setter(Builder::environmentVariables)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("environmentVariables").build(), MapTrait.builder().keyLocationName("key").valueLocationName("value").valueFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("value").build()}).build()).build()}).build();
    private static final SdkField<AuthorizerConfiguration> AUTHORIZER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("authorizerConfiguration").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::authorizerConfiguration)).setter(GetAgentRuntimeResponse.setter(Builder::authorizerConfiguration)).constructor(AuthorizerConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("authorizerConfiguration").build()}).build();
    private static final SdkField<RequestHeaderConfiguration> REQUEST_HEADER_CONFIGURATION_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("requestHeaderConfiguration").getter(GetAgentRuntimeResponse.getter(GetAgentRuntimeResponse::requestHeaderConfiguration)).setter(GetAgentRuntimeResponse.setter(Builder::requestHeaderConfiguration)).constructor(RequestHeaderConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("requestHeaderConfiguration").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AGENT_RUNTIME_ARN_FIELD, AGENT_RUNTIME_NAME_FIELD, AGENT_RUNTIME_ID_FIELD, AGENT_RUNTIME_VERSION_FIELD, CREATED_AT_FIELD, LAST_UPDATED_AT_FIELD, ROLE_ARN_FIELD, NETWORK_CONFIGURATION_FIELD, STATUS_FIELD, LIFECYCLE_CONFIGURATION_FIELD, FAILURE_REASON_FIELD, DESCRIPTION_FIELD, WORKLOAD_IDENTITY_DETAILS_FIELD, AGENT_RUNTIME_ARTIFACT_FIELD, PROTOCOL_CONFIGURATION_FIELD, ENVIRONMENT_VARIABLES_FIELD, AUTHORIZER_CONFIGURATION_FIELD, REQUEST_HEADER_CONFIGURATION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetAgentRuntimeResponse.memberNameToFieldInitializer();
    private final String agentRuntimeArn;
    private final String agentRuntimeName;
    private final String agentRuntimeId;
    private final String agentRuntimeVersion;
    private final Instant createdAt;
    private final Instant lastUpdatedAt;
    private final String roleArn;
    private final NetworkConfiguration networkConfiguration;
    private final String status;
    private final LifecycleConfiguration lifecycleConfiguration;
    private final String failureReason;
    private final String description;
    private final WorkloadIdentityDetails workloadIdentityDetails;
    private final AgentRuntimeArtifact agentRuntimeArtifact;
    private final ProtocolConfiguration protocolConfiguration;
    private final Map<String, String> environmentVariables;
    private final AuthorizerConfiguration authorizerConfiguration;
    private final RequestHeaderConfiguration requestHeaderConfiguration;

    private GetAgentRuntimeResponse(BuilderImpl builder) {
        super(builder);
        this.agentRuntimeArn = builder.agentRuntimeArn;
        this.agentRuntimeName = builder.agentRuntimeName;
        this.agentRuntimeId = builder.agentRuntimeId;
        this.agentRuntimeVersion = builder.agentRuntimeVersion;
        this.createdAt = builder.createdAt;
        this.lastUpdatedAt = builder.lastUpdatedAt;
        this.roleArn = builder.roleArn;
        this.networkConfiguration = builder.networkConfiguration;
        this.status = builder.status;
        this.lifecycleConfiguration = builder.lifecycleConfiguration;
        this.failureReason = builder.failureReason;
        this.description = builder.description;
        this.workloadIdentityDetails = builder.workloadIdentityDetails;
        this.agentRuntimeArtifact = builder.agentRuntimeArtifact;
        this.protocolConfiguration = builder.protocolConfiguration;
        this.environmentVariables = builder.environmentVariables;
        this.authorizerConfiguration = builder.authorizerConfiguration;
        this.requestHeaderConfiguration = builder.requestHeaderConfiguration;
    }

    public final String agentRuntimeArn() {
        return this.agentRuntimeArn;
    }

    public final String agentRuntimeName() {
        return this.agentRuntimeName;
    }

    public final String agentRuntimeId() {
        return this.agentRuntimeId;
    }

    public final String agentRuntimeVersion() {
        return this.agentRuntimeVersion;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final Instant lastUpdatedAt() {
        return this.lastUpdatedAt;
    }

    public final String roleArn() {
        return this.roleArn;
    }

    public final NetworkConfiguration networkConfiguration() {
        return this.networkConfiguration;
    }

    public final AgentRuntimeStatus status() {
        return AgentRuntimeStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final LifecycleConfiguration lifecycleConfiguration() {
        return this.lifecycleConfiguration;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public final String description() {
        return this.description;
    }

    public final WorkloadIdentityDetails workloadIdentityDetails() {
        return this.workloadIdentityDetails;
    }

    public final AgentRuntimeArtifact agentRuntimeArtifact() {
        return this.agentRuntimeArtifact;
    }

    public final ProtocolConfiguration protocolConfiguration() {
        return this.protocolConfiguration;
    }

    public final boolean hasEnvironmentVariables() {
        return this.environmentVariables != null && !(this.environmentVariables instanceof SdkAutoConstructMap);
    }

    public final Map<String, String> environmentVariables() {
        return this.environmentVariables;
    }

    public final AuthorizerConfiguration authorizerConfiguration() {
        return this.authorizerConfiguration;
    }

    public final RequestHeaderConfiguration requestHeaderConfiguration() {
        return this.requestHeaderConfiguration;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeName());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeId());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeVersion());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.lastUpdatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.roleArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.workloadIdentityDetails());
        hashCode = 31 * hashCode + Objects.hashCode(this.agentRuntimeArtifact());
        hashCode = 31 * hashCode + Objects.hashCode(this.protocolConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEnvironmentVariables() ? this.environmentVariables() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.authorizerConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(this.requestHeaderConfiguration());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetAgentRuntimeResponse)) {
            return false;
        }
        GetAgentRuntimeResponse other = (GetAgentRuntimeResponse)((Object)obj);
        return Objects.equals(this.agentRuntimeArn(), other.agentRuntimeArn()) && Objects.equals(this.agentRuntimeName(), other.agentRuntimeName()) && Objects.equals(this.agentRuntimeId(), other.agentRuntimeId()) && Objects.equals(this.agentRuntimeVersion(), other.agentRuntimeVersion()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.lastUpdatedAt(), other.lastUpdatedAt()) && Objects.equals(this.roleArn(), other.roleArn()) && Objects.equals(this.networkConfiguration(), other.networkConfiguration()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.lifecycleConfiguration(), other.lifecycleConfiguration()) && Objects.equals(this.failureReason(), other.failureReason()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.workloadIdentityDetails(), other.workloadIdentityDetails()) && Objects.equals(this.agentRuntimeArtifact(), other.agentRuntimeArtifact()) && Objects.equals(this.protocolConfiguration(), other.protocolConfiguration()) && this.hasEnvironmentVariables() == other.hasEnvironmentVariables() && Objects.equals(this.environmentVariables(), other.environmentVariables()) && Objects.equals(this.authorizerConfiguration(), other.authorizerConfiguration()) && Objects.equals(this.requestHeaderConfiguration(), other.requestHeaderConfiguration());
    }

    public final String toString() {
        return ToString.builder((String)"GetAgentRuntimeResponse").add("AgentRuntimeArn", (Object)this.agentRuntimeArn()).add("AgentRuntimeName", (Object)this.agentRuntimeName()).add("AgentRuntimeId", (Object)this.agentRuntimeId()).add("AgentRuntimeVersion", (Object)this.agentRuntimeVersion()).add("CreatedAt", (Object)this.createdAt()).add("LastUpdatedAt", (Object)this.lastUpdatedAt()).add("RoleArn", (Object)this.roleArn()).add("NetworkConfiguration", (Object)this.networkConfiguration()).add("Status", (Object)this.statusAsString()).add("LifecycleConfiguration", (Object)this.lifecycleConfiguration()).add("FailureReason", (Object)this.failureReason()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("WorkloadIdentityDetails", (Object)this.workloadIdentityDetails()).add("AgentRuntimeArtifact", (Object)this.agentRuntimeArtifact()).add("ProtocolConfiguration", (Object)this.protocolConfiguration()).add("EnvironmentVariables", (Object)(this.environmentVariables() == null ? null : "*** Sensitive Data Redacted ***")).add("AuthorizerConfiguration", (Object)this.authorizerConfiguration()).add("RequestHeaderConfiguration", (Object)this.requestHeaderConfiguration()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "agentRuntimeArn": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArn()));
            }
            case "agentRuntimeName": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeName()));
            }
            case "agentRuntimeId": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeId()));
            }
            case "agentRuntimeVersion": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeVersion()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "lastUpdatedAt": {
                return Optional.ofNullable(clazz.cast(this.lastUpdatedAt()));
            }
            case "roleArn": {
                return Optional.ofNullable(clazz.cast(this.roleArn()));
            }
            case "networkConfiguration": {
                return Optional.ofNullable(clazz.cast(this.networkConfiguration()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "lifecycleConfiguration": {
                return Optional.ofNullable(clazz.cast(this.lifecycleConfiguration()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "workloadIdentityDetails": {
                return Optional.ofNullable(clazz.cast(this.workloadIdentityDetails()));
            }
            case "agentRuntimeArtifact": {
                return Optional.ofNullable(clazz.cast(this.agentRuntimeArtifact()));
            }
            case "protocolConfiguration": {
                return Optional.ofNullable(clazz.cast(this.protocolConfiguration()));
            }
            case "environmentVariables": {
                return Optional.ofNullable(clazz.cast(this.environmentVariables()));
            }
            case "authorizerConfiguration": {
                return Optional.ofNullable(clazz.cast(this.authorizerConfiguration()));
            }
            case "requestHeaderConfiguration": {
                return Optional.ofNullable(clazz.cast(this.requestHeaderConfiguration()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("agentRuntimeArn", AGENT_RUNTIME_ARN_FIELD);
        map.put("agentRuntimeName", AGENT_RUNTIME_NAME_FIELD);
        map.put("agentRuntimeId", AGENT_RUNTIME_ID_FIELD);
        map.put("agentRuntimeVersion", AGENT_RUNTIME_VERSION_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("lastUpdatedAt", LAST_UPDATED_AT_FIELD);
        map.put("roleArn", ROLE_ARN_FIELD);
        map.put("networkConfiguration", NETWORK_CONFIGURATION_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("lifecycleConfiguration", LIFECYCLE_CONFIGURATION_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("workloadIdentityDetails", WORKLOAD_IDENTITY_DETAILS_FIELD);
        map.put("agentRuntimeArtifact", AGENT_RUNTIME_ARTIFACT_FIELD);
        map.put("protocolConfiguration", PROTOCOL_CONFIGURATION_FIELD);
        map.put("environmentVariables", ENVIRONMENT_VARIABLES_FIELD);
        map.put("authorizerConfiguration", AUTHORIZER_CONFIGURATION_FIELD);
        map.put("requestHeaderConfiguration", REQUEST_HEADER_CONFIGURATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetAgentRuntimeResponse, T> g) {
        return obj -> g.apply((GetAgentRuntimeResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String agentRuntimeArn;
        private String agentRuntimeName;
        private String agentRuntimeId;
        private String agentRuntimeVersion;
        private Instant createdAt;
        private Instant lastUpdatedAt;
        private String roleArn;
        private NetworkConfiguration networkConfiguration;
        private String status;
        private LifecycleConfiguration lifecycleConfiguration;
        private String failureReason;
        private String description;
        private WorkloadIdentityDetails workloadIdentityDetails;
        private AgentRuntimeArtifact agentRuntimeArtifact;
        private ProtocolConfiguration protocolConfiguration;
        private Map<String, String> environmentVariables = DefaultSdkAutoConstructMap.getInstance();
        private AuthorizerConfiguration authorizerConfiguration;
        private RequestHeaderConfiguration requestHeaderConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(GetAgentRuntimeResponse model) {
            super(model);
            this.agentRuntimeArn(model.agentRuntimeArn);
            this.agentRuntimeName(model.agentRuntimeName);
            this.agentRuntimeId(model.agentRuntimeId);
            this.agentRuntimeVersion(model.agentRuntimeVersion);
            this.createdAt(model.createdAt);
            this.lastUpdatedAt(model.lastUpdatedAt);
            this.roleArn(model.roleArn);
            this.networkConfiguration(model.networkConfiguration);
            this.status(model.status);
            this.lifecycleConfiguration(model.lifecycleConfiguration);
            this.failureReason(model.failureReason);
            this.description(model.description);
            this.workloadIdentityDetails(model.workloadIdentityDetails);
            this.agentRuntimeArtifact(model.agentRuntimeArtifact);
            this.protocolConfiguration(model.protocolConfiguration);
            this.environmentVariables(model.environmentVariables);
            this.authorizerConfiguration(model.authorizerConfiguration);
            this.requestHeaderConfiguration(model.requestHeaderConfiguration);
        }

        public final String getAgentRuntimeArn() {
            return this.agentRuntimeArn;
        }

        public final void setAgentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
        }

        @Override
        public final Builder agentRuntimeArn(String agentRuntimeArn) {
            this.agentRuntimeArn = agentRuntimeArn;
            return this;
        }

        public final String getAgentRuntimeName() {
            return this.agentRuntimeName;
        }

        public final void setAgentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
        }

        @Override
        public final Builder agentRuntimeName(String agentRuntimeName) {
            this.agentRuntimeName = agentRuntimeName;
            return this;
        }

        public final String getAgentRuntimeId() {
            return this.agentRuntimeId;
        }

        public final void setAgentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
        }

        @Override
        public final Builder agentRuntimeId(String agentRuntimeId) {
            this.agentRuntimeId = agentRuntimeId;
            return this;
        }

        public final String getAgentRuntimeVersion() {
            return this.agentRuntimeVersion;
        }

        public final void setAgentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
        }

        @Override
        public final Builder agentRuntimeVersion(String agentRuntimeVersion) {
            this.agentRuntimeVersion = agentRuntimeVersion;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getLastUpdatedAt() {
            return this.lastUpdatedAt;
        }

        public final void setLastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
        }

        @Override
        public final Builder lastUpdatedAt(Instant lastUpdatedAt) {
            this.lastUpdatedAt = lastUpdatedAt;
            return this;
        }

        public final String getRoleArn() {
            return this.roleArn;
        }

        public final void setRoleArn(String roleArn) {
            this.roleArn = roleArn;
        }

        @Override
        public final Builder roleArn(String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        public final NetworkConfiguration.Builder getNetworkConfiguration() {
            return this.networkConfiguration != null ? this.networkConfiguration.toBuilder() : null;
        }

        public final void setNetworkConfiguration(NetworkConfiguration.BuilderImpl networkConfiguration) {
            this.networkConfiguration = networkConfiguration != null ? networkConfiguration.build() : null;
        }

        @Override
        public final Builder networkConfiguration(NetworkConfiguration networkConfiguration) {
            this.networkConfiguration = networkConfiguration;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(AgentRuntimeStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final LifecycleConfiguration.Builder getLifecycleConfiguration() {
            return this.lifecycleConfiguration != null ? this.lifecycleConfiguration.toBuilder() : null;
        }

        public final void setLifecycleConfiguration(LifecycleConfiguration.BuilderImpl lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration != null ? lifecycleConfiguration.build() : null;
        }

        @Override
        public final Builder lifecycleConfiguration(LifecycleConfiguration lifecycleConfiguration) {
            this.lifecycleConfiguration = lifecycleConfiguration;
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final WorkloadIdentityDetails.Builder getWorkloadIdentityDetails() {
            return this.workloadIdentityDetails != null ? this.workloadIdentityDetails.toBuilder() : null;
        }

        public final void setWorkloadIdentityDetails(WorkloadIdentityDetails.BuilderImpl workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails != null ? workloadIdentityDetails.build() : null;
        }

        @Override
        public final Builder workloadIdentityDetails(WorkloadIdentityDetails workloadIdentityDetails) {
            this.workloadIdentityDetails = workloadIdentityDetails;
            return this;
        }

        public final AgentRuntimeArtifact.Builder getAgentRuntimeArtifact() {
            return this.agentRuntimeArtifact != null ? this.agentRuntimeArtifact.toBuilder() : null;
        }

        public final void setAgentRuntimeArtifact(AgentRuntimeArtifact.BuilderImpl agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact != null ? agentRuntimeArtifact.build() : null;
        }

        @Override
        public final Builder agentRuntimeArtifact(AgentRuntimeArtifact agentRuntimeArtifact) {
            this.agentRuntimeArtifact = agentRuntimeArtifact;
            return this;
        }

        public final ProtocolConfiguration.Builder getProtocolConfiguration() {
            return this.protocolConfiguration != null ? this.protocolConfiguration.toBuilder() : null;
        }

        public final void setProtocolConfiguration(ProtocolConfiguration.BuilderImpl protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration != null ? protocolConfiguration.build() : null;
        }

        @Override
        public final Builder protocolConfiguration(ProtocolConfiguration protocolConfiguration) {
            this.protocolConfiguration = protocolConfiguration;
            return this;
        }

        public final Map<String, String> getEnvironmentVariables() {
            if (this.environmentVariables instanceof SdkAutoConstructMap) {
                return null;
            }
            return this.environmentVariables;
        }

        public final void setEnvironmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
        }

        @Override
        public final Builder environmentVariables(Map<String, String> environmentVariables) {
            this.environmentVariables = EnvironmentVariablesMapCopier.copy(environmentVariables);
            return this;
        }

        public final AuthorizerConfiguration.Builder getAuthorizerConfiguration() {
            return this.authorizerConfiguration != null ? this.authorizerConfiguration.toBuilder() : null;
        }

        public final void setAuthorizerConfiguration(AuthorizerConfiguration.BuilderImpl authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration != null ? authorizerConfiguration.build() : null;
        }

        @Override
        public final Builder authorizerConfiguration(AuthorizerConfiguration authorizerConfiguration) {
            this.authorizerConfiguration = authorizerConfiguration;
            return this;
        }

        public final RequestHeaderConfiguration.Builder getRequestHeaderConfiguration() {
            return this.requestHeaderConfiguration != null ? this.requestHeaderConfiguration.toBuilder() : null;
        }

        public final void setRequestHeaderConfiguration(RequestHeaderConfiguration.BuilderImpl requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration != null ? requestHeaderConfiguration.build() : null;
        }

        @Override
        public final Builder requestHeaderConfiguration(RequestHeaderConfiguration requestHeaderConfiguration) {
            this.requestHeaderConfiguration = requestHeaderConfiguration;
            return this;
        }

        @Override
        public GetAgentRuntimeResponse build() {
            return new GetAgentRuntimeResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetAgentRuntimeResponse> {
        public Builder agentRuntimeArn(String var1);

        public Builder agentRuntimeName(String var1);

        public Builder agentRuntimeId(String var1);

        public Builder agentRuntimeVersion(String var1);

        public Builder createdAt(Instant var1);

        public Builder lastUpdatedAt(Instant var1);

        public Builder roleArn(String var1);

        public Builder networkConfiguration(NetworkConfiguration var1);

        default public Builder networkConfiguration(Consumer<NetworkConfiguration.Builder> networkConfiguration) {
            return this.networkConfiguration((NetworkConfiguration)((NetworkConfiguration.Builder)NetworkConfiguration.builder().applyMutation(networkConfiguration)).build());
        }

        public Builder status(String var1);

        public Builder status(AgentRuntimeStatus var1);

        public Builder lifecycleConfiguration(LifecycleConfiguration var1);

        default public Builder lifecycleConfiguration(Consumer<LifecycleConfiguration.Builder> lifecycleConfiguration) {
            return this.lifecycleConfiguration((LifecycleConfiguration)((LifecycleConfiguration.Builder)LifecycleConfiguration.builder().applyMutation(lifecycleConfiguration)).build());
        }

        public Builder failureReason(String var1);

        public Builder description(String var1);

        public Builder workloadIdentityDetails(WorkloadIdentityDetails var1);

        default public Builder workloadIdentityDetails(Consumer<WorkloadIdentityDetails.Builder> workloadIdentityDetails) {
            return this.workloadIdentityDetails((WorkloadIdentityDetails)((WorkloadIdentityDetails.Builder)WorkloadIdentityDetails.builder().applyMutation(workloadIdentityDetails)).build());
        }

        public Builder agentRuntimeArtifact(AgentRuntimeArtifact var1);

        default public Builder agentRuntimeArtifact(Consumer<AgentRuntimeArtifact.Builder> agentRuntimeArtifact) {
            return this.agentRuntimeArtifact((AgentRuntimeArtifact)((AgentRuntimeArtifact.Builder)AgentRuntimeArtifact.builder().applyMutation(agentRuntimeArtifact)).build());
        }

        public Builder protocolConfiguration(ProtocolConfiguration var1);

        default public Builder protocolConfiguration(Consumer<ProtocolConfiguration.Builder> protocolConfiguration) {
            return this.protocolConfiguration((ProtocolConfiguration)((ProtocolConfiguration.Builder)ProtocolConfiguration.builder().applyMutation(protocolConfiguration)).build());
        }

        public Builder environmentVariables(Map<String, String> var1);

        public Builder authorizerConfiguration(AuthorizerConfiguration var1);

        default public Builder authorizerConfiguration(Consumer<AuthorizerConfiguration.Builder> authorizerConfiguration) {
            return this.authorizerConfiguration((AuthorizerConfiguration)((AuthorizerConfiguration.Builder)AuthorizerConfiguration.builder().applyMutation(authorizerConfiguration)).build());
        }

        public Builder requestHeaderConfiguration(RequestHeaderConfiguration var1);

        default public Builder requestHeaderConfiguration(Consumer<RequestHeaderConfiguration.Builder> requestHeaderConfiguration) {
            return this.requestHeaderConfiguration((RequestHeaderConfiguration)((RequestHeaderConfiguration.Builder)RequestHeaderConfiguration.builder().applyMutation(requestHeaderConfiguration)).build());
        }
    }
}

