/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationExecutionStatus;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OutputConfig;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateOnlineEvaluationConfigResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, CreateOnlineEvaluationConfigResponse> {
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigArn").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::onlineEvaluationConfigArn)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigArn").build()}).build();
    private static final SdkField<String> ONLINE_EVALUATION_CONFIG_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("onlineEvaluationConfigId").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::onlineEvaluationConfigId)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::onlineEvaluationConfigId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("onlineEvaluationConfigId").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::createdAt)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build()}).build();
    private static final SdkField<OutputConfig> OUTPUT_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("outputConfig").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::outputConfig)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::outputConfig)).constructor(OutputConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputConfig").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::statusAsString)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<String> EXECUTION_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionStatus").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::executionStatusAsString)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::executionStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionStatus").build()}).build();
    private static final SdkField<String> FAILURE_REASON_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("failureReason").getter(CreateOnlineEvaluationConfigResponse.getter(CreateOnlineEvaluationConfigResponse::failureReason)).setter(CreateOnlineEvaluationConfigResponse.setter(Builder::failureReason)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("failureReason").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ONLINE_EVALUATION_CONFIG_ARN_FIELD, ONLINE_EVALUATION_CONFIG_ID_FIELD, CREATED_AT_FIELD, OUTPUT_CONFIG_FIELD, STATUS_FIELD, EXECUTION_STATUS_FIELD, FAILURE_REASON_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateOnlineEvaluationConfigResponse.memberNameToFieldInitializer();
    private final String onlineEvaluationConfigArn;
    private final String onlineEvaluationConfigId;
    private final Instant createdAt;
    private final OutputConfig outputConfig;
    private final String status;
    private final String executionStatus;
    private final String failureReason;

    private CreateOnlineEvaluationConfigResponse(BuilderImpl builder) {
        super(builder);
        this.onlineEvaluationConfigArn = builder.onlineEvaluationConfigArn;
        this.onlineEvaluationConfigId = builder.onlineEvaluationConfigId;
        this.createdAt = builder.createdAt;
        this.outputConfig = builder.outputConfig;
        this.status = builder.status;
        this.executionStatus = builder.executionStatus;
        this.failureReason = builder.failureReason;
    }

    public final String onlineEvaluationConfigArn() {
        return this.onlineEvaluationConfigArn;
    }

    public final String onlineEvaluationConfigId() {
        return this.onlineEvaluationConfigId;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final OutputConfig outputConfig() {
        return this.outputConfig;
    }

    public final OnlineEvaluationConfigStatus status() {
        return OnlineEvaluationConfigStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final OnlineEvaluationExecutionStatus executionStatus() {
        return OnlineEvaluationExecutionStatus.fromValue(this.executionStatus);
    }

    public final String executionStatusAsString() {
        return this.executionStatus;
    }

    public final String failureReason() {
        return this.failureReason;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.onlineEvaluationConfigId());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.outputConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.failureReason());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateOnlineEvaluationConfigResponse)) {
            return false;
        }
        CreateOnlineEvaluationConfigResponse other = (CreateOnlineEvaluationConfigResponse)((Object)obj);
        return Objects.equals(this.onlineEvaluationConfigArn(), other.onlineEvaluationConfigArn()) && Objects.equals(this.onlineEvaluationConfigId(), other.onlineEvaluationConfigId()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.outputConfig(), other.outputConfig()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.executionStatusAsString(), other.executionStatusAsString()) && Objects.equals(this.failureReason(), other.failureReason());
    }

    public final String toString() {
        return ToString.builder((String)"CreateOnlineEvaluationConfigResponse").add("OnlineEvaluationConfigArn", (Object)this.onlineEvaluationConfigArn()).add("OnlineEvaluationConfigId", (Object)this.onlineEvaluationConfigId()).add("CreatedAt", (Object)this.createdAt()).add("OutputConfig", (Object)this.outputConfig()).add("Status", (Object)this.statusAsString()).add("ExecutionStatus", (Object)this.executionStatusAsString()).add("FailureReason", (Object)this.failureReason()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "onlineEvaluationConfigArn": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigArn()));
            }
            case "onlineEvaluationConfigId": {
                return Optional.ofNullable(clazz.cast(this.onlineEvaluationConfigId()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "outputConfig": {
                return Optional.ofNullable(clazz.cast(this.outputConfig()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "executionStatus": {
                return Optional.ofNullable(clazz.cast(this.executionStatusAsString()));
            }
            case "failureReason": {
                return Optional.ofNullable(clazz.cast(this.failureReason()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("onlineEvaluationConfigArn", ONLINE_EVALUATION_CONFIG_ARN_FIELD);
        map.put("onlineEvaluationConfigId", ONLINE_EVALUATION_CONFIG_ID_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("outputConfig", OUTPUT_CONFIG_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("executionStatus", EXECUTION_STATUS_FIELD);
        map.put("failureReason", FAILURE_REASON_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateOnlineEvaluationConfigResponse, T> g) {
        return obj -> g.apply((CreateOnlineEvaluationConfigResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private String onlineEvaluationConfigArn;
        private String onlineEvaluationConfigId;
        private Instant createdAt;
        private OutputConfig outputConfig;
        private String status;
        private String executionStatus;
        private String failureReason;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateOnlineEvaluationConfigResponse model) {
            super(model);
            this.onlineEvaluationConfigArn(model.onlineEvaluationConfigArn);
            this.onlineEvaluationConfigId(model.onlineEvaluationConfigId);
            this.createdAt(model.createdAt);
            this.outputConfig(model.outputConfig);
            this.status(model.status);
            this.executionStatus(model.executionStatus);
            this.failureReason(model.failureReason);
        }

        public final String getOnlineEvaluationConfigArn() {
            return this.onlineEvaluationConfigArn;
        }

        public final void setOnlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
        }

        @Override
        public final Builder onlineEvaluationConfigArn(String onlineEvaluationConfigArn) {
            this.onlineEvaluationConfigArn = onlineEvaluationConfigArn;
            return this;
        }

        public final String getOnlineEvaluationConfigId() {
            return this.onlineEvaluationConfigId;
        }

        public final void setOnlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
        }

        @Override
        public final Builder onlineEvaluationConfigId(String onlineEvaluationConfigId) {
            this.onlineEvaluationConfigId = onlineEvaluationConfigId;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final OutputConfig.Builder getOutputConfig() {
            return this.outputConfig != null ? this.outputConfig.toBuilder() : null;
        }

        public final void setOutputConfig(OutputConfig.BuilderImpl outputConfig) {
            this.outputConfig = outputConfig != null ? outputConfig.build() : null;
        }

        @Override
        public final Builder outputConfig(OutputConfig outputConfig) {
            this.outputConfig = outputConfig;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(OnlineEvaluationConfigStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getExecutionStatus() {
            return this.executionStatus;
        }

        public final void setExecutionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
        }

        @Override
        public final Builder executionStatus(String executionStatus) {
            this.executionStatus = executionStatus;
            return this;
        }

        @Override
        public final Builder executionStatus(OnlineEvaluationExecutionStatus executionStatus) {
            this.executionStatus(executionStatus == null ? null : executionStatus.toString());
            return this;
        }

        public final String getFailureReason() {
            return this.failureReason;
        }

        public final void setFailureReason(String failureReason) {
            this.failureReason = failureReason;
        }

        @Override
        public final Builder failureReason(String failureReason) {
            this.failureReason = failureReason;
            return this;
        }

        @Override
        public CreateOnlineEvaluationConfigResponse build() {
            return new CreateOnlineEvaluationConfigResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateOnlineEvaluationConfigResponse> {
        public Builder onlineEvaluationConfigArn(String var1);

        public Builder onlineEvaluationConfigId(String var1);

        public Builder createdAt(Instant var1);

        public Builder outputConfig(OutputConfig var1);

        default public Builder outputConfig(Consumer<OutputConfig.Builder> outputConfig) {
            return this.outputConfig((OutputConfig)((OutputConfig.Builder)OutputConfig.builder().applyMutation(outputConfig)).build());
        }

        public Builder status(String var1);

        public Builder status(OnlineEvaluationConfigStatus var1);

        public Builder executionStatus(String var1);

        public Builder executionStatus(OnlineEvaluationExecutionStatus var1);

        public Builder failureReason(String var1);
    }
}

