/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorSummary;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorSummaryListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListEvaluatorsResponse
extends BedrockAgentCoreControlResponse
implements ToCopyableBuilder<Builder, ListEvaluatorsResponse> {
    private static final SdkField<List<EvaluatorSummary>> EVALUATORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("evaluators").getter(ListEvaluatorsResponse.getter(ListEvaluatorsResponse::evaluators)).setter(ListEvaluatorsResponse.setter(Builder::evaluators)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluators").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(EvaluatorSummary::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListEvaluatorsResponse.getter(ListEvaluatorsResponse::nextToken)).setter(ListEvaluatorsResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(EVALUATORS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListEvaluatorsResponse.memberNameToFieldInitializer();
    private final List<EvaluatorSummary> evaluators;
    private final String nextToken;

    private ListEvaluatorsResponse(BuilderImpl builder) {
        super(builder);
        this.evaluators = builder.evaluators;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasEvaluators() {
        return this.evaluators != null && !(this.evaluators instanceof SdkAutoConstructList);
    }

    public final List<EvaluatorSummary> evaluators() {
        return this.evaluators;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasEvaluators() ? this.evaluators() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListEvaluatorsResponse)) {
            return false;
        }
        ListEvaluatorsResponse other = (ListEvaluatorsResponse)((Object)obj);
        return this.hasEvaluators() == other.hasEvaluators() && Objects.equals(this.evaluators(), other.evaluators()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListEvaluatorsResponse").add("Evaluators", this.hasEvaluators() ? this.evaluators() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "evaluators": {
                return Optional.ofNullable(clazz.cast(this.evaluators()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("evaluators", EVALUATORS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListEvaluatorsResponse, T> g) {
        return obj -> g.apply((ListEvaluatorsResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlResponse.BuilderImpl
    implements Builder {
        private List<EvaluatorSummary> evaluators = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListEvaluatorsResponse model) {
            super(model);
            this.evaluators(model.evaluators);
            this.nextToken(model.nextToken);
        }

        public final List<EvaluatorSummary.Builder> getEvaluators() {
            List<EvaluatorSummary.Builder> result = EvaluatorSummaryListCopier.copyToBuilder(this.evaluators);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setEvaluators(Collection<EvaluatorSummary.BuilderImpl> evaluators) {
            this.evaluators = EvaluatorSummaryListCopier.copyFromBuilder(evaluators);
        }

        @Override
        public final Builder evaluators(Collection<EvaluatorSummary> evaluators) {
            this.evaluators = EvaluatorSummaryListCopier.copy(evaluators);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(EvaluatorSummary ... evaluators) {
            this.evaluators(Arrays.asList(evaluators));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder evaluators(Consumer<EvaluatorSummary.Builder> ... evaluators) {
            this.evaluators(Stream.of(evaluators).map(c -> (EvaluatorSummary)((EvaluatorSummary.Builder)EvaluatorSummary.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListEvaluatorsResponse build() {
            return new ListEvaluatorsResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListEvaluatorsResponse> {
        public Builder evaluators(Collection<EvaluatorSummary> var1);

        public Builder evaluators(EvaluatorSummary ... var1);

        public Builder evaluators(Consumer<EvaluatorSummary.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

