/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ApiKeyCredentialProviderItem;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListApiKeyCredentialProvidersResponse;

public class ListApiKeyCredentialProvidersPublisher
implements SdkPublisher<ListApiKeyCredentialProvidersResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListApiKeyCredentialProvidersRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListApiKeyCredentialProvidersPublisher(BedrockAgentCoreControlAsyncClient client, ListApiKeyCredentialProvidersRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListApiKeyCredentialProvidersPublisher(BedrockAgentCoreControlAsyncClient client, ListApiKeyCredentialProvidersRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListApiKeyCredentialProvidersResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListApiKeyCredentialProvidersResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<ApiKeyCredentialProviderItem> credentialProviders() {
        Function<ListApiKeyCredentialProvidersResponse, Iterator> getIterator = response -> {
            if (response != null && response.credentialProviders() != null) {
                return response.credentialProviders().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListApiKeyCredentialProvidersResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListApiKeyCredentialProvidersResponseFetcher
    implements AsyncPageFetcher<ListApiKeyCredentialProvidersResponse> {
        private ListApiKeyCredentialProvidersResponseFetcher() {
        }

        public boolean hasNextPage(ListApiKeyCredentialProvidersResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListApiKeyCredentialProvidersResponse> nextPage(ListApiKeyCredentialProvidersResponse previousPage) {
            if (previousPage == null) {
                return ListApiKeyCredentialProvidersPublisher.this.client.listApiKeyCredentialProviders(ListApiKeyCredentialProvidersPublisher.this.firstRequest);
            }
            return ListApiKeyCredentialProvidersPublisher.this.client.listApiKeyCredentialProviders((ListApiKeyCredentialProvidersRequest)((Object)ListApiKeyCredentialProvidersPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

