/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.BedrockAgentCoreControlRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorConfig;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.EvaluatorLevel;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class CreateEvaluatorRequest
extends BedrockAgentCoreControlRequest
implements ToCopyableBuilder<Builder, CreateEvaluatorRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(CreateEvaluatorRequest.getter(CreateEvaluatorRequest::clientToken)).setter(CreateEvaluatorRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clientToken").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> EVALUATOR_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("evaluatorName").getter(CreateEvaluatorRequest.getter(CreateEvaluatorRequest::evaluatorName)).setter(CreateEvaluatorRequest.setter(Builder::evaluatorName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorName").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(CreateEvaluatorRequest.getter(CreateEvaluatorRequest::description)).setter(CreateEvaluatorRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<EvaluatorConfig> EVALUATOR_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("evaluatorConfig").getter(CreateEvaluatorRequest.getter(CreateEvaluatorRequest::evaluatorConfig)).setter(CreateEvaluatorRequest.setter(Builder::evaluatorConfig)).constructor(EvaluatorConfig::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("evaluatorConfig").build()}).build();
    private static final SdkField<String> LEVEL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("level").getter(CreateEvaluatorRequest.getter(CreateEvaluatorRequest::levelAsString)).setter(CreateEvaluatorRequest.setter(Builder::level)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("level").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, EVALUATOR_NAME_FIELD, DESCRIPTION_FIELD, EVALUATOR_CONFIG_FIELD, LEVEL_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = CreateEvaluatorRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String evaluatorName;
    private final String description;
    private final EvaluatorConfig evaluatorConfig;
    private final String level;

    private CreateEvaluatorRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.evaluatorName = builder.evaluatorName;
        this.description = builder.description;
        this.evaluatorConfig = builder.evaluatorConfig;
        this.level = builder.level;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final String evaluatorName() {
        return this.evaluatorName;
    }

    public final String description() {
        return this.description;
    }

    public final EvaluatorConfig evaluatorConfig() {
        return this.evaluatorConfig;
    }

    public final EvaluatorLevel level() {
        return EvaluatorLevel.fromValue(this.level);
    }

    public final String levelAsString() {
        return this.level;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorName());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.evaluatorConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.levelAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateEvaluatorRequest)) {
            return false;
        }
        CreateEvaluatorRequest other = (CreateEvaluatorRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.evaluatorName(), other.evaluatorName()) && Objects.equals(this.description(), other.description()) && Objects.equals(this.evaluatorConfig(), other.evaluatorConfig()) && Objects.equals(this.levelAsString(), other.levelAsString());
    }

    public final String toString() {
        return ToString.builder((String)"CreateEvaluatorRequest").add("ClientToken", (Object)this.clientToken()).add("EvaluatorName", (Object)this.evaluatorName()).add("Description", (Object)(this.description() == null ? null : "*** Sensitive Data Redacted ***")).add("EvaluatorConfig", (Object)this.evaluatorConfig()).add("Level", (Object)this.levelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "evaluatorName": {
                return Optional.ofNullable(clazz.cast(this.evaluatorName()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "evaluatorConfig": {
                return Optional.ofNullable(clazz.cast(this.evaluatorConfig()));
            }
            case "level": {
                return Optional.ofNullable(clazz.cast(this.levelAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("clientToken", CLIENT_TOKEN_FIELD);
        map.put("evaluatorName", EVALUATOR_NAME_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        map.put("evaluatorConfig", EVALUATOR_CONFIG_FIELD);
        map.put("level", LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateEvaluatorRequest, T> g) {
        return obj -> g.apply((CreateEvaluatorRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends BedrockAgentCoreControlRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String evaluatorName;
        private String description;
        private EvaluatorConfig evaluatorConfig;
        private String level;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateEvaluatorRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.evaluatorName(model.evaluatorName);
            this.description(model.description);
            this.evaluatorConfig(model.evaluatorConfig);
            this.level(model.level);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getEvaluatorName() {
            return this.evaluatorName;
        }

        public final void setEvaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
        }

        @Override
        public final Builder evaluatorName(String evaluatorName) {
            this.evaluatorName = evaluatorName;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final EvaluatorConfig.Builder getEvaluatorConfig() {
            return this.evaluatorConfig != null ? this.evaluatorConfig.toBuilder() : null;
        }

        public final void setEvaluatorConfig(EvaluatorConfig.BuilderImpl evaluatorConfig) {
            this.evaluatorConfig = evaluatorConfig != null ? evaluatorConfig.build() : null;
        }

        @Override
        public final Builder evaluatorConfig(EvaluatorConfig evaluatorConfig) {
            this.evaluatorConfig = evaluatorConfig;
            return this;
        }

        public final String getLevel() {
            return this.level;
        }

        public final void setLevel(String level) {
            this.level = level;
        }

        @Override
        public final Builder level(String level) {
            this.level = level;
            return this;
        }

        @Override
        public final Builder level(EvaluatorLevel level) {
            this.level(level == null ? null : level.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateEvaluatorRequest build() {
            return new CreateEvaluatorRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends BedrockAgentCoreControlRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, CreateEvaluatorRequest> {
        public Builder clientToken(String var1);

        public Builder evaluatorName(String var1);

        public Builder description(String var1);

        public Builder evaluatorConfig(EvaluatorConfig var1);

        default public Builder evaluatorConfig(Consumer<EvaluatorConfig.Builder> evaluatorConfig) {
            return this.evaluatorConfig((EvaluatorConfig)((EvaluatorConfig.Builder)EvaluatorConfig.builder().applyMutation(evaluatorConfig)).build());
        }

        public Builder level(String var1);

        public Builder level(EvaluatorLevel var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

