/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum EvaluatorLevel {
    TOOL_CALL("TOOL_CALL"),
    TRACE("TRACE"),
    SESSION("SESSION"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, EvaluatorLevel> VALUE_MAP;
    private final String value;

    private EvaluatorLevel(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static EvaluatorLevel fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<EvaluatorLevel> knownValues() {
        EnumSet<EvaluatorLevel> knownValues = EnumSet.allOf(EvaluatorLevel.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(EvaluatorLevel.class, EvaluatorLevel::toString);
    }
}

