/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.bedrockagentcorecontrol.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.BedrockAgentCoreControlAsyncClient;
import software.amazon.awssdk.services.bedrockagentcorecontrol.internal.UserAgentUtils;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOnlineEvaluationConfigsRequest;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.ListOnlineEvaluationConfigsResponse;
import software.amazon.awssdk.services.bedrockagentcorecontrol.model.OnlineEvaluationConfigSummary;

public class ListOnlineEvaluationConfigsPublisher
implements SdkPublisher<ListOnlineEvaluationConfigsResponse> {
    private final BedrockAgentCoreControlAsyncClient client;
    private final ListOnlineEvaluationConfigsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListOnlineEvaluationConfigsPublisher(BedrockAgentCoreControlAsyncClient client, ListOnlineEvaluationConfigsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListOnlineEvaluationConfigsPublisher(BedrockAgentCoreControlAsyncClient client, ListOnlineEvaluationConfigsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListOnlineEvaluationConfigsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListOnlineEvaluationConfigsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<OnlineEvaluationConfigSummary> onlineEvaluationConfigs() {
        Function<ListOnlineEvaluationConfigsResponse, Iterator> getIterator = response -> {
            if (response != null && response.onlineEvaluationConfigs() != null) {
                return response.onlineEvaluationConfigs().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListOnlineEvaluationConfigsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListOnlineEvaluationConfigsResponseFetcher
    implements AsyncPageFetcher<ListOnlineEvaluationConfigsResponse> {
        private ListOnlineEvaluationConfigsResponseFetcher() {
        }

        public boolean hasNextPage(ListOnlineEvaluationConfigsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListOnlineEvaluationConfigsResponse> nextPage(ListOnlineEvaluationConfigsResponse previousPage) {
            if (previousPage == null) {
                return ListOnlineEvaluationConfigsPublisher.this.client.listOnlineEvaluationConfigs(ListOnlineEvaluationConfigsPublisher.this.firstRequest);
            }
            return ListOnlineEvaluationConfigsPublisher.this.client.listOnlineEvaluationConfigs((ListOnlineEvaluationConfigsRequest)((Object)ListOnlineEvaluationConfigsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

